/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.IWPEEvent;
import oracle.eclipse.tools.webtier.ui.internal.IWPEOpenCloseListener;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEDataPaletteViewer;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteCustomizationHelper;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteEditPartFactory;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteRoot;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteViewer;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteViewerPage;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPETagsPaletteViewer;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEViewerCommonActionsGroup;
import oracle.eclipse.tools.webtier.ui.palette.internal.editparts.MaximizableDrawerEditPart;
import oracle.eclipse.tools.webtier.ui.palette.internal.editparts.PaletteTreeNodeEditPart;
import oracle.eclipse.tools.webtier.ui.palette.internal.editparts.PaletteTreeRootEditPart;
import oracle.eclipse.tools.webtier.ui.palette.internal.editparts.TemplateEditPart;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteDrawer;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteEntry;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.palette.PinDrawerAction;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.pagedesigner.editors.palette.AbstractPaletteFactory;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PaletteFactory
extends AbstractPaletteFactory {
    public static final String FLYOUT_VIEW_ID = "org.eclipse.jst.pagedesigner.PageDesignerEditor";
    private static final String HELPID = "oracle.eclipse.tools.webtier.ui.DesignPaletteView";
    private OEPEPaletteViewerPage _palettePage;

    public PaletteRoot createPaletteRoot(IEditorInput editorInput) {
        OEPEPaletteRoot root = new OEPEPaletteRoot(editorInput);
        this.addListenerForDisposal(root, editorInput);
        return root;
    }

    private void addListenerForDisposal(final OEPEPaletteRoot root, final IEditorInput editorInput) {
        Activator.getDefault().addWPEOpenCloseListener(new IWPEOpenCloseListener(){

            @Override
            public void notify(IWPEEvent event) {
                if (event.getEventType() == IWPEEvent.EventType.CLOSED) {
                    root.dispose();
                    Activator.getDefault().removeWPEOpenCloseListener(this, editorInput);
                } else if (event.getEventType() == IWPEEvent.EventType.OPENED) {
                    root.activate(event.getWPEInstance());
                } else if (event.getEventType() == IWPEEvent.EventType.ACTIVATED) {
                    root.activate(event.getWPEInstance());
                }
            }
        }, editorInput);
    }

    public PaletteViewerPage createPaletteViewerPage(PaletteViewerProvider provider) {
        this._palettePage = new OEPEPaletteViewerPage(provider);
        return this._palettePage;
    }

    public PaletteViewerProvider createPaletteViewerProvider(EditDomain domain) {
        return new OEPEPaletteViewerProvider(domain);
    }

    private static class HideDrawerAction
    extends Action {
        private final DrawerEditPart drawer;

        public HideDrawerAction(DrawerEditPart drawer, String string) {
            super(string);
            this.drawer = drawer;
        }

        public void run() {
            DesignPaletteDrawer pd = (DesignPaletteDrawer)this.drawer.getDrawer();
            pd.setVisible(false);
            OEPEPaletteCustomizationHelper.hideTaglibDrawer(pd);
        }
    }

    private static class InsertTagOnDoubleClickMouseListener
    implements MouseListener {
        private PaletteViewer _viewer;

        public InsertTagOnDoubleClickMouseListener(PaletteViewer viewer) {
            this._viewer = viewer;
        }

        public void mouseDoubleClick(MouseEvent event) {
            if (event.button == 1) {
                Object model;
                PaletteTreeNodeEditPart part;
                IStructuredSelection ssel = (IStructuredSelection)this._viewer.getSelection();
                if (ssel.getFirstElement() instanceof TemplateEditPart) {
                    TemplateEditPart tagToolPart = (TemplateEditPart)((Object)ssel.getFirstElement());
                    TagToolPaletteEntry tagTool = (TagToolPaletteEntry)tagToolPart.getModel();
                    tagToolPart.getPaletteItem().getPaletteContributor().performInsertTag(tagTool);
                } else if (ssel.getFirstElement() instanceof PaletteTreeNodeEditPart && !((part = (PaletteTreeNodeEditPart)ssel.getFirstElement()) instanceof PaletteTreeRootEditPart) && (model = part.getModel()) instanceof DesignPaletteEntry) {
                    DesignPaletteEntry tagTool = (DesignPaletteEntry)model;
                    tagTool.getPaletteItem().getPaletteContributor().performInsertTag(tagTool);
                }
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    private static class MaximizeDrawerAction
    extends Action {
        private final MaximizableDrawerEditPart drawer;
        private boolean isMaximized;

        public MaximizeDrawerAction(MaximizableDrawerEditPart drawer, boolean isMaximized) {
            this.drawer = drawer;
            this.isMaximized = isMaximized;
            this.setText(isMaximized ? Messages.PaletteFactory_MinimizeCategoryActionLabel : Messages.PaletteFactory_MaximizeCategoryActionLabel);
        }

        public void run() {
            this.drawer.setMaximized(!this.isMaximized);
        }
    }

    public class OEPEPaletteViewerProvider
    extends PaletteViewerProvider {
        public OEPEPaletteViewerProvider(EditDomain graphicalViewerDomain) {
            super(graphicalViewerDomain);
        }

        protected void configurePaletteViewer(PaletteViewer viewer) {
            viewer.setEditPartFactory((EditPartFactory)new OEPEPaletteEditPartFactory());
            viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            viewer.getControl().addMouseListener((MouseListener)new InsertTagOnDoubleClickMouseListener(viewer));
            viewer.setContextMenu((MenuManager)new PaletteContextMenuProvider(viewer){

                public void buildContextMenu(IMenuManager menu) {
                    IStructuredSelection ssel;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window.getActivePage().findView("org.eclipse.gef.ui.palette_view") == null && (ssel = (IStructuredSelection)this.getViewer().getSelection()).getFirstElement() instanceof MaximizableDrawerEditPart) {
                        MenuManager optionsMenu = new MenuManager(Messages.PaletteFactory_flyout_gef_options);
                        new OEPEViewerCommonActionsGroup((IMenuManager)optionsMenu, this.getPaletteViewer());
                        menu.add((IContributionItem)optionsMenu);
                    }
                }

                public void menuAboutToShow(IMenuManager menu) {
                    PaletteTreeNodeEditPart part;
                    IStructuredSelection ssel = (IStructuredSelection)this.getViewer().getSelection();
                    if (ssel.getFirstElement() instanceof MaximizableDrawerEditPart) {
                        MaximizableDrawerEditPart dep = (MaximizableDrawerEditPart)((Object)ssel.getFirstElement());
                        if (dep.getModel() instanceof DesignPaletteDrawer) {
                            DesignPaletteDrawer model = (DesignPaletteDrawer)dep.getModel();
                            menu.add((IAction)new MaximizeDrawerAction(dep, dep.isMaximized()));
                            if (dep.isExpanded() && this.getPaletteViewer().getPaletteViewerPreferences().getAutoCollapseSetting() == 0) {
                                menu.add((IAction)new PinDrawerAction((DrawerEditPart)dep));
                            }
                            if (!dep.isMaximized()) {
                                menu.add((IAction)new HideDrawerAction(dep, Messages.PaletteFactory_HideCategoryActionLabel));
                            }
                            model.getPaletteContributor().fillContextMenu(menu, (Object)dep);
                            menu.add((IContributionItem)new Separator());
                        }
                    } else if (ssel.getFirstElement() instanceof TemplateEditPart) {
                        TemplateEditPart pe = (TemplateEditPart)((Object)ssel.getFirstElement());
                        pe.getPaletteItem().getPaletteContributor().fillContextMenu(menu, pe.getPaletteItem());
                    } else if (ssel.getFirstElement() instanceof PaletteTreeNodeEditPart && !((part = (PaletteTreeNodeEditPart)ssel.getFirstElement()) instanceof PaletteTreeRootEditPart) && part.getModel() instanceof DesignPaletteEntry) {
                        ((DesignPaletteEntry)part.getModel()).getPaletteItem().getPaletteContributor().fillContextMenu(menu, part.getModel());
                    }
                    super.menuAboutToShow(menu);
                }
            });
        }

        public PaletteViewer createPaletteViewer(Composite parent) {
            OEPEPaletteViewer viewer = new OEPEPaletteViewer();
            this.commonCreatePaletteViewer(viewer, parent);
            return viewer;
        }

        public PaletteViewer createTagsPaletteViewer(Composite parent) {
            OEPETagsPaletteViewer viewer = new OEPETagsPaletteViewer();
            this.commonCreatePaletteViewer(viewer, parent);
            return viewer;
        }

        public PaletteViewer createDataPaletteViewer(Composite parent) {
            OEPEDataPaletteViewer viewer = new OEPEDataPaletteViewer();
            this.commonCreatePaletteViewer(viewer, parent);
            return viewer;
        }

        private void commonCreatePaletteViewer(OEPEPaletteViewer viewer, Composite parent) {
            viewer.createControl(parent);
            this.configurePaletteViewer((PaletteViewer)viewer);
            viewer.setCustomizer(viewer.getCustomizer());
            this.hookPaletteViewer((PaletteViewer)viewer);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, PaletteFactory.HELPID);
        }
    }
}

