/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteContributor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class PaletteContributorFactory {
    private static final String PALETTE_CONTRIBUTORS_EXTENSION_POINT_ID = "oracle.eclipse.tools.webtier.ui.paletteCategory";

    public static List<PaletteContributor> getPaletteContributors(IFile file) {
        IConfigurationElement[] contributorElems = Platform.getExtensionRegistry().getConfigurationElementsFor(PALETTE_CONTRIBUTORS_EXTENSION_POINT_ID);
        ArrayList<PaletteContributor> contribs = new ArrayList<PaletteContributor>();
        IConfigurationElement[] iConfigurationElementArray = contributorElems;
        int n = contributorElems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            try {
                Class[] paramTypes;
                Constructor constructor;
                PaletteContributor contrib;
                Bundle bundle = Platform.getBundle((String)elem.getContributor().getName());
                String id = elem.getAttribute("id");
                Class klass = bundle.loadClass(elem.getAttribute("class"));
                String strPriority = elem.getAttribute("priority");
                if (strPriority == null || strPriority.equals("")) {
                    strPriority = "-1";
                }
                Integer priority = Integer.valueOf(strPriority);
                if (PaletteContributor.class.isAssignableFrom(klass) && (contrib = (PaletteContributor)(constructor = klass.getConstructor(paramTypes = new Class[]{String.class, Bundle.class, Integer.class, IFile.class})).newInstance(id, bundle, priority, file)).isActive()) {
                    contribs.add(contrib);
                }
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "oracle.eclipse.tools.webtier.ui", "Problem creating PaletteContributor for " + elem.toString(), (Throwable)e));
            }
            ++n2;
        }
        return PaletteContributorFactory.sort(contribs);
    }

    private static List<PaletteContributor> sort(List<PaletteContributor> contribs) {
        Collections.sort(contribs, new Comparator<PaletteContributor>(){

            @Override
            public int compare(PaletteContributor o1, PaletteContributor o2) {
                if (o1.getPriority() > o2.getPriority()) {
                    return -1;
                }
                if (o1.getPriority() < o2.getPriority()) {
                    return 1;
                }
                return o1.getID().compareTo(o2.getID());
            }
        });
        return contribs;
    }
}

