/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.util.List;
import oracle.eclipse.tools.webtier.ui.palette.internal.ChangeIconSizeTabbedAction;
import oracle.eclipse.tools.webtier.ui.palette.internal.LayoutTabbedAction;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteViewerPage;
import oracle.eclipse.tools.webtier.ui.palette.internal.PaletteFilter;
import oracle.eclipse.tools.webtier.ui.palette.internal.PaletteViewDisplayAction;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.palette.ChangeIconSizeAction;
import org.eclipse.gef.ui.palette.CustomizeAction;
import org.eclipse.gef.ui.palette.LayoutAction;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.SettingsAction;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.gef.ui.palette.customize.PaletteSettingsDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;

public class OEPEViewerCommonActionsGroup
extends ActionGroup {
    public OEPEViewerCommonActionsGroup(IMenuManager menu, PaletteViewer viewer, PaletteFilter filterUI) {
        this.init(menu, viewer, filterUI);
    }

    public OEPEViewerCommonActionsGroup(IMenuManager menu, PaletteViewer viewer) {
        this(menu, viewer, null);
    }

    public OEPEViewerCommonActionsGroup(IMenuManager menu, OEPEPaletteViewerPage.CurrentViewer currentViewer) {
        this.init(menu, currentViewer);
    }

    private void init(IMenuManager menu, PaletteViewer viewer, final PaletteFilter filterUI) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
        menu.appendToGroup("org.eclipse.gef.group.view", (IAction)new LayoutAction(viewer.getPaletteViewerPreferences()));
        menu.appendToGroup("org.eclipse.gef.group.view", (IAction)new ChangeIconSizeAction(viewer.getPaletteViewerPreferences()));
        if (viewer.getCustomizer() != null) {
            menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new MyCustomizeAction(viewer, filterUI));
        }
        menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new MySettingsAction(viewer, filterUI));
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        menu.add((IAction)new PaletteViewDisplayAction(window, filterUI));
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (filterUI != null) {
                    int i = 0;
                    while (i < manager.getItems().length) {
                        ActionContributionItem action;
                        IContributionItem item = manager.getItems()[i];
                        if (item instanceof ActionContributionItem && ((action = (ActionContributionItem)item).getAction() instanceof CustomizeAction || action.getAction() instanceof SettingsAction)) {
                            action.setVisible(!filterUI.isInFiltrationMode());
                        }
                        ++i;
                    }
                    manager.updateAll(true);
                }
            }
        });
    }

    private void init(IMenuManager menu, final OEPEPaletteViewerPage.CurrentViewer currentViewer) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
        menu.appendToGroup("org.eclipse.gef.group.view", (IAction)new LayoutTabbedAction(currentViewer));
        menu.appendToGroup("org.eclipse.gef.group.view", (IAction)new ChangeIconSizeTabbedAction(currentViewer));
        menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new MyCustomizeTabbedAction(currentViewer));
        menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new MySettingsTabbedAction(currentViewer));
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        menu.add((IAction)new PaletteViewDisplayAction(window, currentViewer.getViewer().getFilterUI()));
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (currentViewer.getViewer().getFilterUI() != null) {
                    int i = 0;
                    while (i < manager.getItems().length) {
                        IContributionItem item = manager.getItems()[i];
                        if (item instanceof ActionContributionItem) {
                            ActionContributionItem action = (ActionContributionItem)item;
                            if (action.getAction() instanceof MyCustomizeTabbedAction) {
                                action.setVisible(currentViewer.getViewer().showCustomize());
                            } else if (action.getAction() instanceof MySettingsTabbedAction) {
                                action.setVisible(currentViewer.getViewer().showSettings());
                            } else if (action.getAction() instanceof LayoutTabbedAction) {
                                action.setVisible(currentViewer.getViewer().showLayout());
                            } else if (action.getAction() instanceof ChangeIconSizeTabbedAction) {
                                action.setVisible(currentViewer.getViewer().showUseLargeIcons());
                            }
                        }
                        ++i;
                    }
                    manager.updateAll(true);
                }
            }
        });
    }

    private static class MyCustomizeAction
    extends CustomizeAction {
        private PaletteFilter _filter;

        public MyCustomizeAction(PaletteViewer palette, PaletteFilter filter) {
            super(palette);
            this._filter = filter;
        }

        public boolean isEnabled() {
            if (this._filter != null) {
                return !this._filter.isInFiltrationMode() && super.isEnabled();
            }
            return super.isEnabled();
        }
    }

    private static class MyCustomizeTabbedAction
    extends Action {
        private final OEPEPaletteViewerPage.CurrentViewer _viewer;

        public MyCustomizeTabbedAction(OEPEPaletteViewerPage.CurrentViewer viewer) {
            this.setText(PaletteMessages.MENU_OPEN_CUSTOMIZE_DIALOG);
            this._viewer = viewer;
        }

        public boolean isEnabled() {
            PaletteFilter filter = this._viewer.getViewer().getFilterUI();
            if (filter != null) {
                return !filter.isInFiltrationMode() && super.isEnabled();
            }
            return super.isEnabled();
        }

        public void run() {
            PaletteEntry selection;
            PaletteCustomizerDialog dialog = this._viewer.getViewer().getCustomizerDialog();
            List list = this._viewer.getViewer().getSelectedEditParts();
            if (!list.isEmpty() && !((selection = (PaletteEntry)((EditPart)list.get(0)).getModel()) instanceof PaletteRoot)) {
                dialog.setDefaultSelection(selection);
            }
            dialog.open();
        }
    }

    private static class MySettingsAction
    extends SettingsAction {
        private PaletteFilter _filter;

        public MySettingsAction(PaletteViewer palette, PaletteFilter filter) {
            super(palette);
            this._filter = filter;
        }

        public boolean isEnabled() {
            if (this._filter != null) {
                return !this._filter.isInFiltrationMode() && super.isEnabled();
            }
            return super.isEnabled();
        }
    }

    private static class MySettingsTabbedAction
    extends Action {
        private final OEPEPaletteViewerPage.CurrentViewer _viewer;

        public MySettingsTabbedAction(OEPEPaletteViewerPage.CurrentViewer viewer) {
            this.setText(PaletteMessages.MENU_OPEN_SETTINGS_DIALOG);
            this._viewer = viewer;
        }

        public boolean isEnabled() {
            PaletteFilter filter = this._viewer.getViewer().getFilterUI();
            if (filter != null) {
                return !filter.isInFiltrationMode() && super.isEnabled();
            }
            return super.isEnabled();
        }

        public void run() {
            PaletteSettingsDialog settings = new PaletteSettingsDialog(this._viewer.getViewer().getControl().getShell(), this._viewer.getViewer().getPaletteViewerPreferences());
            settings.open();
        }
    }
}

