/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.util.List;
import oracle.eclipse.tools.webtier.ui.palette.internal.AbstractOEPEPaletteRoot;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteViewer;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEViewerCommonActionsGroup;
import oracle.eclipse.tools.webtier.ui.palette.internal.PaletteFactory;
import oracle.eclipse.tools.webtier.ui.palette.internal.PaletteFilter;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteContributor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.IPageSite;

public class OEPEPaletteViewerPage
extends PaletteViewerPage
implements SelectionListener {
    private Composite _container;
    private PaletteFilter tagsFilterUI;
    private PaletteFilter dataFilterUI;
    private OEPEPaletteViewer tagsViewer;
    private OEPEPaletteViewer dataViewer;
    private CurrentViewer currentViewer;
    private IPartListener2 _partListener;

    public OEPEPaletteViewerPage(PaletteViewerProvider pvProvider) {
        super(pvProvider);
    }

    public void createControl(Composite parent) {
        this._container = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.marginTop = 2;
        this._container.setLayout((Layout)gl);
        TabFolder tabFolder = new TabFolder(this._container, 128);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem tagsTab = new TabItem(tabFolder, 0);
        tagsTab.setText("Tags");
        Composite tagsComp = new Composite((Composite)tabFolder, 0);
        tagsComp.setLayoutData((Object)new GridData(4, 4, true, true));
        tagsComp.setLayout((Layout)gl);
        this.tagsFilterUI = new PaletteFilter(tagsComp, 0);
        this.tagsViewer = (OEPEPaletteViewer)((PaletteFactory.OEPEPaletteViewerProvider)this.provider).createTagsPaletteViewer(tagsComp);
        this.tagsViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tagsViewer.setFocus((EditPart)this.tagsViewer.getEditPartRegistry().get(0));
        this.tagsViewer.setFilterUI(this.tagsFilterUI);
        tagsTab.setControl((Control)tagsComp);
        tagsTab.setData((Object)this.tagsViewer);
        TabItem dataTab = new TabItem(tabFolder, 0);
        dataTab.setText("Data");
        Composite dataComp = new Composite((Composite)tabFolder, 0);
        dataComp.setLayoutData((Object)new GridData(4, 4, true, true));
        dataComp.setLayout((Layout)gl);
        this.dataFilterUI = new PaletteFilter(dataComp, 0);
        this.dataViewer = (OEPEPaletteViewer)((PaletteFactory.OEPEPaletteViewerProvider)this.provider).createDataPaletteViewer(dataComp);
        this.dataViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.dataViewer.setFocus((EditPart)this.dataViewer.getEditPartRegistry().get(0));
        this.dataViewer.setFilterUI(this.dataFilterUI);
        dataTab.setControl((Control)dataComp);
        dataTab.setData((Object)this.dataViewer);
        this.currentViewer = new CurrentViewer(this.tagsViewer);
        tabFolder.addSelectionListener((SelectionListener)this.currentViewer);
        this.provider.getEditDomain().setPaletteViewer((PaletteViewer)this.tagsViewer);
        tabFolder.pack();
    }

    public void widgetSelected(SelectionEvent e) {
        Object data;
        if (e.item instanceof TabItem && (data = ((TabItem)e.item).getData()) instanceof OEPEPaletteViewer) {
            this.provider.getEditDomain().setPaletteViewer((PaletteViewer)data);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Control getControl() {
        return this._container;
    }

    public OEPEPaletteViewer getDataPaletteViewer() {
        return this.dataViewer;
    }

    public void dispose() {
        IPageSite site = this.getSite();
        if (site != null && this._partListener != null) {
            IWorkbenchPage page = site.getPage();
            if (page != null) {
                page.removePartListener(this._partListener);
            }
            this._partListener = null;
        }
        if (this.tagsFilterUI != null) {
            this.tagsFilterUI.dispose();
        }
        if (this.dataFilterUI != null) {
            this.dataFilterUI.dispose();
        }
        if (this._container != null) {
            this._container.dispose();
        }
        if (this.provider.getEditDomain().getPaletteViewer() == this.tagsViewer || this.provider.getEditDomain().getPaletteViewer() == this.dataViewer) {
            this.provider.getEditDomain().setPaletteViewer(null);
        }
        super.dispose();
        this.tagsViewer = null;
        this.dataViewer = null;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        this.addCommonActionsToPullDownMenu(menuManager);
        AbstractOEPEPaletteRoot root = (AbstractOEPEPaletteRoot)this.provider.getEditDomain().getPaletteViewer().getPaletteRoot();
        this.fillToolBar(toolBarManager, root.getActivePaletteCategoryContributors());
        this.fillPullDownMenu(menuManager, root.getActivePaletteCategoryContributors());
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        if (this.tagsFilterUI != null) {
            this.tagsFilterUI.setViewer(this.tagsViewer);
        }
        if (this.dataFilterUI != null) {
            this.dataFilterUI.setViewer(this.dataViewer);
        }
        this.addViewListeners(pageSite);
    }

    private void addViewListeners(IPageSite pageSite) {
        this._partListener = new IPartListener2(){
            private boolean isRunning;

            public void partHidden(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals("org.eclipse.gef.ui.palette_view") && !this.isRunning) {
                    try {
                        this.isRunning = true;
                        if (OEPEPaletteViewerPage.this.tagsFilterUI != null) {
                            OEPEPaletteViewerPage.this.tagsFilterUI.resetFilterText();
                            OEPEPaletteViewerPage.this.tagsFilterUI.restoreAutoCollapseSetting();
                        }
                        if (OEPEPaletteViewerPage.this.dataFilterUI != null) {
                            OEPEPaletteViewerPage.this.dataFilterUI.resetFilterText();
                            OEPEPaletteViewerPage.this.dataFilterUI.restoreAutoCollapseSetting();
                        }
                    }
                    finally {
                        this.isRunning = false;
                    }
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        pageSite.getPage().addPartListener(this._partListener);
    }

    private void addCommonActionsToPullDownMenu(IMenuManager menu) {
        new OEPEViewerCommonActionsGroup(menu, this.currentViewer);
    }

    private void fillPullDownMenu(IMenuManager menuManager, List<PaletteContributor> contributors) {
        for (PaletteContributor contributor : contributors) {
            contributor.fillPullDownMenu(menuManager);
        }
    }

    private void fillToolBar(IToolBarManager toolBarManager, List<PaletteContributor> contributors) {
        for (PaletteContributor contributor : contributors) {
            contributor.fillToolBar(toolBarManager);
        }
    }

    public static final class CurrentViewer
    implements SelectionListener {
        private OEPEPaletteViewer _viewer;

        public CurrentViewer(OEPEPaletteViewer initialViewer) {
            this._viewer = initialViewer;
        }

        public OEPEPaletteViewer getViewer() {
            return this._viewer;
        }

        public void widgetSelected(SelectionEvent e) {
            Object data;
            if (e.item instanceof TabItem && (data = ((TabItem)e.item).getData()) instanceof OEPEPaletteViewer) {
                this._viewer = (OEPEPaletteViewer)data;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

