/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.webtier.ui.palette.internal.AbstractOEPEPaletteRoot;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEDataPaletteViewer;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteCustomizationHelper;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteViewerPage;
import oracle.eclipse.tools.webtier.ui.palette.internal.PaletteContributorFactory;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteDrawer;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteEntry;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteCategory;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteContributor;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteItem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.part.FileEditorInput;

public final class OEPEPaletteRoot
extends AbstractOEPEPaletteRoot {
    private List<PaletteContributor> _paletteCategoryContributors;
    private IFile _file;
    private boolean _isHTMLPage;

    public OEPEPaletteRoot(IEditorInput editorInput) {
        if (editorInput instanceof FileEditorInput) {
            this._file = this.getFile(editorInput);
        }
        this._isHTMLPage = this.isHtmlPage(editorInput);
        this.resetPaletteRoot();
    }

    private IFile getFile(IEditorInput editorInput) {
        return ((FileEditorInput)editorInput).getFile();
    }

    private void addListenerForFileRename(final HTMLEditor editor) {
        if (editor != null) {
            editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 1 || propId == 260) {
                        IEditorPart editorPart = editor.getActiveEditor();
                        IEditorInput editorInput = editorPart.getEditorInput();
                        if (OEPEPaletteRoot.this._file != OEPEPaletteRoot.this.getFile(editorInput)) {
                            OEPEPaletteRoot.this._file = OEPEPaletteRoot.this.getFile(editorInput);
                            VariablesController.getInstance().getFileCache(OEPEPaletteRoot.this._file, true, true);
                            this.updateContributors(OEPEPaletteRoot.this._file);
                            OEPEPaletteRoot.this.resetPaletteRoot();
                            OEPEPaletteViewerPage viewerPage = (OEPEPaletteViewerPage)((Object)editor.getAdapter(PalettePage.class));
                            OEPEDataPaletteViewer viewer = (OEPEDataPaletteViewer)viewerPage.getDataPaletteViewer();
                            if (viewer != null) {
                                viewer.setPaletteRoot(null);
                                viewer.setPaletteRoot(OEPEPaletteRoot.this);
                            }
                        }
                    }
                }

                private void updateContributors(IFile newFile) {
                    if (OEPEPaletteRoot.this._paletteCategoryContributors != null) {
                        for (PaletteContributor contrib : OEPEPaletteRoot.this._paletteCategoryContributors) {
                            contrib.updateFile(newFile);
                        }
                    }
                }
            });
        }
    }

    @Override
    public IProject getProject() {
        if (this._file != null) {
            return this._file.getProject();
        }
        return null;
    }

    public void resetPaletteRoot() {
        this.getChildren().clear();
        for (PaletteContributor contrib : this.getPaletteCategoryContributors()) {
            this.addDrawers(contrib);
        }
        List<DesignPaletteDrawer> newDrawers = OEPEPaletteCustomizationHelper.loadUserCustomizations(this);
        if (!newDrawers.isEmpty()) {
            this.applySystemFilters(newDrawers);
            OEPEPaletteCustomizationHelper.save(this);
        }
        this.pinOpenSingleCategory();
    }

    private void pinOpenSingleCategory() {
        if (this.getChildren().size() == 2) {
            DesignPaletteDrawer drawer = (DesignPaletteDrawer)this.getChildren().get(1);
            drawer.setInitialState(2);
        }
    }

    private void addDrawers(PaletteContributor contributor) {
        List<PaletteCategory> drawers = contributor.getContributions();
        for (PaletteCategory drawer : drawers) {
            if (this.filterForFileType(drawer)) continue;
            DesignPaletteDrawer ddrawer = this.toDrawer(new PaletteCategory(drawer), contributor);
            this.setInitialVisibility(this, ddrawer);
            this.add((PaletteEntry)ddrawer);
        }
    }

    private void applySystemFilters(List<DesignPaletteDrawer> newDrawers) {
        for (DesignPaletteDrawer drawer : newDrawers) {
            drawer.setVisible(!drawer.getPaletteContributor().applySystemFilter(drawer.getCategoryModel()));
        }
    }

    @Override
    public List<PaletteContributor> getActivePaletteCategoryContributors() {
        if (this._paletteCategoryContributors == null) {
            this._paletteCategoryContributors = this.getPaletteCategoryContributors();
        }
        return this._paletteCategoryContributors;
    }

    private List<PaletteContributor> getPaletteCategoryContributors() {
        if (this._paletteCategoryContributors == null && this._file != null) {
            this._paletteCategoryContributors = PaletteContributorFactory.getPaletteContributors(this._file);
        } else if (this._file == null) {
            return Collections.emptyList();
        }
        return this._paletteCategoryContributors;
    }

    private void setInitialVisibility(PaletteRoot root, DesignPaletteDrawer ddrawer) {
        if (ddrawer.getChildren().size() == 0) {
            ddrawer.setVisible(false);
        } else {
            int i = 1;
            while (i < root.getChildren().size()) {
                DesignPaletteDrawer drawer = (DesignPaletteDrawer)root.getChildren().get(i);
                if (drawer.getCategoryModelID().equals(ddrawer.getCategoryModelID())) {
                    ddrawer.setVisible(false);
                }
                ++i;
            }
        }
    }

    private DesignPaletteDrawer toDrawer(PaletteCategory category, PaletteContributor contrib) {
        DesignPaletteDrawer drawer = new DesignPaletteDrawer(category, contrib);
        List<PaletteItem> items = category.getPaletteItems();
        for (PaletteItem nextItem : items) {
            drawer.add((PaletteEntry)new DesignPaletteEntry(nextItem, contrib));
        }
        drawer.setInitialState(category.isInitiallyOpen() ? 0 : 1);
        drawer.setDescription(category.getToolTip());
        return drawer;
    }

    private boolean filterForFileType(PaletteCategory drawer) {
        return this._isHTMLPage && drawer != null && !drawer.getID().equalsIgnoreCase("html");
    }

    private boolean isHtmlPage(IEditorInput editorInput) {
        String ext;
        String fileName;
        int dotPos;
        return editorInput != null && (dotPos = (fileName = editorInput.getName().toLowerCase()).indexOf(".")) > 0 && ((ext = fileName.substring(dotPos + 1)).equals("htm") || ext.equals("html"));
    }

    public List<DesignPaletteDrawer> getDrawersForContributor(PaletteContributor contributor) {
        ArrayList<DesignPaletteDrawer> drawers = new ArrayList<DesignPaletteDrawer>();
        int i = 0;
        while (i < this.getChildren().size()) {
            DesignPaletteDrawer drawer;
            PaletteContainer container = (PaletteContainer)this.getChildren().get(i);
            if (container instanceof DesignPaletteDrawer && (drawer = (DesignPaletteDrawer)container).getPaletteContributor() == contributor) {
                drawers.add(drawer);
            }
            ++i;
        }
        return drawers;
    }

    public void dispose() {
        if (this._paletteCategoryContributors != null) {
            for (PaletteContributor contrib : this.getActivePaletteCategoryContributors()) {
                contrib.dispose();
            }
            this._paletteCategoryContributors.clear();
        }
        this._file = null;
        this._paletteCategoryContributors = null;
    }

    public void activate(HTMLEditor editor) {
        this.addListenerForFileRename(editor);
    }
}

