/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteCustomizationHelper;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteCustomizer;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteRoot;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizationAction;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OEPEPaletteCustomizationDialog
extends PaletteCustomizerDialog {
    private static final String DEFAULT_CUSTOMIZATIONS_EXPORT_FILENAME = "OEPEPaletteCustomizations.xml";
    private static String DEFAULTEXTENSION = ".xml";

    public OEPEPaletteCustomizationDialog(Shell shell, OEPEPaletteCustomizer customizer, PaletteViewer paletteViewer) {
        super(shell, (PaletteCustomizer)customizer, paletteViewer.getPaletteRoot());
    }

    public Action getImportAction() {
        return new ImportAction(this);
    }

    public Action getExportAction() {
        return new ExportAction();
    }

    protected List createOutlineActions() {
        List actions = super.createOutlineActions();
        actions.remove(0);
        actions.remove(0);
        actions.add(new ImportAction(this));
        actions.add(new ExportAction());
        return actions;
    }

    protected TreeViewer createOutlineTreeViewer(Composite composite) {
        TreeViewer viewer = super.createOutlineTreeViewer(composite);
        viewer.setContentProvider((IContentProvider)new OEPEPaletteContentProvider());
        return viewer;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private ImageDescriptor getImageDesc(String imgName) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.webtier.ui", (String)("icons/small/" + imgName));
    }

    private class ExportAction
    extends PaletteCustomizationAction {
        private ImageDescriptor exportImgDesc;

        public ExportAction() {
            this.exportImgDesc = OEPEPaletteCustomizationDialog.this.getImageDesc("Palette_Export.gif");
            this.setEnabled(true);
            this.setText(Messages.OEPEPaletteCustomizationDialog_Export);
            this.setImageDescriptor(this.exportImgDesc);
        }

        private void handleExport() {
            FileDialog fileDialog = new FileDialog(OEPEPaletteCustomizationDialog.this.getShell(), 8192);
            fileDialog.setFileName(OEPEPaletteCustomizationDialog.DEFAULT_CUSTOMIZATIONS_EXPORT_FILENAME);
            String[] filterExtensions = new String[]{"*.xml", "*.*"};
            fileDialog.setFilterExtensions(filterExtensions);
            fileDialog.setText(Messages.OEPEPaletteCustomizationDialog_Export_Dialog_Titlle);
            String filename = fileDialog.open();
            if (filename != null) {
                if (!filename.endsWith(DEFAULTEXTENSION)) {
                    filename = String.valueOf(filename) + DEFAULTEXTENSION;
                }
                OEPEPaletteCustomizationHelper.exportCustomizations((OEPEPaletteRoot)OEPEPaletteCustomizationDialog.this.getPaletteRoot(), filename);
                OEPEPaletteCustomizationDialog.this.updateActions();
            }
        }

        public void run() {
            this.handleExport();
        }

        public void update() {
        }
    }

    private class ImportAction
    extends PaletteCustomizationAction {
        private OEPEPaletteCustomizationDialog dialog;
        private ImageDescriptor importImgDesc;

        public ImportAction(OEPEPaletteCustomizationDialog dialog) {
            this.importImgDesc = OEPEPaletteCustomizationDialog.this.getImageDesc("Palette_Import.gif");
            this.dialog = dialog;
            this.setEnabled(true);
            this.setText(Messages.OEPEPaletteCustomizationDialog_Import);
            this.setImageDescriptor(this.importImgDesc);
        }

        private void handleImport() {
            FileDialog fileDialog = new FileDialog(OEPEPaletteCustomizationDialog.this.getShell());
            fileDialog.setFileName(OEPEPaletteCustomizationDialog.DEFAULT_CUSTOMIZATIONS_EXPORT_FILENAME);
            String[] filterExtensions = new String[]{"*.xml", "*.*"};
            fileDialog.setFilterExtensions(filterExtensions);
            fileDialog.setText(Messages.OEPEPaletteCustomizationDialog_Import_Dialog_Title);
            String filename = fileDialog.open();
            if (filename != null) {
                OEPEPaletteCustomizationDialog.this.setActiveEntry(null);
                this.dialog.close();
                OEPEPaletteCustomizationHelper.importCustomizations((OEPEPaletteCustomizer)OEPEPaletteCustomizationDialog.this.getCustomizer(), filename);
                this.dialog.open();
            }
        }

        public void run() {
            this.handleImport();
        }

        public void update() {
        }
    }

    private static class OEPEPaletteContentProvider
    implements ITreeContentProvider {
        private OEPEPaletteContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PaletteRoot) {
                ArrayList<PaletteEntry> libs = new ArrayList<PaletteEntry>();
                List children = ((PaletteRoot)parentElement).getChildren();
                if (!children.isEmpty()) {
                    for (PaletteEntry entry : children) {
                        if (!(entry instanceof DesignPaletteDrawer)) continue;
                        libs.add(entry);
                    }
                    if (!libs.isEmpty()) {
                        return libs.toArray();
                    }
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            return ((PaletteEntry)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = new Object[]{};
            if (inputElement instanceof PaletteRoot && (elements = this.getChildren(inputElement)) == null) {
                elements = new Object[]{};
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

