/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.webtier.ui.palette.internal.AbstractOEPEPaletteRoot;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteRoot;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteDrawer;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteContributor;
import org.eclipse.core.resources.IProject;

public class OEPEFilteredPaletteRoot
extends AbstractOEPEPaletteRoot {
    private final OEPEPaletteRoot _delegate;
    private final List<String> _contributorIds;

    OEPEFilteredPaletteRoot(OEPEPaletteRoot root, List<String> contributorIds) {
        this._delegate = root;
        this._contributorIds = new ArrayList<String>(contributorIds);
    }

    @Override
    public List<PaletteContributor> getActivePaletteCategoryContributors() {
        ArrayList<PaletteContributor> contributors = new ArrayList<PaletteContributor>();
        for (PaletteContributor contributor : this._delegate.getActivePaletteCategoryContributors()) {
            if (!this._contributorIds.contains(contributor.getID())) continue;
            contributors.add(contributor);
        }
        return contributors;
    }

    public List getChildren() {
        ArrayList overrideChildren = new ArrayList();
        for (Object object : this._delegate.getChildren()) {
            if (object instanceof DesignPaletteDrawer) {
                String drawerId = ((DesignPaletteDrawer)object).getPaletteContributor().getID();
                for (String id : this._contributorIds) {
                    if (!(drawerId == null ? id == null : drawerId.equals(id))) continue;
                    overrideChildren.add(object);
                }
                continue;
            }
            overrideChildren.add(object);
        }
        return overrideChildren;
    }

    @Override
    public IProject getProject() {
        return this._delegate.getProject();
    }
}

