/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteViewerPage;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class LayoutTabbedAction
extends Action
implements IMenuCreator {
    private final OEPEPaletteViewerPage.CurrentViewer _viewer;

    public LayoutTabbedAction(OEPEPaletteViewerPage.CurrentViewer viewer) {
        super(PaletteMessages.LAYOUT_MENU_LABEL);
        this._viewer = viewer;
        this.setMenuCreator(this);
        this.setToolTipText(PaletteMessages.LAYOUT_MENU_LABEL);
    }

    private PaletteViewerPreferences getPreferences() {
        return this._viewer.getViewer().getPaletteViewerPreferences();
    }

    protected void addActionToMenu(Menu parent, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(parent, -1);
    }

    protected List createActions() {
        ArrayList<LayoutChangeAction> list = new ArrayList<LayoutChangeAction>();
        int[] modes = this.getPreferences().getSupportedLayoutModes();
        int i = 0;
        while (i < modes.length) {
            switch (modes[i]) {
                case 1: {
                    LayoutChangeAction action = new LayoutChangeAction(1, PaletteMessages.SETTINGS_COLUMNS_VIEW_LABEL);
                    list.add(action);
                    break;
                }
                case 0: {
                    LayoutChangeAction action = new LayoutChangeAction(0, PaletteMessages.SETTINGS_LIST_VIEW_LABEL);
                    list.add(action);
                    break;
                }
                case 2: {
                    LayoutChangeAction action = new LayoutChangeAction(2, PaletteMessages.SETTINGS_ICONS_VIEW_LABEL_CAPS);
                    list.add(action);
                    break;
                }
                case 3: {
                    LayoutChangeAction action = new LayoutChangeAction(3, PaletteMessages.SETTINGS_DETAILS_VIEW_LABEL);
                    list.add(action);
                }
            }
            ++i;
        }
        return list;
    }

    public void dispose() {
    }

    private Menu fillMenu(Menu menu) {
        List actions = this.createActions();
        for (LayoutChangeAction action : actions) {
            action.setChecked(this.getPreferences().getLayoutSetting() == action.getLayoutSetting());
            this.addActionToMenu(menu, (IAction)action);
        }
        this.setEnabled(!actions.isEmpty());
        return menu;
    }

    public Menu getMenu(Control parent) {
        return this.fillMenu(new Menu(parent));
    }

    public Menu getMenu(Menu parent) {
        return this.fillMenu(new Menu(parent));
    }

    private class LayoutChangeAction
    extends Action {
        private int layoutSetting;

        public LayoutChangeAction(int layoutSetting, String text) {
            super(text, 8);
            this.layoutSetting = layoutSetting;
        }

        public int getLayoutSetting() {
            return this.layoutSetting;
        }

        public void run() {
            LayoutTabbedAction.this.getPreferences().setLayoutSetting(this.layoutSetting);
        }
    }
}

