/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.method;

import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.text.edits.TextEdit;

public class MethodCreator {
    public void createMethod(MethodReference methodRef, String methodBody, Project project, IFile file) throws Exception {
        String className;
        IJavaProject javaPrj = JavaCore.create((IProject)project.getEclipseProject());
        IType eclipseType = javaPrj.findType(className = methodRef.getValueReference().getType((IModelContext)new FilePositionContext(file)).getName());
        ICompilationUnit cu = eclipseType.getCompilationUnit();
        if (cu == null) {
            throw new Exception(Messages.bind((String)Messages.MethodCreator_NoSourceCodeError, (Object)className));
        }
        boolean isWorkingCopy = cu.isWorkingCopy();
        ImportRewrite imports = MethodCreator.getImportsStructure(cu);
        this.internalCreateMethod(eclipseType, imports, methodRef, javaPrj, methodBody, true);
        TextEdit edit = imports.rewriteImports(null);
        JavaModelUtil.applyEdit((ICompilationUnit)cu, (TextEdit)edit, (!isWorkingCopy ? 1 : 0) != 0, null);
        if (isWorkingCopy) {
            this.commitCompilationUnit(cu);
        }
    }

    protected void internalCreateMethod(IType eclipseType, ImportRewrite imports, MethodReference methodRef, IJavaProject javaPrj, String methodBody, boolean formatMethod) throws Exception {
        StringBuffer contents = new StringBuffer();
        contents.append("public ");
        String returnType = methodRef.getMethodReturnType().getName();
        boolean isVoid = returnType.equals(Void.TYPE.getName());
        if (isVoid) {
            contents.append("void");
        } else {
            contents.append(imports.addImport(returnType));
        }
        contents.append(" " + methodRef.getMethodName() + '(');
        List paramDataTypes = methodRef.getMethodParameterTypes();
        int i = 0;
        while (i < paramDataTypes.size()) {
            if (i > 0) {
                contents.append(',');
            }
            contents.append(imports.addImport(((DataType)paramDataTypes.get(i)).getName()));
            contents.append(' ');
            contents.append('p');
            contents.append(i);
            ++i;
        }
        contents.append(") {");
        if (methodBody == null) {
            if (!isVoid) {
                contents.append("return null;");
            }
        } else {
            contents.append('\n');
            contents.append(methodBody);
        }
        contents.append("\n");
        contents.append(Messages.MethodCreator_AutoGenTodoMsg);
        contents.append("\n");
        contents.append("}\n\n");
        String methodContents = formatMethod ? this.formatMethod(contents.toString(), javaPrj) : contents.toString();
        eclipseType.createMethod(methodContents, null, false, null);
    }

    private static ImportRewrite getImportsStructure(ICompilationUnit cu) {
        try {
            return ImportRewrite.create((ICompilationUnit)cu, (boolean)true);
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)e, (String)("EclipseTypeUtil.getImportsStructure" + (Object)((Object)e)));
            return null;
        }
    }

    protected String formatMethod(String methodBody, IJavaProject javaPrj) {
        return CodeFormatterUtil.format((int)4, (String)methodBody, (int)1, null, (IJavaProject)javaPrj);
    }

    protected void commitCompilationUnit(ICompilationUnit cu) throws JavaModelException {
        cu.commitWorkingCopy(false, null);
    }
}

