/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.locale;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.documentservices.DOMUtil;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceFactory;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.AbstractAttributeValueResolver;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ELAttributeValueResolver
extends AbstractAttributeValueResolver {
    private final DOMUtil _domUtil = new DOMUtil();

    public boolean canResolve(Element originalElement, Element convertedElement, String convertedAttrName, String convertedAttrValue) {
        return !this.getExpression(originalElement, convertedAttrName, convertedAttrValue).isEmpty();
    }

    public String resolveAttribute(Element originalElement, Element convertedElement, String convertedAttrName, String convertedAttrValue) {
        List<ValueReference> expressions = this.getExpression(originalElement, convertedAttrName, convertedAttrValue);
        for (ValueReference expr : expressions) {
            Variable var = expr.getVariable();
            DataType type = var.getType();
            if (!(type instanceof JavaResourceBundleDataType)) continue;
            int offset = 0;
            if (originalElement instanceof IDOMElement) {
                offset = ((IDOMElement)originalElement).getStartEndOffset();
            }
            IDocument document = this.getDocument(originalElement);
            DataType.Field field = type.getField(expr.getFieldName(), (IModelContext)new FilePositionContext(offset, document.getFile()));
            if (!(field instanceof JavaResourceBundleDataType.ResourceBundleField)) continue;
            return ((JavaResourceBundleDataType.ResourceBundleField)field).getValue();
        }
        return null;
    }

    private List<ValueReference> getExpression(Element originalElement, String convertedAttrName, String convertedAttrValue) {
        if ("value".equals(convertedAttrName) || "#text".equals(convertedAttrName)) {
            IDocument document = this.getDocument(originalElement);
            ValueReferenceELParser parser = new ValueReferenceELParser();
            ELExpression simpleELExpression = parser.getSimpleELExpression(convertedAttrValue);
            if (simpleELExpression != null) {
                return new ValueReferenceFactory().createValueReference(simpleELExpression.getElText(), (VariableQuery)new DocumentVariableQuery(document, -1, true));
            }
        }
        return Collections.EMPTY_LIST;
    }

    private IDocument getDocument(Element originalElement) {
        IDocument document = this._domUtil.getDocumentForNode((Node)originalElement);
        return document;
    }
}

