/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.internal.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.documentservices.AbstractDocumentContentGenerator;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentContentProvider;
import oracle.eclipse.tools.application.common.services.techextservices.EnumVarGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.FieldsGenerator;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.ValueReferenceHolder;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.ValueReferenceTreeContentProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableIdentifierHelper;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesTreeLabelProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.HideStringFieldsFilter;
import oracle.eclipse.tools.webtier.ui.utils.TypeUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class VariableTagDropWizard
extends Wizard
implements INewWizard {
    private ChooseGeneratorWizardPage _chooseGeneratorPage;
    private SelectFieldsWizardPage _selectFieldsPage;
    private OrderFieldsWizardPage _orderFieldsPage;
    private IteratorVariableWizardPage _iterVarPage;
    private EObject _rootObject;
    private final TagIdentifier _tagToDrop;
    private final IDocument _doc;
    private final IDocumentContentProvider _contentProvider;
    private final IDOMPosition _position;
    private ValueReference _valRef;
    private List<? extends AbstractDocumentContentGenerator> _generators;
    private boolean _isFieldsGenerator;
    private ImageDescriptor _wizImageDescriptor;
    private static final String HELPID_FIELDS = "oracle.eclipse.tools.webtier.ui.InsertFieldsWizard";
    private static final String HELPID_ENUM = "oracle.eclipse.tools.webtier.ui.InsertEnumWizard";
    private String _helpId;

    public VariableTagDropWizard(IDocument doc, TagIdentifier tagToDrop, IDocumentContentProvider contentProvider, IDOMPosition position) {
        this._doc = doc;
        this._tagToDrop = tagToDrop;
        this._contentProvider = contentProvider;
        this._position = position;
        this.initWizard();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this._wizImageDescriptor = Activator.Images.DROP_WIZARD_BANNER.getImageDescriptor();
        this.setDefaultPageImageDescriptor(this._wizImageDescriptor);
        this.initGeneratorsPage();
        if (!this._isFieldsGenerator) {
            this.initIterVarPage();
        }
        this.initSelectFieldsPage();
        this.initFieldOrderPage();
    }

    private IProject getProject() {
        return this._doc.getProject().getEclipseProject();
    }

    private void initIterVarPage() {
        this._iterVarPage = new IteratorVariableWizardPage("iterVar", Messages.VariableTagDropWizard_IterationVariablePage, Activator.Images.DROP_WIZARD_BANNER.getImageDescriptor());
        this._iterVarPage.setDescription(NLS.bind((String)Messages.VariableTagDropWizard_IterationVariablePageDesc, (Object)this._valRef.getFieldName()));
        this.addPage((IWizardPage)this._iterVarPage);
    }

    private void initGeneratorsPage() {
        this._chooseGeneratorPage = new ChooseGeneratorWizardPage("fieldGenSelect", Messages.VariableTagDropWizard_ChooseGenerator, Activator.Images.DROP_WIZARD_BANNER.getImageDescriptor());
        this._chooseGeneratorPage.setDescription(Messages.VariableTagDropWizard_SelectGeneratorDesc);
        this.addPage((IWizardPage)this._chooseGeneratorPage);
    }

    private void initSelectFieldsPage() {
        this._selectFieldsPage = new SelectFieldsWizardPage("selectFlds", Messages.VariableTagDropWizard_ChooseFields, this._wizImageDescriptor);
        this._selectFieldsPage.setDescription(Messages.VariableTagDropWizard_ChooseFieldsDesc);
        this.addPage((IWizardPage)this._selectFieldsPage);
    }

    private void initFieldOrderPage() {
        this._orderFieldsPage = new OrderFieldsWizardPage("orderFlds", Messages.VariableTagDropWizard_OrderFields, this._wizImageDescriptor);
        this._orderFieldsPage.setDescription(Messages.VariableTagDropWizard_OrderFieldsDesc);
        this.addPage((IWizardPage)this._orderFieldsPage);
    }

    private void initWizard() {
        this._valRef = VariableIdentifierHelper.getValueReference(this._tagToDrop, this._doc.getFile());
        FilePositionContext modelContext = new FilePositionContext(this._position.getOffset(), this._doc.getFile());
        DataType dt = this._valRef.getType((IModelContext)modelContext);
        if (dt.isEnumerable()) {
            this._isFieldsGenerator = false;
            this._generators = this._contentProvider.getEnumVarGenerators(this._valRef);
            this.setWindowTitle(Messages.VariableTagDropWizard_InsertEnum);
            this._helpId = HELPID_ENUM;
        } else if (!dt.getFields((IModelContext)modelContext).isEmpty() && !dt.isDate()) {
            this._isFieldsGenerator = true;
            this._generators = this._contentProvider.getFieldGenerators(this._valRef);
            this.setWindowTitle(Messages.VariableTagDropWizard_InsertFields);
            this._helpId = HELPID_FIELDS;
        }
    }

    public boolean canFinish() {
        if (!this._isFieldsGenerator && this.getContainer().getCurrentPage() == this._iterVarPage && this.getIterationVar() != null) {
            return true;
        }
        return super.canFinish();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (!this._isFieldsGenerator && page == this._iterVarPage && this.getIterationVar() != null && this.getIterationVar().getType().getNumFields((IModelContext)new FilePositionContext(this._position.getOffset(), this._doc.getFile())) < 2) {
            return null;
        }
        return nextPage;
    }

    public boolean canDisplayWizard() {
        return this._generators != null && this._generators.size() > 0;
    }

    public EObject getRootObject() {
        return this._rootObject;
    }

    public String getHelpId() {
        return this._helpId;
    }

    public boolean performFinish() {
        AbstractDocumentContentGenerator gen = this._chooseGeneratorPage.getGeneratorToUse();
        if (this._isFieldsGenerator) {
            ((FieldsGenerator)gen).setFields(this._orderFieldsPage.getOrderedFields());
        } else {
            ((EnumVarGenerator)gen).setIterationVariable(this.getIterationVar());
            ((EnumVarGenerator)gen).setFields(this.getOrderedEnumerableFields());
            ((EnumVarGenerator)gen).setEnumeration(this._valRef);
        }
        this._rootObject = gen.getFragment();
        return true;
    }

    private List<ValueReference> getOrderedEnumerableFields() {
        return this._orderFieldsPage.getOrderedFields();
    }

    private Variable getIterationVar() {
        if (this._iterVarPage.getIterVarName().equals("") || this._iterVarPage.getIterVarType().equals("")) {
            return null;
        }
        IDatatypeProvider dtProvider = (IDatatypeProvider)this._doc.getProject().getAppService(IDatatypeProvider.class);
        if (dtProvider != null) {
            return new Variable(this._iterVarPage.getIterVarName(), dtProvider.getDataType(this._iterVarPage.getIterVarType(), null), Variable.SCOPE.NESTED_SCOPE, this._valRef.getVariable().getResolutionType(), null);
        }
        return null;
    }

    private class ChooseGeneratorWizardPage
    extends WizardPage {
        private CCombo _combo;

        public ChooseGeneratorWizardPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, true);
            comp.setLayout((Layout)layout);
            Label lbl = new Label(comp, 0);
            lbl.setText(Messages.VariableTagDropWizard_SelectGeneratorLabel);
            this._combo = new CCombo(comp, 2056);
            this._combo.setBackground(this.getWizard().getContainer().getShell().getDisplay().getSystemColor(25));
            GridData gd = new GridData(768);
            this._combo.setLayoutData((Object)gd);
            this.loadCombo();
            this.selectDefault();
            this.setControl((Control)comp);
        }

        private void selectDefault() {
            this._combo.select(0);
        }

        private void loadCombo() {
            for (AbstractDocumentContentGenerator generator : VariableTagDropWizard.this._generators) {
                this._combo.add(generator.getDisplayName());
            }
        }

        public boolean isPageComplete() {
            return this._combo.getSelectionIndex() != -1;
        }

        public AbstractDocumentContentGenerator getGeneratorToUse() {
            String selected = this._combo.getText();
            for (AbstractDocumentContentGenerator gen : VariableTagDropWizard.this._generators) {
                if (!selected.equals(gen.getDisplayName())) continue;
                return gen;
            }
            return null;
        }
    }

    private class IteratorVariableWizardPage
    extends WizardPage
    implements KeyListener {
        private Text _iterVarNameText;
        private Text _iterVarTypeText;

        protected IteratorVariableWizardPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            comp.setLayout((Layout)layout);
            Label lblName = new Label(comp, 0);
            lblName.setText(Messages.VariableTagDropWizard_VarName);
            lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this._iterVarNameText = new Text(comp, 2048);
            GridData gd1 = new GridData(4, 0x1000000, true, false);
            gd1.horizontalSpan = 2;
            this._iterVarNameText.setLayoutData((Object)gd1);
            this._iterVarNameText.addKeyListener((KeyListener)this);
            Label lblType = new Label(comp, 0);
            lblType.setText(Messages.VariableTagDropWizard_VarType);
            lblType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this._iterVarTypeText = new Text(comp, 2048);
            GridData gd2 = new GridData(4, 0x1000000, true, false);
            this._iterVarTypeText.setLayoutData((Object)gd2);
            this._iterVarTypeText.addKeyListener((KeyListener)this);
            Button browse = new Button(comp, 8);
            browse.setText(Messages.VariableTagDropWizard_Browse);
            browse.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            browse.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String initialName = IteratorVariableWizardPage.this._iterVarTypeText.getText();
                    String typeName = TypeUtils.chooseType(VariableTagDropWizard.this.getProject(), initialName, null, 6);
                    if (typeName == null || typeName.length() == 0) {
                        return;
                    }
                    IteratorVariableWizardPage.this._iterVarTypeText.setText(typeName);
                    IteratorVariableWizardPage.this.validatePage();
                }
            });
            this.setControl((Control)comp);
            this.setDefaultValues();
        }

        private void setDefaultValues() {
            DataType iterType = VariableTagDropWizard.this._valRef.getType((IModelContext)new FilePositionContext(VariableTagDropWizard.this._position.getOffset(), VariableTagDropWizard.this._doc.getFile())).getComponentType();
            if (iterType != null && !iterType.isUnspecified()) {
                this._iterVarTypeText.setText(iterType.getName());
                if (iterType.isPrimitiveType()) {
                    this._iterVarTypeText.setEnabled(false);
                }
            }
        }

        protected void validatePage() {
            this.setErrorMessage(null);
            IStatus val = JavaConventions.validateIdentifier((String)this.getIterVarName(), (String)"1.3", (String)"1.3");
            if (val != Status.OK_STATUS) {
                if (val.getSeverity() == 4) {
                    this.setErrorMessage(Messages.VariableTagDropWizard_varname_error);
                }
            } else if (this.getIterVarType().equals("")) {
                this.setErrorMessage(Messages.ArtificialVariableWizard_noEmptyType);
            } else {
                Project project = (Project)VariableTagDropWizard.this.getProject().getAdapter(Project.class);
                DataType dt = ((IDatatypeProvider)project.getAppService(IDatatypeProvider.class)).getDataType(this.getIterVarType(), null);
                if (dt.isUnknown()) {
                    this.setErrorMessage(NLS.bind((String)Messages.ArtificialVariableWizard_unknownType, (Object)this.getIterVarType()));
                }
            }
            if (this.getErrorMessage() == null) {
                this.setVariableIterator();
            }
            this.getWizard().getContainer().updateButtons();
        }

        private void setVariableIterator() {
            VariableTagDropWizard.this._selectFieldsPage.setVariableIterator(this.getVariableIterator());
            VariableTagDropWizard.this._orderFieldsPage.reset();
        }

        private ValueReference getVariableIterator() {
            if (VariableTagDropWizard.this.getIterationVar() == null) {
                return null;
            }
            return new ValueReference(VariableTagDropWizard.this.getIterationVar(), null);
        }

        public String getIterVarName() {
            return this._iterVarNameText.getText().trim();
        }

        public String getIterVarType() {
            return this._iterVarTypeText.getText().trim();
        }

        public boolean isPageComplete() {
            return !this.getIterVarName().equals("") && !this.getIterVarType().equals("");
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            this.validatePage();
        }
    }

    private class OrderFieldsWizardPage
    extends WizardPage
    implements ICheckStateListener,
    SelectionListener {
        private TableViewer _list;
        private Button _upBtn;
        private Button _downBtn;
        private OrderedFieldList _orderedFieldsList;

        public OrderFieldsWizardPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, true);
            comp.setLayout((Layout)layout);
            Label lbl = new Label(comp, 0);
            lbl.setText(Messages.VariableTagDropWizard_OrderFieldsLabel);
            Composite viewercomp = new Composite(comp, 0);
            GridLayout layout2 = new GridLayout(2, false);
            viewercomp.setLayout((Layout)layout2);
            viewercomp.setLayoutData((Object)new GridData(1808));
            this._list = new TableViewer(viewercomp, 2052);
            GridData gd = new GridData(1808);
            this._list.getTable().setLayoutData((Object)gd);
            this._list.setContentProvider((IContentProvider)new OrderedFieldsContentProvider());
            this._list.setLabelProvider((IBaseLabelProvider)new VariablesTreeLabelProvider((IModelContext)new FilePositionContext(VariableTagDropWizard.this._position.getOffset(), VariableTagDropWizard.this._doc.getFile())));
            this.addMoveButtons(viewercomp);
            this.setControl((Control)comp);
            this._list.setInput(this.getInternalOrderedFieldsList());
            VariableTagDropWizard.this._selectFieldsPage.addSelectedFieldsListener(this);
        }

        public void reset() {
            this._orderedFieldsList = null;
            this._list.setInput(this.getInternalOrderedFieldsList());
        }

        private void addMoveButtons(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, true);
            comp.setLayout((Layout)layout);
            comp.setLayoutData((Object)new GridData(4, 4, false, true));
            this._upBtn = new Button(comp, 132);
            GridData gd1 = new GridData(4, 4, false, false);
            this._upBtn.setLayoutData((Object)gd1);
            this._upBtn.addSelectionListener((SelectionListener)this);
            this._upBtn.setEnabled(false);
            this._downBtn = new Button(comp, 1028);
            GridData gd2 = new GridData(131072, 4, false, false);
            this._downBtn.setLayoutData((Object)gd2);
            this._downBtn.addSelectionListener((SelectionListener)this);
            this._downBtn.setEnabled(false);
            this._list.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection ssel = (IStructuredSelection)OrderFieldsWizardPage.this._list.getSelection();
                    if (ssel.size() == 0) {
                        OrderFieldsWizardPage.this._upBtn.setEnabled(false);
                        OrderFieldsWizardPage.this._downBtn.setEnabled(false);
                    } else {
                        ValueReference firstSel = (ValueReference)ssel.toArray()[0];
                        ValueReference lastSel = (ValueReference)ssel.toArray()[ssel.size() - 1];
                        OrderFieldsWizardPage.this._upBtn.setEnabled(firstSel != OrderFieldsWizardPage.this._orderedFieldsList.get(0));
                        OrderFieldsWizardPage.this._downBtn.setEnabled(lastSel != OrderFieldsWizardPage.this._orderedFieldsList.get(OrderFieldsWizardPage.this._orderedFieldsList.size() - 1));
                    }
                }
            });
        }

        private List<SortableValueReference> getInternalOrderedFieldsList() {
            if (this._orderedFieldsList == null) {
                this._orderedFieldsList = new OrderedFieldList(VariableTagDropWizard.this._selectFieldsPage.getFields());
            }
            return this._orderedFieldsList.getSortedList();
        }

        public List<ValueReference> getOrderedFields() {
            ArrayList<ValueReference> refs = new ArrayList<ValueReference>();
            for (SortableValueReference ref : this._orderedFieldsList.getSortedList()) {
                refs.add(ref.getValueReference());
            }
            return refs;
        }

        public boolean isPageComplete() {
            return true;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getElement() instanceof ValueReference) {
                ValueReference valRef = (ValueReference)event.getElement();
                this.handleOrderedList(valRef, event.getChecked());
                this._list.refresh();
            }
        }

        private void handleOrderedList(ValueReference valRef, boolean checked) {
            if (checked) {
                this._orderedFieldsList.add(valRef);
            } else {
                this._orderedFieldsList.remove(valRef);
            }
        }

        public void dispose() {
            VariableTagDropWizard.this._selectFieldsPage.removeSelectedFieldsListener(this);
            super.dispose();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean down = true;
            if (e.getSource() == this._upBtn) {
                down = false;
            }
            IStructuredSelection ssel = (IStructuredSelection)this._list.getSelection();
            Object firstSel = ssel.getFirstElement();
            for (ValueReference ref : ssel) {
                SortableValueReference sref = this._orderedFieldsList.get(ref);
                if (sref == null) continue;
                sref.moveOne(down);
            }
            this._list.setSelection((ISelection)ssel);
            this._orderedFieldsList.refresh();
            this._list.refresh();
            this._upBtn.setEnabled(firstSel != this._orderedFieldsList.get(0));
            Object lastSel = firstSel;
            this._downBtn.setEnabled(lastSel != this._orderedFieldsList.get(this._orderedFieldsList.size() - 1));
        }
    }

    private static class OrderedFieldList {
        private List<SortableValueReference> _theList = new ArrayList<SortableValueReference>();

        public OrderedFieldList(List<ValueReference> list) {
            int pos = -1;
            for (ValueReference ref : list) {
                this._theList.add(new SortableValueReference(ref, pos++));
            }
        }

        public void refresh() {
            int i = 0;
            for (SortableValueReference ref : this.getSortedList()) {
                ref.setResetPosition(i++);
            }
        }

        public ValueReference get(int index) {
            if (index < 0) {
                return null;
            }
            return this._theList.get(index).getValueReference();
        }

        public SortableValueReference get(ValueReference ref) {
            for (SortableValueReference sref : this._theList) {
                if (sref.getValueReference() != ref) continue;
                return sref;
            }
            return null;
        }

        public int size() {
            return this._theList.size();
        }

        public boolean add(ValueReference valRef) {
            return this._theList.add(new SortableValueReference(valRef, this._theList.size()));
        }

        public void remove(ValueReference valRef) {
            for (SortableValueReference ref : this._theList) {
                if (ref.getValueReference() != valRef) continue;
                this._theList.remove(ref);
                break;
            }
        }

        public List<SortableValueReference> getSortedList() {
            Collections.sort(this._theList, new Comparator<SortableValueReference>(){

                @Override
                public int compare(SortableValueReference o1, SortableValueReference o2) {
                    if (o1.getPosition() > o2.getPosition()) {
                        return 1;
                    }
                    if (o1.getPosition() < o2.getPosition()) {
                        return -1;
                    }
                    if (o1.getDirectionMoved() > o2.getDirectionMoved()) {
                        return 1;
                    }
                    return -1;
                }
            });
            return this._theList;
        }
    }

    private static class OrderedFieldsContentProvider
    implements IStructuredContentProvider {
        private OrderedFieldsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List fieldRefs = (List)inputElement;
                Object[] elements = new Object[fieldRefs.size()];
                int pos = 0;
                for (SortableValueReference ref : fieldRefs) {
                    elements[pos++] = ref.getValueReference();
                }
                return elements;
            }
            return null;
        }
    }

    private class SelectFieldsWizardPage
    extends WizardPage {
        private CheckboxTreeViewer _tree;
        private ValueReference _itemVarRef;

        public SelectFieldsWizardPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, true);
            comp.setLayout((Layout)layout);
            Label lbl = new Label(comp, 0);
            lbl.setText(Messages.VariableTagDropWizard_SelectFieldsLabel);
            this._tree = new CheckboxTreeViewer(comp, 2048);
            GridData gd = new GridData(1808);
            this._tree.getTree().setLayoutData((Object)gd);
            this._tree.setContentProvider((IContentProvider)new ValueReferenceTreeContentProvider((IFilePositionContext)new FilePositionContext(VariableTagDropWizard.this._position.getOffset(), VariableTagDropWizard.this._doc.getFile())));
            this._tree.setLabelProvider((IBaseLabelProvider)new VariablesTreeLabelProvider((IModelContext)new FilePositionContext(VariableTagDropWizard.this._position.getOffset(), VariableTagDropWizard.this._doc.getFile())));
            this._tree.addFilter((ViewerFilter)new HideStringFieldsFilter((IModelContext)new FilePositionContext(VariableTagDropWizard.this._doc.getFile())));
            this.setControl((Control)comp);
            this._tree.setInput((Object)this.getValueRef());
            this._tree.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getElement() instanceof ValueReferenceHolder && ((ValueReferenceHolder)event.getElement()).getValueReference() == VariableTagDropWizard.this._valRef) {
                        event.getCheckable().setChecked(event.getElement(), true);
                    }
                    this.validatePage();
                }

                private void validatePage() {
                    SelectFieldsWizardPage.this.setErrorMessage(null);
                    if (SelectFieldsWizardPage.this._tree.getCheckedElements().length < 2) {
                        SelectFieldsWizardPage.this.setErrorMessage(Messages.VariableTagDropWizard_select_fields_msg);
                    }
                    SelectFieldsWizardPage.this.getWizard().getContainer().updateButtons();
                }
            });
            this.selectDefaults();
        }

        private ValueReference getValueRef() {
            return this._itemVarRef != null ? this._itemVarRef : VariableTagDropWizard.this._valRef;
        }

        public void setVariableIterator(ValueReference valRef) {
            this._itemVarRef = valRef;
            this._tree.setSelection(null);
            this._tree.setInput((Object)this._itemVarRef);
            this.selectDefaults();
        }

        private void selectDefaults() {
            this._tree.expandToLevel(2);
            TreePath[] paths = this._tree.getExpandedTreePaths();
            if (paths.length > 0) {
                Object[] children = ((ITreeContentProvider)this._tree.getContentProvider()).getChildren(paths[0].getFirstSegment());
                if (children != null) {
                    this._tree.setCheckedElements(children);
                }
                this._tree.setGrayChecked((Object)paths[0], true);
            }
        }

        public boolean isPageComplete() {
            return this._tree.getCheckedElements().length > 1;
        }

        public List<ValueReference> getFields() {
            Object[] checkedObjs;
            ArrayList<ValueReference> fields = new ArrayList<ValueReference>();
            Object[] objectArray = checkedObjs = this._tree.getCheckedElements();
            int n = checkedObjs.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedObj = objectArray[n2];
                if (checkedObj instanceof ValueReference) {
                    fields.add((ValueReference)checkedObj);
                }
                ++n2;
            }
            return fields;
        }

        public void addSelectedFieldsListener(ICheckStateListener listener) {
            this._tree.addCheckStateListener(listener);
        }

        public void removeSelectedFieldsListener(ICheckStateListener listener) {
            this._tree.removeCheckStateListener(listener);
        }
    }

    private static class SortableValueReference {
        private ValueReference _ref;
        private int _pos = -1;
        private int _dir = 0;

        public SortableValueReference(ValueReference valRef, int pos) {
            this._ref = valRef;
            this._pos = pos;
        }

        public void setResetPosition(int pos) {
            this._pos = pos;
            this._dir = 0;
        }

        public ValueReference getValueReference() {
            return this._ref;
        }

        public void moveOne(boolean down) {
            this._pos = down ? this._pos + 1 : this._pos - 1;
            this._dir = down ? 1 : -1;
        }

        public int getPosition() {
            return this._pos;
        }

        public int getDirectionMoved() {
            return this._dir;
        }

        public String toString() {
            return String.valueOf(this._ref.toString()) + ":" + String.valueOf(this._pos);
        }
    }
}

