/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters;

import oracle.eclipse.tools.application.common.services.variables.ImplicitVariable;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.ScriptingVariable;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.util.AbstractMatcher;

public class PossibleVariablesMatcher
extends AbstractMatcher<Variable> {
    private final boolean _acceptsEarlyBoundVariable;
    private final boolean _acceptsLateBoundVariable;
    private final boolean _acceptsJspExpression;

    public PossibleVariablesMatcher(boolean acceptsEarlyBoundVariable, boolean acceptsLateBoundVariable, boolean acceptsJspExpression) {
        this._acceptsEarlyBoundVariable = acceptsEarlyBoundVariable;
        this._acceptsLateBoundVariable = acceptsLateBoundVariable;
        this._acceptsJspExpression = acceptsJspExpression;
    }

    public boolean matches(Variable var) {
        if (var instanceof ImplicitVariable) {
            return false;
        }
        if (var instanceof ScriptingVariable) {
            return this._acceptsJspExpression;
        }
        ResolutionTime rt = var.getResolutionType();
        switch (rt) {
            case PAGE_COMPILE: {
                return this._acceptsEarlyBoundVariable;
            }
            case PAGE_RUN: {
                return this._acceptsLateBoundVariable;
            }
            case PAGE_RUN_OR_COMPILE: {
                return this._acceptsEarlyBoundVariable || this._acceptsLateBoundVariable;
            }
        }
        return false;
    }
}

