/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters;

import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.ValueReferenceHolder;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.context.IModelContext;

public final class HideStringFieldsFilter
extends ViewerFilter
implements IFilter {
    final IModelContext _modelContext;

    public HideStringFieldsFilter(IModelContext modelContext) {
        this._modelContext = modelContext;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.isStringType(parentElement)) {
            return this.isTypeToSelect(element);
        }
        return true;
    }

    private boolean isStringType(Object parentElement) {
        DataType type;
        ValueReference parentValueRef;
        DataType.Field field;
        if (parentElement instanceof ValueReference && (field = (parentValueRef = (ValueReference)parentElement).getField(this._modelContext)) != null && (type = field.getType()) != null) {
            return "java.lang.String".equals(type.getName());
        }
        return false;
    }

    private boolean isTypeToSelect(Object element) {
        ValueReference valueRef;
        DataType.Field field;
        Object toTest = element;
        if (toTest instanceof ValueReferenceHolder) {
            toTest = ((ValueReferenceHolder)toTest).getValueReference();
        }
        if (toTest instanceof ValueReference && (field = (valueRef = (ValueReference)toTest).getField(this._modelContext)) != null) {
            return !"bytes".equals(field.getName()) && !"empty".equals(field.getName());
        }
        return true;
    }

    public boolean select(Object toTest) {
        return this.isTypeToSelect(toTest);
    }
}

