/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroup;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.context.IModelContext;

public class VariablesViewFilter
extends ViewerFilter {
    protected final List<Class<?>> _allowedTypes = new ArrayList();
    protected final ValueReferenceFilterType _valRefAllowedType;
    private final IFilePositionContext _context;

    public VariablesViewFilter(ValueReferenceFilterType valRefAllowedType, IFilePositionContext context) {
        this._valRefAllowedType = valRefAllowedType;
        this._context = context;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this._valRefAllowedType == ValueReferenceFilterType.ALL && this._allowedTypes.size() == 0) {
            return true;
        }
        if (element instanceof VariableGroup) {
            return this.handlesType((VariableGroup)element);
        }
        if (element instanceof ValueReference) {
            return this.handlesType((ValueReference)element);
        }
        return true;
    }

    protected boolean handlesType(VariableGroup varGroup) {
        for (ValueReference valRef : varGroup.getValueReferences()) {
            if (!this.handlesType(valRef)) continue;
            return true;
        }
        return false;
    }

    protected boolean handlesType(ValueReference valRef) {
        DataType.Field field = valRef.getField((IModelContext)this._context);
        if (field != null) {
            return this.handlesType(field);
        }
        return this.handlesType(valRef.getVariable());
    }

    protected boolean handlesType(Variable var) {
        return this.handlesType(var.getType());
    }

    protected boolean handlesType(DataType type) {
        if (this.typeMatchesCriteria(type)) {
            return true;
        }
        for (DataType.Field field : type.getFields((IModelContext)this._context)) {
            if (!this.handlesType(field)) continue;
            return true;
        }
        return false;
    }

    protected boolean handlesType(DataType.Field field) {
        return this.handlesType(field.getType());
    }

    protected boolean typeMatchesCriteria(DataType type) {
        boolean isMatch = this._valRefAllowedType.isMatch(type, (IModelContext)this._context);
        return isMatch;
    }

    public static enum ValueReferenceFilterType {
        NONE{

            @Override
            boolean isMatch(DataType type, IModelContext context) {
                return false;
            }
        }
        ,
        ALL{

            @Override
            boolean isMatch(DataType type, IModelContext context) {
                return true;
            }
        }
        ,
        STRING{

            @Override
            boolean isMatch(DataType type, IModelContext context) {
                return type.isString();
            }
        }
        ,
        NUMERIC{

            @Override
            boolean isMatch(DataType type, IModelContext context) {
                return type.isNumeric();
            }
        }
        ,
        DATE{

            @Override
            boolean isMatch(DataType type, IModelContext context) {
                return type.isDate();
            }
        }
        ,
        STRING_NUMERIC{

            @Override
            boolean isMatch(DataType type, IModelContext context) {
                return type.isString() || type.isNumeric();
            }
        }
        ,
        STRING_DATE{

            @Override
            boolean isMatch(DataType type, IModelContext context) {
                return type.isString() || type.isDate();
            }
        }
        ,
        BOOLEAN{

            @Override
            boolean isMatch(DataType type, IModelContext context) {
                return type.isBoolean();
            }
        }
        ,
        ENUMERABLE{

            @Override
            boolean isMatch(DataType type, IModelContext context) {
                return type.isEnumerable() || type.mightHaveFields(context) && type.getNumFields(context) > 0;
            }
        }
        ,
        HAS_FIELDS{

            @Override
            boolean isMatch(DataType type, IModelContext context) {
                return type.mightHaveFields(context) && type.getNumFields(context) > 0;
            }
        };


        abstract boolean isMatch(DataType var1, IModelContext var2);

        public static ValueReferenceFilterType getFilterType(String id) {
            if ("all".equals(id)) {
                return ALL;
            }
            if ("string".equals(id)) {
                return STRING;
            }
            if ("numeric".equals(id)) {
                return NUMERIC;
            }
            if ("date".equals(id)) {
                return DATE;
            }
            if ("string-numeric".equals(id)) {
                return STRING_NUMERIC;
            }
            if ("string-date".equals(id)) {
                return STRING_DATE;
            }
            if ("boolean".equals(id)) {
                return BOOLEAN;
            }
            if ("enumerable".equals(id)) {
                return ENUMERABLE;
            }
            return NONE;
        }
    }
}

