/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ILabeledMember;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.MethodInfo;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.ScriptingVariable;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.ValueReferenceHolder;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroup;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableLabelProviderFactoryReader;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.swt.graphics.Image;

public class VariablesTreeLabelProvider
extends ColumnLabelProvider {
    private final IModelContext _context;
    private static ImageDescriptor PAGE_VAR_IMG_DESC = null;
    private static ImageDescriptor FIELD_IMG_DESC = null;
    private static ImageDescriptor METHOD_IMG_DESC = null;
    private static ImageDescriptor SCRIPT_VAR_IMG_DESC = null;
    private static ImageDescriptor X_REQUEST_VAR_IMG_DESC = null;
    private static ImageDescriptor X_SESSION_VAR_IMG_DESC = null;
    private static ImageDescriptor X_APP_VAR_IMG_DESC = null;
    private static ImageDescriptor X_VIEW_VAR_IMG_DESC = null;
    private static ImageDescriptor X_BBEAN_VAR_IMG_DESC = null;
    private static ImageDescriptor X_PAGEFLOW_VAR_IMG_DESC = null;
    private static ImageDescriptor PAGE_VARIABLES_IMG_DESC = null;

    static {
        PAGE_VAR_IMG_DESC = Activator.Images.PAGE_VAR_ICON.getImageDescriptor();
        FIELD_IMG_DESC = Activator.Images.FIELD_ICON.getImageDescriptor();
        METHOD_IMG_DESC = Activator.Images.METHOD_ICON.getImageDescriptor();
        SCRIPT_VAR_IMG_DESC = Activator.Images.SCRIPT_VAR_ICON.getImageDescriptor();
        X_REQUEST_VAR_IMG_DESC = Activator.Images.X_REQUEST_VAR_ICON.getImageDescriptor();
        X_SESSION_VAR_IMG_DESC = Activator.Images.X_SESSION_VAR_ICON.getImageDescriptor();
        X_APP_VAR_IMG_DESC = Activator.Images.X_APP_VAR_ICON.getImageDescriptor();
        X_VIEW_VAR_IMG_DESC = Activator.Images.X_VIEW_VAR_ICON.getImageDescriptor();
        X_BBEAN_VAR_IMG_DESC = Activator.Images.X_BBEAN_VAR_ICON.getImageDescriptor();
        X_PAGEFLOW_VAR_IMG_DESC = Activator.Images.X_PAGEFLOW_VAR_ICON.getImageDescriptor();
        PAGE_VARIABLES_IMG_DESC = Activator.Images.PAGE_VARIABLES_ICON.getImageDescriptor();
    }

    public VariablesTreeLabelProvider(IModelContext context) {
        this._context = context;
    }

    public Image getImage(Object element) {
        ValueReference valRef;
        ImageDescriptor varImageDescriptor = null;
        if (element instanceof ValueReferenceHolder) {
            return this.getImage(((ValueReferenceHolder)element).getValueReference());
        }
        if (element instanceof VariableGroup) {
            varImageDescriptor = VariableLabelProviderFactoryReader.getImageDescriptor((VariableGroup)element, this._context);
            if (varImageDescriptor == null) {
                varImageDescriptor = PAGE_VARIABLES_IMG_DESC;
            }
        } else if (element instanceof MethodReference) {
            MethodInfo methodInfo = ((MethodReference)element).getMethodInfo();
            if (methodInfo instanceof ILabeledMember) {
                return (Image)((ILabeledMember)methodInfo).getImage();
            }
            varImageDescriptor = METHOD_IMG_DESC;
        } else if (element instanceof ValueReference && (varImageDescriptor = VariableLabelProviderFactoryReader.getImageDescriptor(valRef = (ValueReference)element, this._context)) == null) {
            if (valRef.getField(this._context) == null) {
                Variable var = valRef.getVariable();
                if (var instanceof ScriptingVariable) {
                    varImageDescriptor = SCRIPT_VAR_IMG_DESC;
                } else {
                    Variable.SCOPE scope = var.getScope();
                    switch (scope) {
                        case REQUEST_SCOPE: {
                            varImageDescriptor = X_REQUEST_VAR_IMG_DESC;
                            break;
                        }
                        case SESSION_SCOPE: {
                            varImageDescriptor = X_SESSION_VAR_IMG_DESC;
                            break;
                        }
                        case APPLICATION_SCOPE: {
                            varImageDescriptor = X_APP_VAR_IMG_DESC;
                            break;
                        }
                        case ADF_BACKING_BEAN_SCOPE: {
                            varImageDescriptor = X_BBEAN_VAR_IMG_DESC;
                            break;
                        }
                        case ADF_PAGE_SCOPE: {
                            varImageDescriptor = X_PAGEFLOW_VAR_IMG_DESC;
                            break;
                        }
                        case ADF_VIEW_SCOPE: {
                            varImageDescriptor = X_VIEW_VAR_IMG_DESC;
                            break;
                        }
                        default: {
                            varImageDescriptor = PAGE_VAR_IMG_DESC;
                            break;
                        }
                    }
                }
            } else {
                DataType.Field field = valRef.getField(this._context);
                if (field instanceof ILabeledMember) {
                    return (Image)((ILabeledMember)field).getImage();
                }
                varImageDescriptor = field instanceof JavaResourceBundleDataType.ResourceBundleField ? FIELD_IMG_DESC : CommonImages.DESC_ATTRIBUTE_ICON;
            }
        }
        if (varImageDescriptor != null) {
            return CommonImages.createImage((ImageDescriptor)varImageDescriptor);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof ValueReference) {
            ValueReference ref = (ValueReference)element;
            DataType.Field field = ref.getField(this._context);
            if (field == null) {
                return ref.getVariable().getName();
            }
            return field.getName();
        }
        if (element instanceof VariableGroup) {
            return ((VariableGroup)element).getLabel();
        }
        if (element instanceof ValueReferenceHolder) {
            return this.getText(((ValueReferenceHolder)element).getValueReference());
        }
        if (element instanceof MethodReference) {
            return ((MethodReference)element).getLabel();
        }
        return super.getText(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof ValueReference) {
            ValueReference ref = (ValueReference)element;
            DataType.Field field = ref.getField(this._context);
            if (field instanceof ILabeledMember) {
                return ((ILabeledMember)field).getToolTipText();
            }
            return ref.getDescription();
        }
        if (element instanceof VariableGroup) {
            return null;
        }
        if (element instanceof ValueReferenceHolder) {
            return null;
        }
        if (element instanceof MethodReference) {
            MethodReference ref = (MethodReference)element;
            MethodInfo methodInfo = ref.getMethodInfo();
            if (methodInfo instanceof ILabeledMember) {
                return ((ILabeledMember)methodInfo).getToolTipText();
            }
            return ref.getLabel();
        }
        return super.getToolTipText(element);
    }
}

