/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.util.AbstractMatcher;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.ValueReferenceHolder;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroup;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroupFactoryReader;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesModel;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class VariablesTreeContentProvider
implements ITreeContentProvider {
    private VariablesModel _curInput;
    private AbstractMatcher _matcher;

    public VariablesTreeContentProvider() {
        this._matcher = new AbstractMatcher<Variable>(){

            public boolean matches(Variable testMe) {
                return true;
            }
        };
    }

    public VariablesTreeContentProvider(AbstractMatcher possibleVariablesMatcher) {
        this._matcher = possibleVariablesMatcher;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ValueReferenceHolder) {
            return this.getChildren(((ValueReferenceHolder)parentElement).getValueReference());
        }
        if (parentElement instanceof VariablesModel) {
            ArrayList<VariableGroup> groups = new ArrayList<VariableGroup>();
            List<Variable> vars = this.getApplicableVariables((VariablesModel)parentElement, this._matcher);
            for (Variable var : vars) {
                String groupLabel = VariableGroupFactoryReader.getFactoryName(var);
                if (groupLabel == null) {
                    LoggingService.logWarning((String)"oracle.eclipse.tools.webtier.ui", (String)Messages.bind((String)Messages.VariablesTreeContentProvider_NoGroupForVariable, (Object)var.toString()));
                    continue;
                }
                VariableGroup group = this.getOrCreateVariableGroup(groups, groupLabel);
                group.addValueReference(var);
            }
            return groups.toArray(new VariableGroup[groups.size()]);
        }
        if (parentElement instanceof VariableGroup) {
            VariableGroup group = (VariableGroup)parentElement;
            return group.getValueReferences().toArray(new ValueReference[group.getValueReferences().size()]);
        }
        return null;
    }

    private List<Variable> getApplicableVariables(VariablesModel model, AbstractMatcher matcher) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Variable var : model.getVariables()) {
            if (!matcher.matches((Object)var)) continue;
            vars.add(var);
        }
        return vars;
    }

    private VariableGroup getOrCreateVariableGroup(List<VariableGroup> groups, String groupLabel) {
        for (VariableGroup grp : groups) {
            if (!grp.getLabel().equals(groupLabel)) continue;
            return grp;
        }
        VariableGroup group = new VariableGroup(groupLabel);
        groups.add(group);
        return group;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof VariablesModel) {
            return ((VariablesModel)element).getVariables().size() > 0;
        }
        if (element instanceof VariableGroup) {
            return ((VariableGroup)element).getValueReferences().size() > 0;
        }
        if (element instanceof ValueReferenceHolder) {
            return this.hasChildren(((ValueReferenceHolder)element).getValueReference());
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof VariablesModel) {
            return this.getChildren(inputElement);
        }
        return null;
    }

    public void dispose() {
        if (this._curInput != null) {
            this._curInput.dispose();
        }
        this._matcher = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput instanceof VariablesModel) {
            ((VariablesModel)oldInput).dispose();
        }
        if (newInput instanceof VariablesModel) {
            this._curInput = (VariablesModel)newInput;
        }
    }
}

