/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.IDataTypeChangeListener;
import oracle.eclipse.tools.application.common.services.variables.IVariablesListener;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.application.common.services.variables.VariablesIterator;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;

public class VariablesModel
implements IVariablesListener {
    private final IFile _file;
    private VariableQuery.QueryMatcher _matcher;
    private List<IVariablesListener> _listeners = new CopyOnWriteArrayList<IVariablesListener>();
    private IDataTypeChangeListener _myDataTypeListener;

    public VariablesModel(IFile file) {
        this._file = file;
        this._myDataTypeListener = new DataTypeListener();
        VariablesController controller = VariablesController.getInstance();
        controller.addListener((IVariablesListener)this, this._file);
    }

    public VariablesModel(IFile file, VariableQuery.QueryMatcher matcher) {
        this(file);
        this._matcher = matcher;
    }

    public VariablesModel(IFile file, IVariablesListener listener) {
        this(file);
        this.addListener(listener);
    }

    public VariablesModel(IFile file, IVariablesListener listener, VariableQuery.QueryMatcher matcher) {
        this(file, listener);
        this._matcher = matcher;
    }

    protected final IFile getFile() {
        return this._file;
    }

    public void addListener(IVariablesListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeListener(IVariablesListener listener) {
        this._listeners.remove(listener);
    }

    public void dispose() {
        IDataTypeIntrospector introspector = this.getIntrospector();
        if (introspector != null) {
            introspector.removeAllChangeListeners(this._myDataTypeListener);
        }
        VariablesController controller = VariablesController.getInstance();
        controller.removeListener((IVariablesListener)this, this._file);
        this._listeners.clear();
    }

    protected boolean listenForVariableCacheUpdates() {
        return true;
    }

    public final List<Variable> getVariables() {
        VariablesIterator varIter;
        ArrayList<Variable> vars = new ArrayList<Variable>();
        VariablesController controller = VariablesController.getInstance();
        VariablesIterator variablesIterator = varIter = this._matcher == null ? controller.iterator(this._file, true, this.listenForVariableCacheUpdates(), null) : controller.iterator(this._file, true, this.listenForVariableCacheUpdates(), this._matcher);
        if (varIter != null) {
            while (varIter.hasNext()) {
                Variable var = varIter.next();
                vars.add(var);
                this.addDataTypeListener(var);
            }
        }
        return vars;
    }

    private void addDataTypeListener(Variable var) {
        DataType type = var.getType();
        if (type != null) {
            String typeName = type.getName();
            IDataTypeIntrospector introspector = this.getIntrospector();
            if (introspector != null) {
                introspector.addChangeListener(this._myDataTypeListener, typeName);
            }
        }
    }

    private IDataTypeIntrospector getIntrospector() {
        IDatatypeProvider appService;
        Project project = (Project)this._file.getProject().getAdapter(Project.class);
        if (project != null && (appService = (IDatatypeProvider)project.getAppService(IDatatypeProvider.class)) != null) {
            return appService.getIntrospector();
        }
        return null;
    }

    private void fireChangeEvent(IVariablesListener.VariableChangeEvent event) {
        for (IVariablesListener listener : this._listeners) {
            listener.refresh(event);
        }
    }

    public void refresh(IVariablesListener.VariableChangeEvent event) {
        this.fireChangeEvent(event);
    }

    private class DataTypeListener
    implements IDataTypeChangeListener {
        private DataTypeListener() {
        }

        public void typeChanged(IDataTypeChangeListener.DataTypeChangeEvent event) {
            VariablesModel.this.fireChangeEvent(new IVariablesListener.VariableChangeEvent((Object)VariablesModel.this, (IResource)VariablesModel.this._file.getProject(), IVariablesListener.VariableChangeEvent.PersistentCache, IVariablesListener.VariableChangeEvent.VariableChange, null));
        }
    }
}

