/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentContentProvider;
import oracle.eclipse.tools.application.common.services.techextservices.FieldsGenerator;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableIdentifierHelper;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.internal.wizard.VariableTagDropWizard;
import oracle.eclipse.tools.webtier.ui.tagdrop.ItemOverridingDropCustomizer;
import oracle.eclipse.tools.webtier.ui.tagdrop.OEPECustomizationDataImpl;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.elementedit.AbstractElementEdit;
import org.eclipse.jst.pagedesigner.elementedit.AbstractElementEditFactory;
import org.eclipse.jst.pagedesigner.elementedit.IElementEdit;
import org.eclipse.jst.pagedesigner.itemcreation.ITagDropOverrider;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.ICustomizationData;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.IDropCustomizer;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.viewer.DefaultDropLocationStrategy;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.IDropLocationStrategy;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class VariablesElementEditFactory
extends AbstractElementEditFactory {
    public VariablesElementEditFactory(String supportedUri) {
        super(supportedUri);
    }

    public IElementEdit createElementEdit(TagIdentifier tag) {
        return new AbstractElementEdit(){

            public IDropLocationStrategy getDropRequestorLocationStrategy(final TagIdentifier tag_, EditPartViewer viewer) {
                return new DefaultDropLocationStrategy(viewer){

                    public DesignPosition calculateDesignPosition(EditPart host, Point p, IPositionMediator validator) {
                        if (tag_.getTagName().equals("_VariableGroup_")) {
                            return null;
                        }
                        return super.calculateDesignPosition(host, p, validator);
                    }

                    public List showTargetFeedback(EditPart host, DesignPosition position, DropRequest request) {
                        if (tag_.getTagName().equals("_VariableGroup_")) {
                            return null;
                        }
                        return super.showTargetFeedback(host, position, request);
                    }
                };
            }

            public IDropCustomizer getDropCustomizer(TagIdentifier tagId) {
                return new MyDropCustomizer(tagId);
            }
        };
    }

    private static class MyDropCustomizer
    extends ItemOverridingDropCustomizer {
        private static final String BINDINGS = "bindings##PAGE_SCOPE";
        private static final String PAGE_VARIABLES = "PageVariables";
        private IFile _file;
        private EObject _rootEObject;
        private TagIdentifier _tagId;
        private IDOMPosition _position;

        MyDropCustomizer(TagIdentifier tagId) {
            this._tagId = tagId;
        }

        @Override
        protected IStatus doCustomization(IFile file, IDOMPosition position) {
            this._file = file;
            this._position = position;
            if (this._tagId.getTagName().equals("_VariableGroup_") || this._tagId.getTagName().equals(VariableIdentifierHelper.UNKNOWN) || this.isAdfBinding()) {
                return Status.CANCEL_STATUS;
            }
            this._rootEObject = this.getVariableEObject(this._tagId, this._file);
            return this._rootEObject != null ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }

        private boolean isAdfBinding() {
            return this._tagId.getTagName().startsWith(BINDINGS) && PAGE_VARIABLES.equals(this._tagId.getUri());
        }

        private EObject getVariableEObject(TagIdentifier tagId, IFile file) {
            IDocumentContentProvider prov;
            IDocument doc = (IDocument)file.getAdapter(IDocument.class);
            if (doc != null && (prov = (IDocumentContentProvider)doc.getAdapter(IDocumentContentProvider.class)) != null) {
                VariableTagDropWizard wizard = this.createWizard(doc, tagId, prov, this._position);
                if (wizard.canDisplayWizard()) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    wizard.init(workbench, (IStructuredSelection)new StructuredSelection((Object)file));
                    final String _helpId = wizard.getHelpId();
                    WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard){

                        protected void configureShell(Shell newShell) {
                            super.configureShell(newShell);
                            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, _helpId);
                        }
                    };
                    int result = dialog.open();
                    EObject rootObject = wizard.getRootObject();
                    if (1 == result || rootObject == null) {
                        return null;
                    }
                    return rootObject;
                }
                return this.createDefaultTagForVariable(doc, tagId, prov);
            }
            return null;
        }

        private EObject createDefaultTagForVariable(IDocument doc, TagIdentifier tagId, IDocumentContentProvider prov) {
            ValueReference valRef = VariableIdentifierHelper.getValueReference(tagId, doc.getFile());
            List generators = prov.getFieldGenerators(valRef);
            if (generators.size() > 0) {
                int i = 0;
                while (i < generators.size()) {
                    FieldsGenerator gen = (FieldsGenerator)generators.get(i);
                    ArrayList<ValueReference> fields = new ArrayList<ValueReference>();
                    fields.add(valRef);
                    gen.setFields(fields);
                    EObject fragment = gen.getFragment();
                    if (fragment != null) {
                        return fragment;
                    }
                    ++i;
                }
            }
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.VariablesElementEditFactory_noAvailableGeneratorsDialogTitle, (String)Messages.VariablesElementEditFactory_noAvailableGeneratorsMessage);
            return null;
        }

        private VariableTagDropWizard createWizard(IDocument doc, TagIdentifier tagId, IDocumentContentProvider prov, IDOMPosition position) {
            return new VariableTagDropWizard(doc, tagId, prov, position);
        }

        @Override
        protected ItemOverridingDropCustomizer.CustomizationAdapter getCustomizationAdapter() {
            OEPECustomizationDataImpl custData = new OEPECustomizationDataImpl(this._tagId, this._file, this._rootEObject, this._position);
            return new ItemOverridingDropCustomizer.CustomizationAdapter((ICustomizationData)custData, new ITagDropOverrider(){
                private static final String JSP11 = "jsp11";

                public String getTagNameOverride() {
                    if (MyDropCustomizer.this._rootEObject != null) {
                        if (this.getUriOverride().equalsIgnoreCase(JSP11)) {
                            return "jsp:" + ExtendedEcoreUtil.INSTANCE.getNodeName(MyDropCustomizer.this._rootEObject.eClass());
                        }
                        return ExtendedEcoreUtil.INSTANCE.getNodeName(MyDropCustomizer.this._rootEObject.eClass());
                    }
                    return null;
                }

                public String getUriOverride() {
                    if (MyDropCustomizer.this._rootEObject != null) {
                        String nsURI = ExtendedEcoreUtil.INSTANCE.getNamespaceUri(MyDropCustomizer.this._rootEObject.eClass());
                        if (nsURI.equals("http://java.sun.com/JSP/Page")) {
                            return JSP11;
                        }
                        return nsURI;
                    }
                    return null;
                }

                public String getDefaultPrefixOverride() {
                    String prefix;
                    Trait t;
                    IMetaDataDomainContext mdContext = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(MyDropCustomizer.this._file);
                    IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(mdContext);
                    Model model = query.getQueryHelper().getModel(this.getUriOverride());
                    if (model != null && (t = query.getQueryHelper().getTrait((Entity)model, "default-prefix")) != null && (prefix = TraitValueHelper.getValueAsString((Trait)t)) != null && !prefix.equals("")) {
                        return prefix;
                    }
                    return null;
                }
            });
        }
    }
}

