/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.StringTokenizer;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesModel;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesPaletteTreeEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;

public class VariableIdentifierHelper {
    private static final String DELIM = "##";
    public static final String VARIABLE_GROUP = "_VariableGroup_";
    public static String UNKNOWN = "_Unknown_";

    public static String getTagName(ValueReference valueReference) {
        return new EncodedValueReference(valueReference).getTagName();
    }

    public static ValueReference getValueReference(TagIdentifier tagId, IFile file) {
        return new DecodedValueReference(tagId.getTagName(), file).getValueReference();
    }

    public static ValueReference getValueReference(VariablesPaletteTreeEntry varTool, IFile file) {
        return new DecodedValueReference(varTool.getTagName(), file).getValueReference();
    }

    private static class DecodedValueReference {
        private String _encodedTag;
        private IFile _file;

        public DecodedValueReference(String encodedTagName, IFile file) {
            this._encodedTag = encodedTagName;
            this._file = file;
        }

        public ValueReference getValueReference() {
            StringTokenizer tokenizer = new StringTokenizer(this._encodedTag, VariableIdentifierHelper.DELIM);
            String varName = tokenizer.nextToken();
            Variable.SCOPE scope = null;
            String fldName = null;
            if (tokenizer.hasMoreTokens()) {
                scope = Variable.SCOPE.valueOf((String)tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    fldName = tokenizer.nextToken();
                }
            } else {
                scope = Variable.SCOPE.valueOf((String)varName);
                varName = "";
            }
            return this.locateValueReference(varName, scope, fldName);
        }

        private ValueReference locateValueReference(String varName, Variable.SCOPE scope, String fldName) {
            VariablesModel model = new VariablesModel(this._file);
            try {
                for (Variable var : model.getVariables()) {
                    if (!varName.equals(var.getName()) || scope != var.getScope()) continue;
                    ValueReference valueReference = new ValueReference(var, fldName);
                    return valueReference;
                }
                return null;
            }
            finally {
                model.dispose();
            }
        }
    }

    private static class EncodedValueReference {
        private ValueReference _ref;

        public EncodedValueReference(ValueReference ref) {
            this._ref = ref;
        }

        public String getTagName() {
            String varName = this._ref.getVariable().getName();
            Variable.SCOPE scope = this._ref.getVariable().getScope();
            StringBuffer idBuf = new StringBuffer(varName).append(VariableIdentifierHelper.DELIM).append(scope.toString());
            String fldName = this._ref.getFieldName();
            if (fldName != null) {
                idBuf.append(VariableIdentifierHelper.DELIM).append(fldName);
            }
            return idBuf.toString();
        }
    }
}

