/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.IVariableGroupFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;

class VariableGroupFactoryReader {
    private static final String EXT_PT = "variableGroupFactory";
    private static final String PRIORITY_ATTR = "priority";
    private static final String CLASS_ATTR = "class";
    private static List<IVariableGroupFactory> _factories;

    private VariableGroupFactoryReader() {
        throw new IllegalStateException("Should not be instantiated!");
    }

    public static String getFactoryName(Variable var) {
        for (IVariableGroupFactory factory : VariableGroupFactoryReader.getAllFactories()) {
            if (!factory.isFactoryFor(var)) continue;
            return factory.getVariableGroupName(var);
        }
        return null;
    }

    private static synchronized List<IVariableGroupFactory> getAllFactories() {
        if (_factories == null) {
            _factories = VariableGroupFactoryReader.readAllFactories();
        }
        return Collections.unmodifiableList(_factories);
    }

    private static List<IVariableGroupFactory> readAllFactories() {
        TreeSet<FactoryDescriptor> descriptors = new TreeSet<FactoryDescriptor>(new FactoryDescriptorComparator());
        Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.webtier.ui", (String)EXT_PT);
        for (IExtension ext : extensions) {
            IConfigurationElement[] tagElementConfig;
            IConfigurationElement[] iConfigurationElementArray = tagElementConfig = ext.getConfigurationElements();
            int n = tagElementConfig.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    String p = element.getAttribute(PRIORITY_ATTR);
                    int priority = VariableGroupFactoryReader.convertToInt(p);
                    IVariableGroupFactory factory = (IVariableGroupFactory)element.createExecutableExtension(CLASS_ATTR);
                    FactoryDescriptor descriptor = new FactoryDescriptor(priority, factory);
                    descriptors.add(descriptor);
                }
                catch (CoreException e) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                }
                ++n2;
            }
        }
        ArrayList<IVariableGroupFactory> factories = new ArrayList<IVariableGroupFactory>(descriptors.size());
        for (FactoryDescriptor descriptor : descriptors) {
            factories.add(descriptor.getFactory());
        }
        return factories;
    }

    private static int convertToInt(String intString) {
        if (intString == null || intString.trim().length() == 0) {
            return Integer.MAX_VALUE;
        }
        intString = intString.trim();
        try {
            return Integer.valueOf(intString);
        }
        catch (NumberFormatException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            return Integer.MAX_VALUE;
        }
    }

    private static class FactoryDescriptor {
        private final int _priority;
        private final IVariableGroupFactory _factory;

        FactoryDescriptor(int priority, IVariableGroupFactory factory) {
            this._priority = priority;
            this._factory = factory;
        }

        public int getPriority() {
            return this._priority;
        }

        public IVariableGroupFactory getFactory() {
            return this._factory;
        }
    }

    private static class FactoryDescriptorComparator
    implements Comparator<FactoryDescriptor> {
        private FactoryDescriptorComparator() {
        }

        @Override
        public int compare(FactoryDescriptor fd0, FactoryDescriptor fd1) {
            return fd0.getPriority() - fd1.getPriority();
        }
    }
}

