/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.IPathProvider;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferencePath;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import org.eclipse.jst.jsf.context.IModelContext;

public class VariableGroup
implements IPathProvider<List<Object>, ValueReference, IModelContext> {
    private String _groupLabel;
    private List<ValueReference> _varRefs;

    public VariableGroup(String groupLabel) {
        this._groupLabel = groupLabel;
        this._varRefs = new ArrayList<ValueReference>();
    }

    public void addValueReference(Variable variable) {
        this._varRefs.add(new ValueReference(variable, null));
    }

    public final List<ValueReference> getValueReferences() {
        return this._varRefs;
    }

    public String getLabel() {
        return this._groupLabel;
    }

    public boolean mayContain(ValueReference valueReference) {
        return this.findMatchingRoot(valueReference) != null;
    }

    private ValueReference findMatchingRoot(ValueReference valueReference) {
        for (ValueReference valueRef : this._varRefs) {
            if (!valueRef.getVariable().equals((Object)valueReference.getVariable())) continue;
            return valueRef;
        }
        return null;
    }

    public List<Object> findPath(ValueReference valueReference, IModelContext context) {
        ArrayList<Object> path = new ArrayList<Object>();
        ValueReference root = this.findMatchingRoot(valueReference);
        if (root == null) {
            return this.getNoPath();
        }
        path.add(this);
        ValueReferencePath refPath = root.getPath(valueReference, context);
        if (refPath == root.getNoPath()) {
            return this.getNoPath();
        }
        path.addAll(refPath.getFullPath());
        return path;
    }

    public List<Object> getNoPath() {
        return null;
    }

    public List<Object> getPath(ValueReference input, IModelContext context) {
        return this.findPath(input, context);
    }

    public List<Object> getPath(MethodReference input, IModelContext context) {
        return this.findPath(input, context);
    }

    public boolean mayContain(MethodReference methodReference) {
        return this.findMatchingRoot(methodReference) != null;
    }

    private MethodReference findMatchingRoot(MethodReference methodReference) {
        for (ValueReference valueRef : this._varRefs) {
            for (MethodReference ref : valueRef.getMethodReferences()) {
                if (!ref.matchesSignature(methodReference)) continue;
                return ref;
            }
        }
        return null;
    }

    public List<Object> findPath(MethodReference methodReference, IModelContext context) {
        ArrayList<Object> path = new ArrayList<Object>();
        ValueReference root = this.findMatchingRoot(methodReference.getValueReference());
        if (root == null) {
            return this.getNoPath();
        }
        path.add(this);
        ValueReferencePath refPath = root.getPath(methodReference.getValueReference(), context);
        if (refPath == root.getNoPath()) {
            return this.getNoPath();
        }
        path.addAll(refPath.getFullPath());
        path.add(methodReference);
        return path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VariableGroup)) {
            return false;
        }
        VariableGroup amIEqual = (VariableGroup)obj;
        if (!amIEqual._groupLabel.equals(this._groupLabel)) {
            return false;
        }
        if (amIEqual._varRefs.size() != this._varRefs.size()) {
            return false;
        }
        int i = 0;
        while (i < this._varRefs.size()) {
            if (!this._varRefs.get(i).equals((Object)amIEqual._varRefs.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this._groupLabel.hashCode() + this._varRefs.size();
    }
}

