/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.pagedesigner.commands.PaletteDropInsertCommand;
import org.eclipse.jst.pagedesigner.dnd.internal.SourceViewerDragDropHelper;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.palette.IDropSourceData;
import org.eclipse.jst.pagedesigner.editors.palette.ITagDropSourceData;
import org.eclipse.jst.pagedesigner.itemcreation.ITagDropOverrider;
import org.eclipse.jst.pagedesigner.utils.CommandUtil;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PaletteDropVarInsertCommand
extends PaletteDropInsertCommand {
    private Element _element;
    private int _location;

    public PaletteDropVarInsertCommand(String label, StructuredTextEditor editor, IDropSourceData dropSourceData, int location) {
        super(label, editor, dropSourceData, location);
        this._location = location;
    }

    public void doExecute() {
        Node node;
        try {
            node = this.getSourceEditingTextTools().getNode(this._location);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Bad value reference insertion location.");
            return;
        }
        Object position = null;
        position = node != null ? SourceViewerDragDropHelper.getInstance().findPosition(this._location, node) : (this.getModel().getDocument().getFirstChild() != null ? SourceViewerDragDropHelper.getInstance().findPosition(this.getModel().getDocument().getEndOffset(), this.getModel().getDocument().getFirstChild()) : new DOMPosition((Node)this.getModel().getDocument(), 0));
        IStatus status = this.performCustomization(this.getModel().getDocument(), (IDOMPosition)position);
        if (status.getSeverity() == 0) {
            ITagDropOverrider tagOverrider = (ITagDropOverrider)this.getCustomizationData().getAdapter(ITagDropOverrider.class);
            ValRefTagToolItem dropSourceData = new ValRefTagToolItem(tagOverrider.getTagNameOverride(), tagOverrider.getUriOverride());
            Element element = CommandUtil.executeInsertion((IDropSourceData)dropSourceData, (IDOMModel)this.getModel(), (IDOMPosition)position, (IAdaptable)this.getCustomizationData());
            if (element != null) {
                this.formatNode(element);
            }
            this._element = element;
        }
    }

    public void setSelection() {
        if (this._element != null) {
            int offset = EditModelQuery.getNodeStartIndex((Node)this._element);
            int length = EditModelQuery.getNodeEndIndex((Node)this._element) - offset;
            this._editor.getTextViewer().setSelectedRange(offset, length);
        }
    }

    private static class ValRefTagToolItem
    implements ITagDropSourceData {
        private String _uri;
        private String _tagName;

        public ValRefTagToolItem(String tagName, String uri) {
            this._tagName = tagName;
            this._uri = uri;
        }

        public String getId() {
            return this._tagName;
        }

        public String getNamespace() {
            return this._uri;
        }

        public String getDefaultPrefix() {
            return null;
        }

        public String getTagName() {
            return this._tagName;
        }
    }
}

