/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.AbstractVarAction;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesPaletteTreeEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class OpenTypeForVarAction
extends AbstractVarAction
implements IAction {
    public OpenTypeForVarAction(VariablesPaletteTreeEntry tool, HTMLEditor editor) {
        super(tool, editor);
    }

    public String getText() {
        return NLS.bind((String)Messages.OpenTypeForVarAction_Label, (Object)this.getDataTypeName());
    }

    public ImageDescriptor getImageDescriptor() {
        return Activator.Images.OPEN_TYPE.getImageDescriptor();
    }

    @Override
    public boolean isHandled() {
        return super.isHandled() && !this.isPrimitiveDataType() && !this.isUnknownDataType();
    }

    public void run() {
        IJavaElement type = this.getType();
        if (type != null) {
            try {
                JavaUI.openInEditor((IJavaElement)type, (boolean)true, (boolean)true);
            }
            catch (CoreException ex) {
                LoggingService.logError((Plugin)Activator.getDefault(), (String)ex.getMessage());
            }
        } else {
            MessageDialog.openInformation((Shell)this.getEditor().getEditorSite().getShell(), (String)Messages.OpenTypeForVarAction_missingTypeTitle, (String)NLS.bind((String)Messages.OpenTypeForVarAction_missingTypeMsg, (Object)this.getDataTypeName()));
        }
    }

    private IJavaElement getType() {
        String id = this.getDataTypeName();
        if (id != null) {
            IJavaProject javaProject = JavaCore.create((IProject)this.getVariable().getType().getProject().getEclipseProject());
            if (javaProject == null || !javaProject.exists()) {
                LoggingService.logError((Plugin)Activator.getDefault(), (String)("Unexpected Error:  java project does not exist for " + this.getValueReference().toString()));
                return null;
            }
            IType type = null;
            try {
                type = javaProject.findType(id.replace("$", "."));
                if (type != null && type.isAnonymous()) {
                    type = null;
                }
                return type;
            }
            catch (JavaModelException ex) {
                LoggingService.logError((Plugin)Activator.getDefault(), (String)ex.getMessage());
            }
        }
        return null;
    }
}

