/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesPaletteTreeEntry;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteTreeItem;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public abstract class AbstractVarAction
extends Action {
    private ValueReference _valRef;
    private HTMLEditor _editor;
    private TagToolPaletteEntry _tool;
    private IFile _file;

    public AbstractVarAction(VariablesPaletteTreeEntry tool, HTMLEditor editor) {
        this._tool = tool;
        this._editor = editor;
        IEditorInput editorInput = editor.getEditorInput();
        this._file = ((IFileEditorInput)editorInput).getFile();
        if (((PaletteTreeItem)tool.getPaletteItem()).getModel() instanceof ValueReference) {
            this._valRef = (ValueReference)((PaletteTreeItem)tool.getPaletteItem()).getModel();
        }
    }

    public AbstractVarAction(ValueReference valRef) {
        this._valRef = valRef;
    }

    public boolean isHandled() {
        return this._valRef != null;
    }

    protected ValueReference getValueReference() {
        return this._valRef;
    }

    protected HTMLEditor getEditor() {
        return this._editor;
    }

    protected TagToolPaletteEntry getTool() {
        return this._tool;
    }

    protected Variable getVariable() {
        return this._valRef.getVariable();
    }

    protected boolean isPrimitiveDataType() {
        DataType.Field field = this.getValueReference().getField((IModelContext)new FilePositionContext(this._file));
        if (field == null) {
            return this.getVariable().getType().isPrimitiveType();
        }
        return field.getType().isPrimitiveType();
    }

    protected String getDataTypeName() {
        DataType.Field field = this.getValueReference().getField((IModelContext)new FilePositionContext(this._file));
        if (field == null) {
            return this.getVariable().getType().getName();
        }
        if (field.getType().isArray()) {
            return field.getType().getComponentType().getName();
        }
        return field.getType().getName();
    }

    protected boolean isUnknownDataType() {
        DataType.Field field = this.getValueReference().getField((IModelContext)new FilePositionContext(this._file));
        if (field == null) {
            return this.getVariable().getType() == DataType.getUnspecifiedType();
        }
        return field.getType() == DataType.getUnspecifiedType();
    }

    protected final IFile getFile() {
        return this._file;
    }
}

