/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.IVariablesListener;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.NewArtificalVariableAction;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.OpenDeclarationForVarAction;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.OpenTypeForVarAction;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.PerformInsertVarAction;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroup;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesEditPartFactory;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesModel;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesPaletteTreeEntry;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesTreeModelAdapter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.HideImplicitVariablesFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.HideNoneScopedBeansFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.HideStringFieldsFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.NoEmptyFieldsFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.ShowUsedVariablesOnlyFilter;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteEntry;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteCategory;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteContributor;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteTree;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

abstract class AbstractDataPaletteContributor
extends PaletteContributor
implements IVariablesListener {
    private static final String BINDINGS = "bindings##PAGE_SCOPE";
    private static final String PAGE_VARIABLES = "PageVariables";
    private EditPartFactory _editPartFactory = new VariablesEditPartFactory();
    private VariablesModel _variablesModel;
    private VariablesTreeModelAdapter _treeModelAdapter;
    private PaletteTree _variablesTree;
    private ShowUsedVariablesOnlyFilter _showUsedVarsOnly;
    private boolean _inDisplayUsedVarsOnlyMode;

    public AbstractDataPaletteContributor(String id, Bundle contributingBundle, Integer priority, IFile file) {
        super(id, contributingBundle, priority, file);
    }

    @Override
    public final List<PaletteCategory> getContributions() {
        ArrayList<PaletteCategory> contributions = new ArrayList<PaletteCategory>();
        PaletteCategory category = this.createPaletteCategory();
        this._treeModelAdapter = this.createTreeModelAdapter();
        this._variablesTree = this.createVariablesTree(this._treeModelAdapter);
        category.getPaletteItems().clear();
        category.addPaletteItem(this._variablesTree);
        contributions.add(category);
        return contributions;
    }

    @Override
    public EditPartFactory getEditPartFactory() {
        return this._editPartFactory;
    }

    public boolean isInDisplayUsedVarsOnlyMode() {
        return this._inDisplayUsedVarsOnlyMode;
    }

    public void setDisplayUsedVarsOnlyMode(boolean mode) {
        this._inDisplayUsedVarsOnlyMode = mode;
        if (mode) {
            this._treeModelAdapter.addFilter(this._showUsedVarsOnly);
        } else {
            this._treeModelAdapter.removeFilter(this._showUsedVarsOnly);
        }
        this.refresh();
    }

    @Override
    public void fillContextMenu(IMenuManager menu, Object selectedModel) {
        if (selectedModel instanceof VariablesPaletteTreeEntry) {
            VariablesPaletteTreeEntry varEntry = (VariablesPaletteTreeEntry)selectedModel;
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (activeEditor instanceof HTMLEditor) {
                HTMLEditor editor = (HTMLEditor)activeEditor;
                if (varEntry.getModel() instanceof VariableGroup) {
                    VariableGroup varGroup = (VariableGroup)varEntry.getModel();
                    if (varGroup.getLabel().equals(Messages.VariablesTreeContentProvider_GroupLabel_PageVars)) {
                        menu.add((IAction)new NewArtificalVariableAction(varGroup, editor));
                    }
                } else if (!this.isAdfBinding(varEntry)) {
                    PerformInsertVarAction insertAction = new PerformInsertVarAction(varEntry, editor);
                    if (insertAction.isHandled()) {
                        menu.add((IAction)insertAction);
                    }
                    OpenTypeForVarAction typeAction = new OpenTypeForVarAction(varEntry, editor);
                    OpenDeclarationForVarAction declAction = new OpenDeclarationForVarAction(varEntry, editor);
                    if ((declAction.isHandled() || typeAction.isHandled()) && insertAction.isHandled()) {
                        menu.add((IContributionItem)new Separator());
                    }
                    if (typeAction.isHandled()) {
                        menu.add((IAction)typeAction);
                    }
                    if (declAction.isHandled()) {
                        menu.add((IAction)declAction);
                    }
                }
            }
        } else if (selectedModel instanceof DrawerEditPart) {
            super.fillContextMenu(menu, selectedModel);
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)new DisplayUsedVarsOnlyAction(this));
            return;
        }
        super.fillContextMenu(menu, selectedModel);
    }

    private boolean isAdfBinding(VariablesPaletteTreeEntry varEntry) {
        return varEntry.getTagName().startsWith(BINDINGS) && PAGE_VARIABLES.equals(varEntry.getURI());
    }

    public void refresh(IVariablesListener.VariableChangeEvent event) {
        this.refresh();
    }

    @Override
    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractDataPaletteContributor.this._variablesTree.getModelAdapter().firePropertyChanged(AbstractDataPaletteContributor.this._variablesModel, "CHILDREN_PROPERTY");
                AbstractDataPaletteContributor.this._variablesTree.getModelAdapter().firePropertyChanged(AbstractDataPaletteContributor.this._variablesModel, "DETAIL_PROPERTY");
            }
        });
    }

    protected void addFilters(VariablesTreeModelAdapter treeModelAdapter) {
        this._showUsedVarsOnly = new ShowUsedVariablesOnlyFilter(this.getFile());
        treeModelAdapter.addFilter(new NoEmptyFieldsFilter());
        treeModelAdapter.addFilter(new HideImplicitVariablesFilter());
        treeModelAdapter.addFilter(new HideNoneScopedBeansFilter());
        treeModelAdapter.addFilter(new HideStringFieldsFilter((IModelContext)new FilePositionContext(this.getFile())));
        treeModelAdapter.addFilter(new AdfBindingsFilter());
        if (this._inDisplayUsedVarsOnlyMode) {
            treeModelAdapter.addFilter(this._showUsedVarsOnly);
        }
    }

    @Override
    public void doUpdateFile(IFile newFile) {
        if (this._variablesModel != null) {
            this._variablesModel.dispose();
            this._variablesModel = null;
        }
    }

    protected VariablesModel getVariablesModel() {
        if (this._variablesModel == null) {
            VariableQuery.QueryMatcher matcher = this.getQueryMatcher();
            this._variablesModel = matcher != null ? new VariablesModel(this.getFile(), this, matcher) : new VariablesModel(this.getFile(), this);
        }
        return this._variablesModel;
    }

    @Override
    public void performInsertTag(TagToolPaletteEntry tool) {
        PerformInsertVarAction insertAction;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof HTMLEditor && tool instanceof VariablesPaletteTreeEntry && (insertAction = new PerformInsertVarAction((VariablesPaletteTreeEntry)tool, (HTMLEditor)editor)).isHandled()) {
            insertAction.run();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._variablesModel != null) {
            this._variablesModel.dispose();
            this._variablesModel = null;
        }
    }

    protected abstract VariableQuery.QueryMatcher getQueryMatcher();

    protected abstract PaletteCategory createPaletteCategory();

    protected abstract VariablesTreeModelAdapter createTreeModelAdapter();

    protected abstract PaletteTree createVariablesTree(VariablesTreeModelAdapter var1);

    private static class AdfBindingsFilter
    extends ViewerFilter
    implements IFilter {
        private AdfBindingsFilter() {
        }

        public boolean select(Object toTest) {
            return !(toTest instanceof VariableGroup) || !"ADF Bindings".equals(((VariableGroup)toTest).getLabel());
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.select(element);
        }
    }

    private static class DisplayUsedVarsOnlyAction
    extends Action {
        private AbstractDataPaletteContributor _contributor;

        public DisplayUsedVarsOnlyAction(AbstractDataPaletteContributor contributor) {
            super(Messages.DisplayUsedVarsOnlyAction_text);
            this.setToolTipText(Messages.DisplayUsedVarsOnlyAction_tooltip);
            if (contributor.isInDisplayUsedVarsOnlyMode()) {
                this.setChecked(true);
            }
            this._contributor = contributor;
        }

        public void run() {
            this._contributor.setDisplayUsedVarsOnlyMode(!this._contributor.isInDisplayUsedVarsOnlyMode());
            super.run();
        }
    }

    protected static class VariableSorter
    implements Comparator<DesignPaletteEntry> {
        protected VariableSorter() {
        }

        @Override
        public int compare(DesignPaletteEntry o1, DesignPaletteEntry o2) {
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 != null) {
                VariableGroup grp;
                if (!(o1 instanceof VariablesPaletteTreeEntry) || !(o2 instanceof VariablesPaletteTreeEntry)) {
                    return 0;
                }
                VariablesPaletteTreeEntry t1 = (VariablesPaletteTreeEntry)o1;
                VariablesPaletteTreeEntry t2 = (VariablesPaletteTreeEntry)o2;
                if (t1.getModel() instanceof VariableGroup && (grp = (VariableGroup)t1.getModel()).getLabel().equals(Messages.VariablesTreeContentProvider_GroupLabel_PageVars)) {
                    return -1;
                }
                if (t2.getModel() instanceof VariableGroup && (grp = (VariableGroup)t2.getModel()).getLabel().equals(Messages.VariablesTreeContentProvider_GroupLabel_PageVars)) {
                    return 1;
                }
                return t1.getTagName().compareTo(t2.getTagName());
            }
            return 0;
        }
    }
}

