/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.taglibs;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.appservices.IPreferredTagLibraryProvider;
import oracle.eclipse.tools.application.common.services.techextservices.IPreferredTagLibraryHandler;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.taglibs.InsertTagOnPageAction;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.taglibs.TagToolEditPartFactory;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteCategory;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteCategoryGroup;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteContributor;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteItem;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteContext;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class TagLibPaletteContributor
extends PaletteContributor {
    private static final PaletteCategoryGroup group = new PaletteCategoryGroup(Messages.TagLibPaletteContributor_CategoryGroupLabel, 0, null);
    private static ImageDescriptor DEFAULT_TAGLIB_ICON = Activator.Images.DEFAULT_TAGLIB_ICON.getImageDescriptor();
    private final EditPartFactory _editPartFactory = new TagToolEditPartFactory();
    private IPreferredTagLibraryProvider _preferredTagLibraryHandler;

    public TagLibPaletteContributor(String id, Bundle contributingBundle, Integer priority, IFile file) {
        super(id, contributingBundle, priority, file);
    }

    @Override
    public void doUpdateFile(IFile newFile) {
    }

    @Override
    public void fillContextMenu(IMenuManager menu, Object selectedModel) {
        if (selectedModel instanceof TagToolPaletteEntry) {
            TagToolPaletteEntry tool = (TagToolPaletteEntry)selectedModel;
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (activeEditor instanceof HTMLEditor) {
                menu.add((IAction)new InsertTagOnPageAction(tool, (HTMLEditor)activeEditor));
            }
        }
    }

    @Override
    public List<PaletteCategory> getContributions() {
        ArrayList<PaletteCategory> categories = new ArrayList<PaletteCategory>();
        IPaletteContext context = PaletteItemManager.createPaletteContext((IFile)this.getFile());
        PaletteItemManager manager = PaletteItemManager.getInstance((IPaletteContext)context);
        if (manager != null) {
            manager.reset();
            List cats = manager.getAllCategories();
            int i = 0;
            while (i < cats.size()) {
                TaglibPaletteDrawer entry = (TaglibPaletteDrawer)cats.get(i);
                PaletteCategory cat = new PaletteCategory(entry.getId(), this.getID(), entry.getDefaultPrefix(), entry.getLabel(), entry.getSmallIcon() != null ? entry.getSmallIcon() : DEFAULT_TAGLIB_ICON, entry.getLargeIcon() != null ? entry.getLargeIcon() : DEFAULT_TAGLIB_ICON);
                cat.setToolTip(entry.getDescription());
                cat.setGroup(group);
                int j = 0;
                while (j < entry.getChildren().size()) {
                    TagToolPaletteEntry tool = (TagToolPaletteEntry)entry.getChildren().get(j);
                    cat.addPaletteItem(this.toPaletteItem(tool, cat));
                    ++j;
                }
                if (cat.getPaletteItems().size() > 0 && !this.shouldNeverBeVisible(cat.getID())) {
                    categories.add(cat);
                }
                ++i;
            }
        }
        return categories;
    }

    private boolean shouldNeverBeVisible(String uri) {
        return uri.equals("http://java.sun.com/JSP/Page");
    }

    private PaletteItem toPaletteItem(TagToolPaletteEntry tool, PaletteCategory cat) {
        return new PaletteItem(tool.getTemplate(), tool.getLabel(), tool.getDescription(), tool.getSmallIcon(), tool.getLargeIcon());
    }

    @Override
    public EditPartFactory getEditPartFactory() {
        return this._editPartFactory;
    }

    @Override
    public void performInsertTag(TagToolPaletteEntry tool) {
        InsertTagOnPageAction insertAction;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof HTMLEditor && (insertAction = new InsertTagOnPageAction(tool, (HTMLEditor)editor)).isHandled()) {
            insertAction.run();
        }
    }

    @Override
    public boolean applySystemFilter(PaletteCategory categoryModel) {
        IPreferredTagLibraryHandler.Preference pref;
        IPreferredTagLibraryProvider handler = this.getPreferredTagLibraryHandlers();
        return handler != null && (pref = handler.handleTagLibrary(categoryModel.getID())) == IPreferredTagLibraryHandler.Preference.NOT_PREFERRED;
    }

    private IPreferredTagLibraryProvider getPreferredTagLibraryHandlers() {
        if (this._preferredTagLibraryHandler == null) {
            Project proj = (Project)this.getFile().getProject().getAdapter(Project.class);
            this._preferredTagLibraryHandler = (IPreferredTagLibraryProvider)proj.getAppService(IPreferredTagLibraryProvider.class);
        }
        return this._preferredTagLibraryHandler;
    }
}

