/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.bindedit;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.ui.bindedit.IVariableDataTypeValidator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.TypeComparator;
import org.eclipse.jst.jsf.common.internal.types.TypeComparatorDiagnosticFactory;
import org.eclipse.jst.jsf.common.internal.types.TypeComparatorPreferences;

public class JDTDataTypeValidator
implements IVariableDataTypeValidator {
    @Override
    public boolean isValidatorFor(DataType dataType) {
        return dataType instanceof JDTDataType;
    }

    @Override
    public IStatus validate(DataType dataType, IDocument baseDoc, int offset, List<String> acceptedBinarySigs, List<DataType> acceptedDataTypesSigs, String supportedTypesString) {
        JDTDataType javaType = (JDTDataType)dataType;
        CompositeType actualType = this.createFromDataType((DataType)javaType);
        if (actualType == null) {
            return Status.OK_STATUS;
        }
        TypeComparator typeComparator = new TypeComparator(new TypeComparatorDiagnosticFactory(new TypeComparatorPreferences()));
        CompositeType expectedType = new CompositeType(acceptedBinarySigs.toArray(new String[0]), 2);
        Diagnostic diag = typeComparator.calculateTypeCompatibility(expectedType, actualType);
        if (BasicDiagnostic.toIStatus((Diagnostic)diag).isOK()) {
            return Status.OK_STATUS;
        }
        for (DataType signature : acceptedDataTypesSigs) {
            if (!signature.isMatchable((DataType)javaType)) continue;
            return Status.OK_STATUS;
        }
        return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.bind((String)Messages.BindDialog_TypeErrorLabel, (Object)(supportedTypesString.length() > 0 ? supportedTypesString : Messages.BindDialog_Correct)));
    }

    private CompositeType createFromDataType(DataType dataType) {
        String typeName = this.getTypeSignature(dataType);
        if (typeName == null) {
            return null;
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add(typeName);
        types.addAll(dataType.getSuperClassSignatures());
        types.addAll(dataType.getSuperInterfaces());
        return new CompositeType(types.toArray(new String[types.size()]), 2);
    }

    private String getTypeSignature(DataType dataType) {
        if (dataType.isUnknown()) {
            return "Ljava.lang.Object;";
        }
        return JDTDataTypeValidator.createBinarySignature(dataType.getName());
    }

    private static String createBinarySignature(String name) {
        String newName = name;
        if (newName != null && !newName.startsWith(String.valueOf('['))) {
            newName = Signature.createTypeSignature((String)newName, (boolean)true);
        }
        return newName;
    }
}

