/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.bindedit;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.resource.IResourceBundleExt;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleKeyPair;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceObservableValue;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.services.documentservices.IDocumentBindersProvider;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webtier.ui.bindedit.AbstractViewChanger;
import oracle.eclipse.tools.webtier.ui.bindedit.IElBindingContext;
import oracle.eclipse.tools.webtier.ui.bindedit.KeyViewerUpdateValueStrategy;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.RefreshingValueReferenceTreeContentProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroup;
import oracle.eclipse.tools.webtier.ui.resource.internal.NewResourceKeyDialogCreationAdvisor;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceBundleKeyPairObservableValue;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceBundleKeyPairToBundleConverter;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceBundleKeyPairToValueReferenceConverter;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceFlatTreeContentProvider;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceFlatTreeKeyLabelProvider;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceFlatTreeValueLabelProvider;
import oracle.eclipse.tools.webtier.ui.resource.internal.ValueReferenceToResourceBundleKeyPairConverter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.CustomEditDialog;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditorDialog;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.DecoratingObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class BindDialog
extends PropertyEditorDialog {
    private static final int DEFAULT_WIDTH_HINT = 425;
    private static final int DEFAULT_HEIGHT_HINT = 250;
    private static final int DEFAULT_MIN_WIDTH = 200;
    private static final int DEFAULT_MIN_HEIGHT = 150;
    private IDocument _doc;
    private TreeViewer _viewer;
    private IStructuredContentProvider _bundleContentProvider;
    private IResourceBundleExt[] _bundleExts;
    private TableViewer _bundleViewer;
    private TreeViewer _keyViewer;
    private final IElBindingContext _elBindingCtx;
    private IElBindingContext.BindingContextTab _defaultTab;
    private TabItem _varsTab;
    private boolean _varsBindingsInitialized = false;
    private TabItem _rscsTab;
    private boolean _rscsBindingsInitialized = false;
    private TabItem _currentTab;
    private ToolItem _newKeyToolItem;
    private IObservableValue _intermediateModel;
    private IObservableValue _varsSelectionModel;
    private IObservableValue _rscsSelectionModel;
    private Binding _selectionBundleBinding;
    private IObservableValue _selectionKey;
    private Binding _selectionKeyBinding;
    private Binding _selectionBinding;
    private Binding _statusBinding;
    private final int _offset;
    private static ImageDescriptor VARS_TAB_IMG_DESC = null;
    private static ImageDescriptor RSCS_TAB_IMG_DESC = null;
    private static final ILabelProvider KEY_LABEL_PROVIDER = new ResourceFlatTreeKeyLabelProvider();
    private static final ILabelProvider VALUE_LABEL_PROVIDER = new ResourceFlatTreeValueLabelProvider();
    private static final String HELPID = "oracle.eclipse.tools.webtier.ui.ChooseBindingDialog";

    static {
        VARS_TAB_IMG_DESC = Activator.Images.VARS_TAB_ICON.getImageDescriptor();
        RSCS_TAB_IMG_DESC = Activator.Images.RSCS_TAB_ICON.getImageDescriptor();
    }

    public BindDialog(Shell parentShell, IObservableValue modelValue, IValidator validator, IDocument baseDoc, Integer offset, IElBindingContext bindingContext) {
        super(parentShell, "", null, (IObservable)modelValue, validator);
        this._doc = baseDoc;
        this._offset = offset == null ? 0 : offset;
        this._elBindingCtx = bindingContext;
        this.setStatusLineAboveButtons(true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELPID);
        shell.setText(this._elBindingCtx.getDialogTitle());
    }

    protected Label createMessageArea(Composite composite) {
        this.setMessage(this._elBindingCtx.getDialogInstructions());
        if (this.getMessage() == null) {
            return null;
        }
        return super.createMessageArea(composite);
    }

    public Control createEditingArea(Composite parent) {
        if (this._doc == null) {
            Label errorLabel = new Label(parent, 320);
            errorLabel.setText(Messages.BindDialog_NullDocErrorLabel);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.minimumWidth = 200;
            errorLabel.setLayoutData((Object)data);
            return errorLabel;
        }
        List<IElBindingContext.BindingContextTab> tabsToShow = this._elBindingCtx.getTabs();
        if (tabsToShow.size() == IElBindingContext.BindingContextTab.values().length) {
            TabFolder folder = new TabFolder(parent, 128);
            this._varsTab = new TabItem(folder, 0);
            this._varsTab.setText(Messages.BindDialog_VariablesTabLabel);
            this._varsTab.setImage(CommonImages.createImage((ImageDescriptor)VARS_TAB_IMG_DESC));
            this._varsTab.setControl(this.createVariablesPanel((Composite)folder, true));
            this._rscsTab = new TabItem(folder, 0);
            this._rscsTab.setText(Messages.BindDialog_ResourcesTabLabel);
            this._rscsTab.setImage(CommonImages.createImage((ImageDescriptor)RSCS_TAB_IMG_DESC));
            this._rscsTab.setControl(this.createResourcesPanel((Composite)folder));
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            data.minimumWidth = 200;
            data.minimumHeight = 150;
            data.widthHint = 425;
            data.heightHint = 250;
            folder.setLayoutData((Object)data);
            this.setDefaultTab(folder, this._varsTab, this._rscsTab);
            folder.addSelectionListener((SelectionListener)new TabListener());
            return folder;
        }
        if (tabsToShow.contains((Object)IElBindingContext.BindingContextTab.RESOURCES)) {
            this.setDefaultTab();
            return this.createResourcesPanel(parent);
        }
        if (tabsToShow.contains((Object)IElBindingContext.BindingContextTab.VARIABLES)) {
            this.setDefaultTab();
            return this.createVariablesPanel(parent, false);
        }
        this.setDefaultTab();
        return this.createVariablesPanel(parent, false);
    }

    private void setDefaultTab() {
        this._defaultTab = this._elBindingCtx.getDefaultTab();
    }

    private void setDefaultTab(TabFolder folder, TabItem varsTab, TabItem rscsTab) {
        this._defaultTab = this._elBindingCtx.getDefaultTab();
        if (this._defaultTab == IElBindingContext.BindingContextTab.RESOURCES) {
            folder.setSelection(rscsTab);
            this._currentTab = rscsTab;
        } else {
            this._currentTab = varsTab;
        }
    }

    Control createResourcesPanel(Composite parent) {
        Object model = this._elBindingCtx.getModel(IElBindingContext.BindingContextTab.RESOURCES);
        this._bundleContentProvider = this._elBindingCtx.getContentProvider(IElBindingContext.BindingContextTab.RESOURCES);
        this._bundleExts = (IResourceBundleExt[])this._bundleContentProvider.getElements(model);
        if (this._bundleExts.length > 0) {
            boolean showBundles = this._bundleExts.length > 1;
            Composite panel = new Composite(parent, 0);
            GridLayout panelLayout = new GridLayout();
            panelLayout.numColumns = showBundles ? 2 : 1;
            panel.setLayout((Layout)panelLayout);
            if (showBundles) {
                Label bundleLabel = new Label(panel, 0);
                bundleLabel.setText(Messages.BindDialog_ResourceBundlesLabel);
                bundleLabel.setLayoutData((Object)new GridData(768));
            }
            Composite controlPanel = this.createPanel(panel, 3, false, false);
            controlPanel.setLayoutData((Object)new GridData(768));
            Label keyLabel = new Label(controlPanel, 256);
            keyLabel.setText(Messages.ResourceKeyDialog_ResourceInstructionsLabel);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.minimumWidth = 4;
            keyLabel.setLayoutData((Object)data);
            AbstractViewChanger viewChanger = new AbstractViewChanger(controlPanel, AbstractViewChanger.View.RESOURCE_KEYS){

                @Override
                public void changeView(AbstractViewChanger.View oldView, AbstractViewChanger.View newView) {
                    if (newView == AbstractViewChanger.View.RESOURCE_KEYS) {
                        BindDialog.this._keyViewer.setLabelProvider((IBaseLabelProvider)KEY_LABEL_PROVIDER);
                    } else if (newView == AbstractViewChanger.View.RESOURCE_VALUES) {
                        BindDialog.this._keyViewer.setLabelProvider((IBaseLabelProvider)VALUE_LABEL_PROVIDER);
                    }
                }
            };
            GridData data2 = new GridData();
            data2.horizontalAlignment = 131072;
            viewChanger.getControl().setLayoutData((Object)data2);
            ToolBar newKeyToolBar = new ToolBar(controlPanel, 0x800000);
            this._newKeyToolItem = new ToolItem(newKeyToolBar, 8);
            this._newKeyToolItem.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_ADD));
            this._newKeyToolItem.setToolTipText(Messages.ResourceKeyDialog_NewKeyTooltip);
            GridData data3 = new GridData();
            data3.horizontalAlignment = 131072;
            newKeyToolBar.setLayoutData((Object)data3);
            this._newKeyToolItem.addSelectionListener((SelectionListener)new NewKeyToolItemListener());
            if (showBundles) {
                this._bundleViewer = new TableViewer(panel);
                ColumnViewerToolTipSupport.enableFor((ColumnViewer)this._bundleViewer);
                this._bundleViewer.setLabelProvider(this._elBindingCtx.getLabelProvider(IElBindingContext.BindingContextTab.RESOURCES));
                this._bundleViewer.setContentProvider((IContentProvider)this._bundleContentProvider);
                this.addFilters((StructuredViewer)this._bundleViewer, this._elBindingCtx.getFilters(IElBindingContext.BindingContextTab.RESOURCES));
                this.addSorting((StructuredViewer)this._bundleViewer, this._elBindingCtx.getSorter(IElBindingContext.BindingContextTab.RESOURCES));
                this._bundleViewer.setInput(model);
                this._bundleViewer.getControl().setLayoutData((Object)new GridData(1808));
            }
            Tree tree = new Tree(panel, 2820);
            this._keyViewer = new TreeViewer(tree);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this._keyViewer);
            this._keyViewer.setLabelProvider((IBaseLabelProvider)KEY_LABEL_PROVIDER);
            ResourceFlatTreeContentProvider contentProvider = new ResourceFlatTreeContentProvider(this._doc.getProject());
            this._keyViewer.setContentProvider((IContentProvider)contentProvider);
            this._keyViewer.getControl().setLayoutData((Object)new GridData(1808));
            this._keyViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection ssel = (IStructuredSelection)selection;
                        Object item = ssel.getFirstElement();
                        if (item instanceof ResourceBundleKeyPair) {
                            IStatus status;
                            Object validationStatus;
                            if (BindDialog.this.validationBinding != null && (validationStatus = BindDialog.this.validationBinding.getValidationStatus().getValue()) instanceof IStatus && (status = (IStatus)validationStatus).isOK()) {
                                BindDialog.this.okPressed();
                            }
                        } else if (BindDialog.this._keyViewer.getExpandedState(item)) {
                            BindDialog.this._keyViewer.collapseToLevel(item, 1);
                        } else {
                            BindDialog.this._keyViewer.expandToLevel(item, 1);
                        }
                    }
                }
            });
            return panel;
        }
        return new Composite(parent, 0);
    }

    private Composite createPanel(Composite parent, int numColumns, boolean equalWidth, boolean addMargins) {
        return this.createPanel(parent, numColumns, equalWidth, addMargins, false);
    }

    private Composite createPanel(Composite parent, int numColumns, boolean equalWidth, boolean addMargins, boolean noSpacing) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = null;
        layout = addMargins ? GridLayoutFactory.fillDefaults().margins(5, 5).create() : GridLayoutFactory.fillDefaults().margins(0, 0).create();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = equalWidth;
        if (noSpacing) {
            layout.verticalSpacing = 3;
            layout.horizontalSpacing = 0;
        }
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        BindDialog.applyDialogFont((Control)panel);
        return panel;
    }

    Control createVariablesPanel(Composite parent, boolean showInstructions) {
        Composite panel = parent;
        if (showInstructions) {
            panel = this.createPanel(parent, 1, true, this._elBindingCtx.getTabs().size() == IElBindingContext.BindingContextTab.values().length);
            Label instructions = new Label(panel, 64);
            instructions.setText(this._elBindingCtx.getTabInstructions(IElBindingContext.BindingContextTab.VARIABLES));
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            instructions.setLayoutData((Object)data);
        }
        Object model = this._elBindingCtx.getModel(IElBindingContext.BindingContextTab.VARIABLES);
        Tree tree = new Tree(panel, 2820);
        this._viewer = new TreeViewer(tree);
        this._viewer.setLabelProvider(this._elBindingCtx.getLabelProvider(IElBindingContext.BindingContextTab.VARIABLES));
        this._viewer.setContentProvider((IContentProvider)this._elBindingCtx.getContentProvider(IElBindingContext.BindingContextTab.VARIABLES));
        this._viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IBaseLabelProvider lp = BindDialog.this._elBindingCtx.getLabelProvider(IElBindingContext.BindingContextTab.VARIABLES);
                if (lp instanceof ILabelProvider) {
                    String e1Label = ((ILabelProvider)lp).getText(e1);
                    String e2Label = ((ILabelProvider)lp).getText(e2);
                    return e1Label.compareTo(e2Label);
                }
                return super.compare(viewer, e1, e2);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this._viewer);
        this._viewer.setAutoExpandLevel(2);
        this.addFilters((StructuredViewer)this._viewer, this._elBindingCtx.getFilters(IElBindingContext.BindingContextTab.VARIABLES));
        this.addSorting((StructuredViewer)this._viewer, this._elBindingCtx.getSorter(IElBindingContext.BindingContextTab.VARIABLES));
        this._viewer.setInput(model);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        if (this._elBindingCtx.getTabs().size() != IElBindingContext.BindingContextTab.values().length) {
            data.minimumWidth = 200;
            data.minimumHeight = 150;
            data.widthHint = 425;
            data.heightHint = 250;
        }
        this._viewer.getControl().setLayoutData((Object)data);
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)selection;
                    Object item = ssel.getFirstElement();
                    if (item instanceof ValueReference) {
                        IStatus status;
                        Object validationStatus;
                        if (BindDialog.this.validationBinding != null && (validationStatus = BindDialog.this.validationBinding.getValidationStatus().getValue()) instanceof IStatus && (status = (IStatus)validationStatus).isOK()) {
                            BindDialog.this.okPressed();
                        }
                    } else if (BindDialog.this._viewer.getExpandedState(item)) {
                        BindDialog.this._viewer.collapseToLevel(item, 1);
                    } else {
                        BindDialog.this._viewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        if (showInstructions) {
            return panel;
        }
        return this._viewer.getControl();
    }

    private void addFilters(StructuredViewer viewer, List<ViewerFilter> filters) {
        for (ViewerFilter filter : filters) {
            viewer.addFilter(filter);
        }
    }

    private void addSorting(StructuredViewer viewer, ViewerComparator sorter) {
        if (sorter != null) {
            viewer.setComparator(sorter);
        }
    }

    public void bindData() {
        this._intermediateModel = new ValueReferenceObservableValue(null);
        this.createUpdateModelBinding(this._intermediateModel);
        if (this.updateModelBinding == null) {
            this.getStatusObservableValue().setValue((Object)new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.BindDialog_NullUpdateModelBindingErrorLabel));
            return;
        }
        this.updateModelBinding.updateTargetToModel();
        if (this._defaultTab == IElBindingContext.BindingContextTab.VARIABLES) {
            this.initVariablesBindings(this._intermediateModel);
        } else {
            this.initResourcesBindings(this._intermediateModel);
        }
    }

    private void createStatusBinding() {
        if (this.validationBinding == null) {
            return;
        }
        if (this._statusBinding != null) {
            this._statusBinding.dispose();
            this._statusBinding = null;
        }
        this._statusBinding = this.context.bindValue(this.getStatusObservableValue(), (IObservableValue)new ComputedValue(this.context.getValidationRealm(), IStatus.class){

            protected Object calculate() {
                return BindDialog.this.validationBinding.getValidationStatus().getValue();
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
    }

    private void clearValidationBinding() {
        if (this.validationBinding != null) {
            this.validationBinding.dispose();
            this.validationBinding = null;
        }
    }

    private void initVariablesBindings(IObservableValue intermediate) {
        this._varsSelectionModel = ViewersObservables.observeSingleSelection((Viewer)this._viewer);
        this.clearValidationBinding();
        this.createVarsValidationBinding(this._varsSelectionModel, intermediate);
        this.validationBinding.updateModelToTarget();
        this.makeDefaultVariablesSelection();
        this.createStatusBinding();
        this._varsBindingsInitialized = true;
    }

    private void reinitVariablesBindings(IObservableValue selection, IObservableValue intermediate) {
        this.clearValidationBinding();
        this.createVarsValidationBinding(selection, intermediate);
        this.validationBinding.updateModelToTarget();
        this.makeDefaultVariablesSelection();
        this.createStatusBinding();
    }

    private void makeDefaultVariablesSelection() {
        IStructuredSelection sel = (IStructuredSelection)this._viewer.getSelection();
        if (sel.isEmpty() && this._viewer.getTree().getItemCount() > 0) {
            Object data = this._viewer.getTree().getItem(0).getData();
            this._viewer.setSelection((ISelection)new StructuredSelection(data));
        }
    }

    private void createVarsValidationBinding(IObservableValue selection, IObservableValue intermediate) {
        this.validationBinding = this.context.bindValue(selection, intermediate, new UpdateValueStrategy().setAfterGetValidator(this._elBindingCtx.getValidator(IElBindingContext.BindingContextTab.VARIABLES)), (UpdateValueStrategy)new MyTreeViewerUpdateStrategy(UpdateValueStrategy.POLICY_ON_REQUEST, this._viewer, this._doc));
    }

    private void initResourcesBindings(IObservableValue intermediate) {
        this._rscsSelectionModel = new ResourceBundleKeyPairObservableValue();
        this.clearValidationBinding();
        this.createRscsValidationBinding(this._rscsSelectionModel, intermediate);
        this.validationBinding.updateModelToTarget();
        IViewerObservableValue selectionBundle = null;
        if (this._bundleViewer != null) {
            selectionBundle = ViewersObservables.observeSingleSelection((Viewer)this._bundleViewer);
            this._selectionBundleBinding = this.context.bindValue((IObservableValue)selectionBundle, this._rscsSelectionModel, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST).setConverter((IConverter)new ResourceBundleKeyPairToBundleConverter()));
        } else {
            selectionBundle = new WritableValue((Object)this._bundleExts[0], IResourceBundleExt.class);
        }
        IObservableValue viewerInput = ViewersObservables.observeInput((Viewer)this._keyViewer);
        ViewerInputObservableValue keyViewerInput = new ViewerInputObservableValue(viewerInput, this._keyViewer);
        this.context.bindValue((IObservableValue)keyViewerInput, (IObservableValue)selectionBundle, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy());
        this.context.bindValue((IObservableValue)new SimpleToolItemEnablementObservable(this._newKeyToolItem), (IObservableValue)new ComputedValue((IObservableValue)keyViewerInput){
            private final /* synthetic */ IObservableValue val$keyViewerInput;
            {
                this.val$keyViewerInput = iObservableValue;
            }

            protected Object calculate() {
                Object value = this.val$keyViewerInput.getValue();
                if (value == null) {
                    return Boolean.FALSE;
                }
                if (value instanceof IResourceBundleExt) {
                    IStatus status = ((IResourceBundleExt)value).getModificationStatus();
                    if (status.isOK()) {
                        BindDialog.this._newKeyToolItem.setToolTipText(Messages.ResourceKeyDialog_NewKeyTooltip);
                        return Boolean.TRUE;
                    }
                    BindDialog.this._newKeyToolItem.setToolTipText(status.getMessage());
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        this._selectionKey = ViewersObservables.observeSingleSelection((Viewer)this._keyViewer);
        this._selectionKeyBinding = this.context.bindValue(this._selectionKey, this._rscsSelectionModel, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)new KeyViewerUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST, this._keyViewer));
        if (this._selectionBundleBinding != null) {
            this._selectionBundleBinding.updateModelToTarget();
        }
        this._selectionKeyBinding.updateModelToTarget();
        this.makeDefaultResourcesSelection();
        this.createSelectionBinding(this._rscsSelectionModel, this._selectionKey);
        this.createStatusBinding();
        this._rscsBindingsInitialized = true;
    }

    private void reinitResourcesBindings(IObservableValue selection, IObservableValue intermediate) {
        this.clearValidationBinding();
        if (this._selectionBinding != null) {
            this._selectionBinding.dispose();
            this._selectionBinding = null;
        }
        this.createRscsValidationBinding(selection, intermediate);
        this.validationBinding.updateModelToTarget();
        if (this._selectionBundleBinding != null) {
            this._selectionBundleBinding.updateModelToTarget();
        }
        this._selectionKeyBinding.updateModelToTarget();
        this.makeDefaultResourcesSelection();
        this.createSelectionBinding(selection, this._selectionKey);
        this.createStatusBinding();
    }

    private void makeDefaultResourcesSelection() {
        Object data;
        IStructuredSelection sel;
        if (this._bundleViewer != null && (sel = (IStructuredSelection)this._bundleViewer.getSelection()).isEmpty()) {
            data = this._bundleViewer.getTable().getItem(0).getData();
            this._bundleViewer.setSelection((ISelection)new StructuredSelection(data));
        }
        if ((sel = (IStructuredSelection)this._keyViewer.getSelection()).isEmpty() && this._keyViewer.getTree().getItemCount() > 0) {
            data = this._keyViewer.getTree().getItem(0).getData();
            this._keyViewer.setSelection((ISelection)new StructuredSelection(data));
        }
    }

    private void createRscsValidationBinding(IObservableValue selection, IObservableValue intermediate) {
        this.validationBinding = this.context.bindValue(selection, intermediate, new UpdateValueStrategy().setConverter((IConverter)new ResourceBundleKeyPairToValueReferenceConverter()).setAfterConvertValidator(this._elBindingCtx.getValidator(IElBindingContext.BindingContextTab.RESOURCES)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST).setConverter((IConverter)new ValueReferenceToResourceBundleKeyPairConverter((IFilePositionContext)new FilePositionContext(this._offset, this._doc.getFile()))));
    }

    private void createSelectionBinding(IObservableValue selection, IObservableValue selectionKey) {
        this._selectionBinding = this.context.bindValue(selection, selectionKey, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy());
    }

    private void createUpdateModelBinding(IObservableValue intermediateObservableValue) {
        if (this._doc != null) {
            if (this.updateModelBinding != null && !this.updateModelBinding.isDisposed()) {
                this.updateModelBinding.dispose();
            }
            IDocumentBindersProvider dbp = (IDocumentBindersProvider)this._doc.getAdapter(IDocumentBindersProvider.class);
            this.updateModelBinding = dbp.createBinding(this.context, (IObservableValue)this.modelObservable, intermediateObservableValue);
        }
    }

    protected void bindOkButton(Button button) {
        this.context.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)button), (IObservableValue)new ComputedValue(this.context.getValidationRealm(), Boolean.class){

            protected Object calculate() {
                if (BindDialog.this.validationBinding == null) {
                    return false;
                }
                Object value = BindDialog.this.validationBinding.getValidationStatus().getValue();
                if (!(value instanceof IStatus)) {
                    return null;
                }
                IStatus status = (IStatus)value;
                boolean isOk = status.isOK() || status.matches(1) || status.matches(2);
                return isOk;
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
    }

    protected void performModelBindingUpdate() {
        this.updateModelBinding.updateModelToTarget();
        this.triggerUnsetBindings();
    }

    private static final class MyTreeViewerUpdateStrategy
    extends UpdateValueStrategy {
        private final TreeViewer _treeViewer;
        private final IDocument _document;

        public MyTreeViewerUpdateStrategy(int updatePolicy, TreeViewer treeViewer, IDocument document) {
            super(updatePolicy);
            this._treeViewer = treeViewer;
            this._document = document;
        }

        protected IStatus doSet(IObservableValue observableValue, Object value) {
            if (!(value instanceof ValueReference)) {
                if (value == null) {
                    return super.doSet(observableValue, value);
                }
                throw new IllegalArgumentException("value must be a value reference");
            }
            ValueReference valueReference = (ValueReference)value;
            Object[] elements = ((RefreshingValueReferenceTreeContentProvider)this._treeViewer.getContentProvider()).getElements(this._treeViewer.getInput());
            ArrayList<VariableGroup> possiblePaths = new ArrayList<VariableGroup>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof VariableGroup && ((VariableGroup)element).mayContain(valueReference)) {
                    possiblePaths.add((VariableGroup)element);
                }
                ++n2;
            }
            if (possiblePaths.size() > 0) {
                if (possiblePaths.size() > 1) {
                    throw new IllegalStateException("Should only be one matching variable in the tree");
                }
                VariableGroup selectionRoot = (VariableGroup)possiblePaths.get(0);
                List<Object> path = selectionRoot.getPath(valueReference, (IModelContext)new FilePositionContext(this._document.getFile()));
                if (path != selectionRoot.getNoPath()) {
                    path.add(0, this._treeViewer.getInput());
                    for (Object e : path) {
                        this._treeViewer.expandToLevel(e, 1);
                    }
                    return super.doSet(observableValue, value);
                }
            }
            return Status.OK_STATUS;
        }
    }

    private final class NewKeyToolItemListener
    extends SelectionAdapter {
        private NewKeyToolItemListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            Binding binding = null;
            try {
                ResourceBundleKeyPairObservableValue userModel = new ResourceBundleKeyPairObservableValue();
                binding = BindDialog.this.context.bindValue((IObservableValue)userModel, BindDialog.this._intermediateModel, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new ResourceBundleKeyPairToValueReferenceConverter()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
                NewResourceKeyDialogCreationAdvisor advisor = new NewResourceKeyDialogCreationAdvisor(new DataBindingContext(), userModel, (IResourceBundleExt)BindDialog.this._keyViewer.getInput());
                CustomEditDialog dialog = new CustomEditDialog(new IShellProvider(){

                    public Shell getShell() {
                        return BindDialog.this.getShell();
                    }
                }, (AbstractDialogEditorCreationAdvisor)advisor);
                dialog.open();
                BindDialog.this.validationBinding.updateModelToTarget();
                if (BindDialog.this._selectionBundleBinding != null) {
                    BindDialog.this._selectionBundleBinding.updateModelToTarget();
                }
                BindDialog.this._selectionKeyBinding.updateModelToTarget();
            }
            finally {
                if (binding != null && !binding.isDisposed()) {
                    binding.dispose();
                    binding = null;
                }
            }
        }
    }

    private static final class SimpleToolItemEnablementObservable
    extends WritableValue {
        private final ToolItem _toolItem;

        public SimpleToolItemEnablementObservable(ToolItem toolItem) {
            super((Object)toolItem.getEnabled(), Boolean.class);
            this._toolItem = toolItem;
        }

        public void doSetValue(Object value) {
            this._toolItem.setEnabled(((Boolean)value).booleanValue());
            super.doSetValue(value);
        }
    }

    private class TabListener
    implements SelectionListener {
        private TabListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent event) {
            BindDialog.this._currentTab = (TabItem)event.item;
            if (BindDialog.this._currentTab == BindDialog.this._rscsTab) {
                if (BindDialog.this._rscsBindingsInitialized) {
                    BindDialog.this.reinitResourcesBindings(BindDialog.this._rscsSelectionModel, BindDialog.this._intermediateModel);
                } else {
                    BindDialog.this.initResourcesBindings(BindDialog.this._intermediateModel);
                }
            } else if (BindDialog.this._currentTab == BindDialog.this._varsTab) {
                if (BindDialog.this._varsBindingsInitialized) {
                    BindDialog.this.reinitVariablesBindings(BindDialog.this._varsSelectionModel, BindDialog.this._intermediateModel);
                } else {
                    BindDialog.this.initVariablesBindings(BindDialog.this._intermediateModel);
                }
            }
        }
    }

    private static final class ViewerInputObservableValue
    extends DecoratingObservableValue {
        private final TreeViewer _viewer;

        public ViewerInputObservableValue(IObservableValue viewerInputObservable, TreeViewer viewer) {
            super(viewerInputObservable, true);
            this._viewer = viewer;
        }

        public void setValue(Object value) {
            this.checkRealm();
            this._viewer.setSelection((ISelection)StructuredSelection.EMPTY);
            super.setValue(value);
        }
    }
}

