/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.viewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.common.IControllerContext;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.LayoutObject;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.RadioFieldGroupType;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.provider.IFormsPropertyDescriptor;
import oracle.eclipse.tools.xml.edit.ui.viewer.AbstractFieldGroupComposite;
import oracle.eclipse.tools.xml.edit.ui.viewer.ActionHyperlink;
import oracle.eclipse.tools.xml.edit.ui.viewer.FieldComposite;
import oracle.eclipse.tools.xml.edit.ui.viewer.FieldGroupComposite;
import oracle.eclipse.tools.xml.edit.ui.viewer.GroupFactory;
import oracle.eclipse.tools.xml.edit.ui.viewer.IUIInstrumentation;
import oracle.eclipse.tools.xml.edit.ui.viewer.LayoutObjectComposite;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class RadioFieldGroupComposite
extends AbstractFieldGroupComposite {
    private final List<ButtonEditorInfo> editors = new ArrayList<ButtonEditorInfo>();

    public RadioFieldGroupComposite(GroupFactory groupFactory, RadioFieldGroupType fieldGroup, IControllerContext context, EObject eObject, ILabelProvider labelProvider) {
        super(groupFactory, fieldGroup, context, eObject, labelProvider);
    }

    private ButtonEditorInfo getFirstEditorWithData() {
        for (ButtonEditorInfo info : this.editors) {
            for (EStructuralFeature feature : info.getFeatures()) {
                Object result;
                if (!this.getEObject().eIsSet(feature) || (result = this.getEObject().eGet(feature)) == null) continue;
                return info;
            }
        }
        return this.editors.size() > 0 ? this.editors.get(0) : null;
    }

    @Override
    protected List<LayoutObjectComposite.AttrControlPair> createChildControls() {
        Object layoutComposite;
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        ArrayList<Object> layoutComposites = new ArrayList<Object>();
        for (LayoutObject layoutObject : this.getFieldGroup().getLayoutObjects()) {
            layoutComposite = this.getGroupFactory().create(layoutObject, this.getContext(), this.getEObject(), this.getLabelProvider());
            layoutComposites.add(layoutComposite);
            if (layoutComposite instanceof FieldComposite) {
                features.add(((FieldComposite)layoutComposite).getFeature());
                continue;
            }
            features.add(null);
        }
        int i = 0;
        while (i < layoutComposites.size()) {
            EStructuralFeature feature = (EStructuralFeature)features.get(i);
            if (feature != null) {
                layoutComposite = (FieldComposite)layoutComposites.get(i);
                IObservableValue modelObservable = this.createModelObservable(((LayoutObjectComposite)layoutComposite).getEObject(), feature, features);
                ((FieldComposite)layoutComposite).setModelObservable(modelObservable);
            }
            ++i;
        }
        ArrayList<LayoutObjectComposite.AttrControlPair> pairs = new ArrayList<LayoutObjectComposite.AttrControlPair>();
        for (LayoutObjectComposite layoutComposite2 : layoutComposites) {
            pairs.addAll(this.layoutChild(layoutComposite2));
        }
        if (this._container instanceof Section) {
            ((Section)this._container).setExpanded(true);
        }
        ButtonEditorInfo toSelect = this.getFirstEditorWithData();
        final ArrayList<ButtonEditorInfo> editorList = new ArrayList<ButtonEditorInfo>(this.editors);
        for (ButtonEditorInfo info : this.editors) {
            if (info == toSelect) {
                for (PropertyEditor pe : info.getEditors()) {
                    pe.setEnabled(true);
                }
                info.getButton().setSelection(true);
            } else {
                for (PropertyEditor pe : info.getEditors()) {
                    pe.setEnabled(false);
                }
            }
            info.getButton().addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    Button radioButton = (Button)e.widget;
                    for (ButtonEditorInfo beInfo : editorList) {
                        Button otherButton = beInfo.getButton();
                        if (radioButton.equals(otherButton)) {
                            for (PropertyEditor pe : beInfo.getEditors()) {
                                pe.setEnabled(true);
                            }
                            radioButton.setSelection(true);
                            continue;
                        }
                        for (PropertyEditor pe : beInfo.getEditors()) {
                            pe.setEnabled(false);
                        }
                        otherButton.setSelection(false);
                    }
                }
            });
        }
        return pairs;
    }

    private IObservableValue createModelObservable(EObject eObject, EStructuralFeature featureToSet, List<EStructuralFeature> features) {
        ArrayList<EStructuralFeature> featuresToUnset = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature feature : features) {
            if (featureToSet.equals(feature)) continue;
            featuresToUnset.add(feature);
        }
        if (featuresToUnset.size() > 0) {
            return new MutuallyExclusiveEObjectObservableValue(eObject, featureToSet, featuresToUnset);
        }
        return null;
    }

    @Override
    protected List<LayoutObjectComposite.AttrControlPair> layoutChild(LayoutObjectComposite child) {
        Composite container = this._container;
        if (this._container instanceof Section) {
            container = (Composite)((Section)this._container).getClient();
        }
        Button radioButton = null;
        ActionHyperlink propertyHyperlink = null;
        if (child instanceof FieldComposite) {
            FieldType field = ((FieldComposite)child).getField();
            IFormsPropertyDescriptor pd = field.getPropertyDescriptors();
            if (pd == null) {
                LoggingService.logError((Plugin)Activator.getDefault(), (String)Messages.bind((String)Messages.NoFormsPropertyDescriptor, (Object)(String.valueOf(field.getName()) + ':' + this.getEObject())));
                return Collections.emptyList();
            }
            IItemPropertyDescriptor ipd = pd.getItemPropertyDescriptor();
            if (!ipd.canSetProperty((Object)this.getEObject())) {
                return Collections.emptyList();
            }
            EAttribute feature = (EAttribute)pd.getFeature(this.getEObject());
            String name = this.getLabelProvider().getText((Object)pd);
            if (this.getContext().enableHyperlinks()) {
                Composite radioComposite = this.getContext().getWidgetAdapter().createComposite(container);
                GridLayout layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                radioComposite.setLayout((Layout)layout);
                GridData data = new GridData();
                data.horizontalSpan = 1;
                data.horizontalAlignment = 4;
                radioComposite.setLayoutData((Object)data);
                radioButton = this.getContext().getWidgetAdapter().createButton(radioComposite, null, 16);
                GridData data2 = new GridData();
                radioButton.setLayoutData((Object)data2);
                IUIInstrumentation.InstrumentFlags.LABEL_IS_PROPERTY.set((Control)radioButton);
                propertyHyperlink = new ActionHyperlink(radioComposite, 0);
                propertyHyperlink.setText(name);
                propertyHyperlink.setToolTipText(Messages.HyperlinkTooltipMsg);
                this.getContext().getWidgetAdapter().getHyperlinkGroup().add((Hyperlink)propertyHyperlink);
                List<IHyperlink> links = this.getContext().getHyperlinks(this.getEObject(), feature);
                propertyHyperlink.setEnabled(links.size() > 0);
                if (links.size() > 0) {
                    propertyHyperlink.setActions(links);
                }
                data = new GridData();
                data.horizontalAlignment = 4;
                propertyHyperlink.setLayoutData(data);
            } else {
                radioButton = this.getContext().getWidgetAdapter().createButton(container, name, 16);
                GridData data = new GridData();
                data.horizontalSpan = 1;
                data.horizontalAlignment = 4;
                radioButton.setLayoutData((Object)data);
            }
        }
        List<LayoutObjectComposite.AttrControlPair> pairs = child.createControls(container);
        if (child instanceof FieldComposite) {
            FieldComposite fieldComposite = (FieldComposite)child;
            this.editors.add(new ButtonEditorInfo(radioButton, fieldComposite.getEditor(), fieldComposite.getFeature()));
            if (propertyHyperlink != null && propertyHyperlink.isEnabled()) {
                AbstractFieldGroupComposite.HyperlinkDisablementObservable hyperlinkObservable = new AbstractFieldGroupComposite.HyperlinkDisablementObservable(propertyHyperlink);
                IObservableValue modelObservable = fieldComposite.getBoundModelObservable();
                this.getContext().getDataBindingContext().bindValue((IObservableValue)hyperlinkObservable, modelObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
            }
            this.setFirstPropertyEditor(((FieldComposite)child).getEditor());
        } else if (child instanceof FieldGroupComposite) {
            FieldGroupComposite fg = (FieldGroupComposite)child;
            this.editors.add(new ButtonEditorInfo(fg.getRadioButton(), fg.getEditors(), fg.getFeatures()));
        }
        return pairs;
    }

    static final class ButtonEditorInfo {
        private final Button _button;
        private final List<PropertyEditor> _editors;
        private final List<EStructuralFeature> _features;

        public ButtonEditorInfo(Button button, PropertyEditor editor, EStructuralFeature feature) {
            this._button = button;
            ArrayList<PropertyEditor> editorsList = new ArrayList<PropertyEditor>(1);
            editorsList.add(editor);
            this._editors = Collections.unmodifiableList(editorsList);
            ArrayList<EStructuralFeature> featuresList = new ArrayList<EStructuralFeature>(1);
            featuresList.add(feature);
            this._features = Collections.unmodifiableList(featuresList);
        }

        public ButtonEditorInfo(Button button, List<PropertyEditor> editors, List<EStructuralFeature> features) {
            this._button = button;
            ArrayList<PropertyEditor> editorsList = new ArrayList<PropertyEditor>();
            editorsList.addAll(editors);
            this._editors = Collections.unmodifiableList(editorsList);
            ArrayList<EStructuralFeature> featuresList = new ArrayList<EStructuralFeature>();
            featuresList.addAll(features);
            this._features = Collections.unmodifiableList(featuresList);
        }

        public final Button getButton() {
            return this._button;
        }

        public final List<PropertyEditor> getEditors() {
            return this._editors;
        }

        public final List<EStructuralFeature> getFeatures() {
            return this._features;
        }
    }

    private static final class MutuallyExclusiveEObjectObservableValue
    extends EObjectObservableValue {
        private final List<EStructuralFeature> _featuresToUnset;

        public MutuallyExclusiveEObjectObservableValue(EObject eObject, EStructuralFeature featureToSet, List<EStructuralFeature> featuresToUnset) {
            super(eObject, featureToSet);
            this._featuresToUnset = featuresToUnset;
        }

        protected void doSetValue(Object value) {
            super.doSetValue(value);
            for (EStructuralFeature feature : this._featuresToUnset) {
                if (!this.eObject.eIsSet(feature)) continue;
                this.eObject.eUnset(feature);
            }
        }
    }
}

