/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.viewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.common.IControllerContext;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldGroupType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldType;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.provider.IFormsPropertyDescriptor;
import oracle.eclipse.tools.xml.edit.ui.viewer.AbstractFieldGroupComposite;
import oracle.eclipse.tools.xml.edit.ui.viewer.ActionHyperlink;
import oracle.eclipse.tools.xml.edit.ui.viewer.FieldComposite;
import oracle.eclipse.tools.xml.edit.ui.viewer.GroupFactory;
import oracle.eclipse.tools.xml.edit.ui.viewer.IUIInstrumentation;
import oracle.eclipse.tools.xml.edit.ui.viewer.LayoutObjectComposite;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class FieldGroupComposite
extends AbstractFieldGroupComposite {
    private Button _radioButton;
    private List<PropertyEditor> _editors = new ArrayList<PropertyEditor>();
    private List<EStructuralFeature> _features = new ArrayList<EStructuralFeature>();

    public FieldGroupComposite(GroupFactory groupFactory, FieldGroupType fieldGroup, IControllerContext context, EObject eObject, ILabelProvider labelProvider) {
        super(groupFactory, fieldGroup, context, eObject, labelProvider);
    }

    public Button getRadioButton() {
        return this._radioButton;
    }

    public List<PropertyEditor> getEditors() {
        return this._editors;
    }

    protected List<EStructuralFeature> getFeatures() {
        return this._features;
    }

    @Override
    protected Composite createContainer(Composite parent) {
        Composite content = parent instanceof ScrolledComposite ? (Composite)((ScrolledComposite)parent).getContent() : parent;
        Composite container = this.getContext().getWidgetAdapter().createComposite(content);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 1;
        container.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        container.setLayoutData((Object)data);
        return container;
    }

    @Override
    public List<LayoutObjectComposite.AttrControlPair> createControls(Composite parent) {
        if (this.getFieldGroup().getField().size() == 0) {
            return Collections.emptyList();
        }
        if (this.allFieldsNotSettable()) {
            return Collections.emptyList();
        }
        Composite buttonComposite = this.getContext().getWidgetAdapter().createComposite(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        boolean buttonCreated = false;
        EList<FieldType> subfields = this.getFieldGroup().getField();
        for (FieldType subfield : subfields) {
            ActionHyperlink label;
            IFormsPropertyDescriptor pd = subfield.getPropertyDescriptors();
            EAttribute feature = (EAttribute)pd.getFeature(this.getEObject());
            String name = this.getLabelProvider().getText((Object)pd);
            if (!buttonCreated) {
                this._radioButton = this.getContext().getWidgetAdapter().createButton(buttonComposite, null, 16);
                GridData data = new GridData();
                data.horizontalSpan = 1;
                data.verticalSpan = subfields.size();
                this._radioButton.setLayoutData((Object)data);
                buttonCreated = true;
            }
            if (this.getContext().enableHyperlinks()) {
                label = new ActionHyperlink(buttonComposite, 0);
                label.setText(name);
                label.setToolTipText(Messages.HyperlinkTooltipMsg);
                this.getContext().getWidgetAdapter().getHyperlinkGroup().add((Hyperlink)label);
                List<IHyperlink> links = this.getContext().getHyperlinks(this.getEObject(), feature);
                label.setEnabled(links.size() > 0);
                if (links.size() > 0) {
                    label.setActions(links);
                }
                GridData data = new GridData();
                data.horizontalSpan = 1;
                data.horizontalAlignment = 4;
                label.setLayoutData(data);
                continue;
            }
            label = this.getContext().getWidgetAdapter().createLabel(buttonComposite, name);
            GridData data = new GridData();
            data.horizontalSpan = 1;
            data.horizontalAlignment = 4;
            label.setLayoutData(data);
            IUIInstrumentation.InstrumentFlags.LABEL_IS_PROPERTY.set((Control)label);
        }
        return super.createControls(parent);
    }

    private boolean allFieldsNotSettable() {
        for (FieldType field : this.getFieldGroup().getField()) {
            IItemPropertyDescriptor ipd;
            IFormsPropertyDescriptor pd = field.getPropertyDescriptors();
            if (pd == null || !(ipd = pd.getItemPropertyDescriptor()).canSetProperty((Object)this.getEObject())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<LayoutObjectComposite.AttrControlPair> layoutChild(LayoutObjectComposite child) {
        List<LayoutObjectComposite.AttrControlPair> pairs = child.createControls(this._container);
        if (child instanceof FieldComposite) {
            this._editors.add(((FieldComposite)child).getEditor());
            this._features.add(((FieldComposite)child).getFeature());
            this.setFirstPropertyEditor(((FieldComposite)child).getEditor());
        }
        return pairs;
    }
}

