/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.viewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.common.IControllerContext;
import oracle.eclipse.tools.xml.edit.ui.common.UnsetEObjectObservableValue;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldType;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.provider.IFormsPropertyDescriptor;
import oracle.eclipse.tools.xml.edit.ui.viewer.EObjectFeatureValue;
import oracle.eclipse.tools.xml.edit.ui.viewer.FormatUpdateValueStrategy;
import oracle.eclipse.tools.xml.edit.ui.viewer.GroupFactory;
import oracle.eclipse.tools.xml.edit.ui.viewer.LayoutObjectComposite;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class FieldComposite
extends LayoutObjectComposite {
    private final FieldType _field;
    private PropertyEditor _editor;
    private EStructuralFeature _feature;
    private IObservableValue _modelObservable;
    private IObservableValue _boundModelObservable;
    private List<LayoutObjectComposite.AttrControlPair> pair = new ArrayList<LayoutObjectComposite.AttrControlPair>(1);

    public FieldComposite(GroupFactory groupFactory, FieldType fieldType, IControllerContext context, EObject eObject, ILabelProvider labelProvider) {
        super(groupFactory, context, eObject, labelProvider);
        this._field = fieldType;
    }

    protected FieldType getField() {
        return this._field;
    }

    protected PropertyEditor getEditor() {
        return this._editor;
    }

    public void setModelObservable(IObservableValue modelObservable) {
        this._modelObservable = modelObservable;
    }

    public void setBoundModelObservable(IObservableValue boundModelObservable) {
        this._boundModelObservable = boundModelObservable;
    }

    public IObservableValue getBoundModelObservable() {
        return this._boundModelObservable;
    }

    private IFormsPropertyDescriptor getPropertyDescriptor() {
        IFormsPropertyDescriptor pd = this._field.getPropertyDescriptors();
        if (pd == null) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)Messages.bind((String)Messages.NoFormsPropertyDescriptor, (Object)this._field.getName()));
        }
        return pd;
    }

    protected EStructuralFeature getFeature() {
        IFormsPropertyDescriptor pd;
        if (this._feature == null && (pd = this.getPropertyDescriptor()) != null) {
            this._feature = (EStructuralFeature)pd.getFeature(this.getEObject());
        }
        return this._feature;
    }

    private List<LayoutObjectComposite.AttrControlPair> getAttrControlPair() {
        return Collections.unmodifiableList(this.pair);
    }

    @Override
    public List<LayoutObjectComposite.AttrControlPair> createControls(Composite parent) {
        this.pair.clear();
        IFormsPropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            return this.getAttrControlPair();
        }
        IItemPropertyDescriptor ipd = pd.getItemPropertyDescriptor();
        if (!ipd.canSetProperty((Object)this.getEObject())) {
            return this.getAttrControlPair();
        }
        this._editor = pd.createFormsPropertyEditor(parent);
        this._editor.setModelObservable(this._modelObservable);
        this._editor.setDefaultValue(this.getFeature().getDefaultValueLiteral());
        UnsetEObjectObservableValue modelValue = this.getEditor().getModelObservable() != null ? this.getEditor().getModelObservable() : new UnsetEObjectObservableValue(this.getEObject(), this.getFeature());
        this.getContext().getDataBindingContext().bindValue(this._editor.getObservableValue(16), (IObservableValue)modelValue, (UpdateValueStrategy)new FormatUpdateValueStrategy(), null);
        this.setBoundModelObservable((IObservableValue)modelValue);
        Control control = this._editor.getControl();
        EObjectFeatureValue setting = new EObjectFeatureValue(this.getEObject(), (EStructuralFeature)ipd.getFeature((Object)this.getEObject()));
        FieldComposite.maybeApplyColor(this.getLabelProvider(), control, setting);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        control.setLayoutData((Object)data);
        this.pair.add(new LayoutObjectComposite.AttrControlPair(this.getField().getName(), this._editor.getBindingControl()));
        return this.getAttrControlPair();
    }

    private static void maybeApplyColor(ILabelProvider labelProvider, Control control, EStructuralFeature.Setting setting) {
        if (labelProvider instanceof IColorProvider) {
            Color bgColor;
            Color fgColor = ((IColorProvider)labelProvider).getForeground((Object)setting);
            if (fgColor != null && (control instanceof Text || control instanceof Combo)) {
                control.setForeground(fgColor);
            }
            if ((bgColor = ((IColorProvider)labelProvider).getBackground((Object)setting)) != null) {
                control.setBackground(bgColor);
            }
        }
    }
}

