/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.viewer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.common.IControllerContext;
import oracle.eclipse.tools.xml.edit.ui.common.IRefreshListener;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldGroupType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.impl.SingleFieldGroupTypeImpl;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.viewer.GroupFactory;
import oracle.eclipse.tools.xml.edit.ui.viewer.LayoutManager;
import oracle.eclipse.tools.xml.edit.ui.viewer.LayoutObjectComposite;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EObjectFieldGroupViewer
extends ContentViewer
implements IRefreshListener {
    private Map<String, List<LayoutObjectComposite.AttrControlPair>> _groups = new HashMap<String, List<LayoutObjectComposite.AttrControlPair>>();
    private final IControllerContext _context;
    private final FieldGroupType _fieldGroup;
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
    private final Composite _topParent;
    private ScrolledComposite _curComposite;
    private EObject _eObject;
    private AtomicBoolean _isUpdating = new AtomicBoolean(false);
    private Throwable _currentUpdateEntryVector = null;

    public static ScrolledComposite createRootComposite(WidgetAdapter widgetAdapter, Composite parent) {
        ScrolledComposite scrollableComposite = new ScrolledComposite(parent, 768);
        scrollableComposite.setExpandHorizontal(true);
        scrollableComposite.setExpandVertical(true);
        scrollableComposite.setShowFocusedControl(true);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        scrollableComposite.setLayoutData((Object)data);
        Composite contents = widgetAdapter.createComposite((Composite)scrollableComposite, 0);
        scrollableComposite.setContent((Control)contents);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginTop = 0;
        contents.setLayout((Layout)layout);
        return scrollableComposite;
    }

    public EObjectFieldGroupViewer(IControllerContext context, Composite parent, FieldGroupType fieldGroup) {
        this._context = context;
        this._fieldGroup = fieldGroup;
        if (parent.getLayout() instanceof GridLayout) {
            this._topParent = parent;
        } else {
            this._topParent = this._context.getWidgetAdapter().createComposite(parent);
            this._topParent.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        }
        this._context.addRefreshListener(this);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isTrue((boolean)(contentProvider instanceof IStructuredContentProvider));
        super.setContentProvider(contentProvider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ILabelProvider));
        super.setLabelProvider(labelProvider);
    }

    public Control getControl() {
        return this._topParent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void refresh() {
        if (this._isDisposed.get()) return;
        if (this._isUpdating.compareAndSet(false, true)) {
            try {
                this._currentUpdateEntryVector = new Throwable("stack trace");
                if (this.getLabelProvider() == null || this.getContentProvider() == null || this._eObject == null) return;
                this.update();
                return;
            }
            finally {
                this._isUpdating.set(false);
            }
        } else {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)new Throwable("Attempt at simultaneous property sheet update"));
            if (this._currentUpdateEntryVector == null) return;
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)this._currentUpdateEntryVector);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void inputChanged(Object input, Object oldInput) {
        if (this._isDisposed.get()) return;
        if (this._isUpdating.compareAndSet(false, true)) {
            try {
                this._currentUpdateEntryVector = new Throwable("stack trace");
                EObject oldVal = this._eObject;
                this._eObject = (EObject)input;
                if (oldVal == this._eObject) return;
                this.update();
                return;
            }
            finally {
                this._isUpdating.set(false);
            }
        } else {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)new Throwable("Attempt at simultaneous property sheet update"));
            if (this._currentUpdateEntryVector == null) return;
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)this._currentUpdateEntryVector);
        }
    }

    private void update() {
        if (this._curComposite != null) {
            this._curComposite.dispose();
        }
        this._curComposite = EObjectFieldGroupViewer.createRootComposite(this._context.getWidgetAdapter(), this._topParent);
        if (this._eObject != null) {
            this._context.hookUpValidation(this._context.getDataBindingContext());
            LayoutManager layoutManager = new LayoutManager(GroupFactory.INSTANCE);
            this._groups.putAll(layoutManager.layout(this._eObject, this._context, Arrays.asList(new SingleFieldGroupTypeImpl(this._fieldGroup)), (ILabelProvider)this.getLabelProvider(), (Composite)this._curComposite));
            this._curComposite.setMinSize(this._curComposite.getContent().computeSize(-1, -1));
        }
        this._topParent.layout(true);
    }

    public Map<String, List<LayoutObjectComposite.AttrControlPair>> getGroupMapping() {
        return this._groups;
    }

    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true) && this._context != null) {
            this._context.removeRefreshListener(this);
        }
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }
}

