/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.tagedit;

import java.io.IOException;
import java.net.URL;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.TagEditType;
import oracle.eclipse.tools.xml.edit.ui.tagedit.TagEditMetaDataLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.DelegatingResourceLocator;
import org.eclipse.emf.common.util.ResourceLocator;
import org.osgi.framework.Bundle;

class TagEditResourceLocator
extends DelegatingResourceLocator {
    private final PrimaryResourceLocator _primaryLocator;
    private static final ResourceLocator[] NO_DELEGATING_RESOURCE_LOCATORS = new ResourceLocator[0];

    public TagEditResourceLocator(TagEditMetaDataLocator.MDLocator locator) {
        this._primaryLocator = new PrimaryResourceLocator(locator);
    }

    public URL getBaseURL() {
        return this._primaryLocator.getBaseURL();
    }

    protected ResourceLocator[] getDelegateResourceLocators() {
        return NO_DELEGATING_RESOURCE_LOCATORS;
    }

    protected ResourceLocator getPrimaryResourceLocator() {
        return this._primaryLocator;
    }

    private static class PrimaryResourceLocator
    implements ResourceLocator {
        private final TagEditMetaDataLocator.MDLocator _locator;
        private ResourceBundle _resBundle;

        PrimaryResourceLocator(TagEditMetaDataLocator.MDLocator locator) {
            this._locator = locator;
        }

        public URL getBaseURL() {
            return this.getSourceBundle().getEntry("/");
        }

        private Bundle getSourceBundle() {
            String bundleName = this._locator.getSourceModel()._bundleName;
            return Platform.getBundle((String)bundleName);
        }

        public String getString(String key) {
            if (this.getResourceBundle() != null) {
                return this.getResourceBundle().getString(key);
            }
            return null;
        }

        public String getString(String key, boolean translate) {
            return this.getString(key);
        }

        public String getString(String key, Object[] substitutions) {
            return this.getString(key);
        }

        public String getString(String key, Object[] substitutions, boolean translate) {
            return this.getString(key);
        }

        public Object getImage(String key) {
            return null;
        }

        private ResourceBundle getResourceBundle() {
            URL resource;
            String defaultBundle;
            if (this._resBundle != null) {
                return this._resBundle;
            }
            TagEditType tagEdit = this._locator.getSourceModel().getTagEdit();
            if (tagEdit != null && (defaultBundle = tagEdit.getDefaultBundle()) != null && (resource = this.getSourceBundle().getResource(defaultBundle)) != null) {
                try {
                    this._resBundle = new PropertyResourceBundle(resource.openStream());
                }
                catch (IOException e) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)("Loading bundle " + defaultBundle));
                }
            }
            return this._resBundle;
        }
    }
}

