/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.tagedit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.metadata.internal.AbstractMetaDataLocator2;
import oracle.eclipse.tools.application.common.services.metadata.internal.AbstractMetaDataSourceModelProvider2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataSourceModelProvider2;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.TagEditType;
import oracle.eclipse.tools.xml.edit.ui.tagedit.TagEditLoader;
import oracle.eclipse.tools.xml.edit.ui.tagedit.TagEditResourceLocator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;

public class TagEditMetaDataLocator
extends AbstractMetaDataLocator2 {
    public void setProjectContext(IProject project) {
    }

    private IVersion getVersion(String versionString) {
        IVersion version = null;
        try {
            Activator activator = Activator.getDefault();
            if (activator != null) {
                version = activator.getVersionFactory().getVersion(versionString);
            }
        }
        catch (IllegalArgumentException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.xml.edit.ui", (Throwable)e);
        }
        return version;
    }

    public List<IMetaDataSourceModelProvider2> locateMetaDataModelProviders(String uri) {
        Map<String, List<TagEditDescriptor>> allHandlers = TagEditDescriptorReader.getAllHandlers();
        List<TagEditDescriptor> tagLib = allHandlers.get(uri);
        if (tagLib != null) {
            Collections.sort(tagLib, new TagEditDescriptorComparator());
            ArrayList<MDLocator> providers = new ArrayList<MDLocator>();
            for (TagEditDescriptor ted : tagLib) {
                MDLocator provider = new MDLocator(ted, uri);
                providers.add(provider);
            }
            return Collections.unmodifiableList(providers);
        }
        return Collections.emptyList();
    }

    public void startLocating() {
        TagEditDescriptorReader.getAllHandlers();
    }

    public void stopLocating() {
    }

    static class MDLocator
    extends AbstractMetaDataSourceModelProvider2 {
        private final TagEditDescriptor _ted;
        private final String _uri;

        private MDLocator(TagEditDescriptor ted, String uri) {
            this._ted = ted;
            this._uri = uri;
            TagEditResourceLocator resLocator = new TagEditResourceLocator(this);
            TagEditType tagEdit = this._ted.getTagEdit();
            if (tagEdit != null) {
                tagEdit.setResourceLocator((ResourceLocator)resLocator);
            }
        }

        public TagEditDescriptor getSourceModel() {
            return this._ted;
        }

        public Object getAdapter(Class adapter) {
            if (ResourceLocator.class.equals((Object)adapter)) {
                return new TagEditResourceLocator(this);
            }
            return null;
        }

        public String getModelIdentifier() {
            return this._uri;
        }
    }

    static class TagEditDescriptor {
        private final String _tagName;
        private final String _version;
        final String _bundleName;
        private final Object _resource;
        private TagEditType _tagEdit;

        public TagEditDescriptor(String tagName, String version, String bundleName, String resource) {
            this._tagName = tagName;
            this._version = version;
            this._bundleName = bundleName;
            this._resource = resource;
        }

        public String getTagName() {
            return this._tagName;
        }

        public String getVersion() {
            return this._version;
        }

        public TagEditType getTagEdit() {
            if (this._tagEdit != null) {
                return this._tagEdit;
            }
            URI uri = this.getFile();
            TagEditLoader loader = null;
            try {
                loader = new TagEditLoader(uri);
                this._tagEdit = loader.getTagEdit();
            }
            catch (IOException ioe) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)ioe, (String)("Problem loading " + uri));
            }
            return this._tagEdit;
        }

        private URI getFile() {
            return URI.createPlatformPluginURI((String)(String.valueOf(this._bundleName) + "/" + this._resource), (boolean)false);
        }
    }

    private class TagEditDescriptorComparator
    implements Comparator<TagEditDescriptor> {
        private TagEditDescriptorComparator() {
        }

        @Override
        public int compare(TagEditDescriptor ted0, TagEditDescriptor ted1) {
            int tagNameCompare = ted0.getTagName().compareTo(ted1.getTagName());
            if (tagNameCompare != 0) {
                return tagNameCompare;
            }
            IVersion version0 = TagEditMetaDataLocator.this.getVersion(ted0.getVersion());
            IVersion version1 = TagEditMetaDataLocator.this.getVersion(ted1.getVersion());
            if (version0 == null) {
                if (version1 == null) {
                    return 0;
                }
                return -1;
            }
            if (version1 == null) {
                return 1;
            }
            return version0.compareTo((Object)version1);
        }
    }

    static class TagEditDescriptorReader {
        private static Map<String, List<TagEditDescriptor>> _handlers = null;

        TagEditDescriptorReader() {
        }

        public static synchronized Map<String, List<TagEditDescriptor>> getAllHandlers() {
            if (_handlers == null) {
                _handlers = TagEditDescriptorReader.readAllHandlers();
            }
            return Collections.unmodifiableMap(_handlers);
        }

        private static Map<String, List<TagEditDescriptor>> readAllHandlers() {
            HashMap<String, List<TagEditDescriptor>> result = new HashMap<String, List<TagEditDescriptor>>();
            Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.xml.edit.ui", (String)"tagEditContributor");
            for (IExtension ext : extensions) {
                IConfigurationElement[] tagElementConfiguration;
                IConfigurationElement[] iConfigurationElementArray = tagElementConfiguration = ext.getConfigurationElements();
                int n = tagElementConfiguration.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    String uri = element.getAttribute("uri");
                    IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement childElement = iConfigurationElementArray2[n4];
                        String tagName = childElement.getAttribute("tagName");
                        String version = childElement.getAttribute("version");
                        String relativeFileName = childElement.getAttribute("relativeFileName");
                        TagEditDescriptor ted = new TagEditDescriptor(tagName, version, ext.getContributor().getName(), relativeFileName);
                        ArrayList<TagEditDescriptor> descriptors = (ArrayList<TagEditDescriptor>)result.get(uri);
                        if (descriptors == null) {
                            descriptors = new ArrayList<TagEditDescriptor>();
                            result.put(uri, descriptors);
                        }
                        descriptors.add(ted);
                        ++n4;
                    }
                    ++n2;
                }
            }
            return result;
        }
    }
}

