/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal;

import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldGroupType;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal.EObjectSection;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal.TagAttrSearchDialog;
import oracle.eclipse.tools.xml.edit.ui.viewer.LayoutObjectComposite;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TagAttrSearchCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPage currentPage;
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (activePart instanceof PropertySheet && (currentPage = ((PropertySheet)activePart).getCurrentPage()) instanceof TabbedPropertySheetPage) {
            TabbedPropertySheetPage tabbedPropertySheetPage = (TabbedPropertySheetPage)currentPage;
            TagAttrSearchDialog dialog = new TagAttrSearchDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), tabbedPropertySheetPage);
            int returnCode = dialog.open();
            if (returnCode == 0) {
                TagAttrSearchDialog.Info info = (TagAttrSearchDialog.Info)dialog.getFirstResult();
                ITabDescriptor tabToSelect = info.getTabDescriptor();
                tabbedPropertySheetPage.setSelectedTab(tabToSelect.getId());
                List descriptors = tabToSelect.getSectionDescriptors();
                block0: for (ISectionDescriptor descriptor : descriptors) {
                    ISection section = descriptor.getSectionClass();
                    if (!(section instanceof EObjectSection)) continue;
                    EObjectSection eObjectSection = (EObjectSection)section;
                    FieldGroupType fieldGroup = eObjectSection.getFieldGroup();
                    Map<String, List<LayoutObjectComposite.AttrControlPair>> groups = eObjectSection.getFieldGroupViewer().getGroupMapping();
                    List<LayoutObjectComposite.AttrControlPair> pairs = groups.get(fieldGroup.getName());
                    String attr = info.getId();
                    for (LayoutObjectComposite.AttrControlPair pair : pairs) {
                        if (!attr.equals(pair.getAttrName())) continue;
                        Control control = pair.getControl();
                        control.setFocus();
                        continue block0;
                    }
                }
            }
        }
        return null;
    }
}

