/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal;

import java.io.IOException;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal.OEPETabDescriptorProvider;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal.OEPETabbedPropertySheetPage;
import oracle.eclipse.tools.xml.model.emfbinding.EStoreFactory;
import oracle.eclipse.tools.xml.model.service.EStoreSemanticModelAdapterFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.pagedesigner.editors.AbstractPropertySheetPageFactory;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class OEPEPropertySheetPageFactory
extends AbstractPropertySheetPageFactory {
    public IPropertySheetPage createPage(IFile file) {
        this.ensureEStoreSemanticObjectFactory(file);
        return new OEPETabbedPropertySheetPage(new OEPETabDescriptorProvider());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureEStoreSemanticObjectFactory(IFile file) {
        IDocument document = (IDocument)file.getAdapter(IDocument.class);
        IStructuredModel model = null;
        try {
            try {
                EStoreFactory eStoreFactory;
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                if (!(model instanceof IDOMModel) || document == null || (eStoreFactory = (EStoreFactory)document.getAdapter(EStoreFactory.class)) == null) return;
                new EStoreSemanticModelAdapterFactory((IDOMModel)model, eStoreFactory).ensureFactoryIsInstalled(model);
                return;
            }
            catch (IOException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }
}

