/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.provider;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.documentservices.AttributeTypeAdapter;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.BindInfoType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.DialogOverrideOption;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.MethodBodyTemplateType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.StaticBindInfoType;
import oracle.eclipse.tools.xml.edit.ui.propeditor.BooleanDialogPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.CheckboxPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.ComboDialogPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.ComboPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.EditableComboPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.FeatureValidator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.MultiLineDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.MultipleChoiceDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.SpecialValueCheckboxPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.TextDialogPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.TextPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.provider.AbstractBindDialogCreationStrategyFactory;
import oracle.eclipse.tools.xml.edit.ui.provider.BindDcsfFactory;
import oracle.eclipse.tools.xml.edit.ui.provider.DialogCreationStrategyReader;
import oracle.eclipse.tools.xml.edit.ui.provider.FormsGroupSource;
import oracle.eclipse.tools.xml.edit.ui.provider.IDialogCreationStrategyFactory;
import oracle.eclipse.tools.xml.edit.ui.provider.IFormsPropertyDescriptor;
import oracle.eclipse.tools.xml.edit.ui.provider.IItemGroupSource;
import oracle.eclipse.tools.xml.edit.ui.provider.MethodBindEditDialogCreationStrategyFactory;
import oracle.eclipse.tools.xml.edit.ui.provider.TagEditContext;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.metadata.TleiAccess;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class PropertyDescriptor
implements IFormsPropertyDescriptor,
IPropertyDescriptor {
    protected Object _object;
    protected IItemPropertyDescriptor _itemPropertyDescriptor;
    protected org.eclipse.emf.edit.ui.provider.PropertyDescriptor _emfPropertyDescriptor;
    protected WidgetAdapter _widgetAdapter;
    private AdapterFactory _adapterFactory;
    private final TagEditContext _tagEditContext;
    private boolean _methodBodyTemplateInitialized = false;
    private MethodBodyTemplateType _methodBodyTemplate;
    private AttributeTypeAdapter _attrTypeAdapter;

    public PropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor, WidgetAdapter widgetAdapter, AdapterFactory adapterFactory, TagEditContext context) {
        this._object = object;
        this._itemPropertyDescriptor = itemPropertyDescriptor;
        this._emfPropertyDescriptor = new org.eclipse.emf.edit.ui.provider.PropertyDescriptor(object, itemPropertyDescriptor);
        this._widgetAdapter = widgetAdapter;
        this._adapterFactory = adapterFactory;
        this._tagEditContext = context;
    }

    @Override
    public PropertyEditor createFormsPropertyEditor(Composite composite) {
        if (!this._itemPropertyDescriptor.canSetProperty(this._object)) {
            return null;
        }
        PropertyEditor result = null;
        Object genericFeature = this._itemPropertyDescriptor.getFeature(this._object);
        if (genericFeature instanceof EReference[]) {
            String[] items = ExtendedComboBoxCellEditor.createItems(new ArrayList(this._itemPropertyDescriptor.getChoiceOfValues(this._object)), (ILabelProvider)this.getEditLabelProvider(), (boolean)this._itemPropertyDescriptor.isSortChoices(this._object));
            result = new ComboPropertyEditor(composite, Arrays.asList(items), this._widgetAdapter);
        } else if (genericFeature instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)genericFeature;
            EClassifier eType = feature.getEType();
            Collection choiceOfValues = this._itemPropertyDescriptor.getChoiceOfValues(this._object);
            if (choiceOfValues != null) {
                if (this._itemPropertyDescriptor.isMany(this._object)) {
                    boolean valid = true;
                    for (Object choice : choiceOfValues) {
                        if (eType.isInstance(choice)) continue;
                        valid = false;
                        break;
                    }
                    if (valid && eType instanceof EDataType) {
                        FeatureValidator validator = new FeatureValidator((EDataType)eType);
                        IObservableList modelList = EMFObservables.observeList((EObject)((EObject)this._object), (EStructuralFeature)feature);
                        MultipleChoiceDialogCreationStrategy dcs = new MultipleChoiceDialogCreationStrategy(new ArrayList(choiceOfValues), this.getEditLabelProvider(), modelList, validator);
                        ArrayList<DialogCreationStrategy> strategies = new ArrayList<DialogCreationStrategy>(1);
                        strategies.add(dcs);
                        result = new TextDialogPropertyEditor(composite, strategies, this._widgetAdapter, true);
                    }
                }
                if (result == null) {
                    List<DialogCreationStrategy> strategies;
                    ArrayList possibleValues = new ArrayList(this._itemPropertyDescriptor.getChoiceOfValues(this._object));
                    String[] items = ExtendedComboBoxCellEditor.createItems(possibleValues, (ILabelProvider)this.getEditLabelProvider(), (boolean)this._itemPropertyDescriptor.isSortChoices(this._object));
                    result = possibleValues.size() == 1 ? new SpecialValueCheckboxPropertyEditor(composite, this._widgetAdapter, possibleValues.get(0), null, eType.getInstanceClass()) : (feature.getEType() instanceof EEnum ? new ComboPropertyEditor(composite, Arrays.asList(items), this._widgetAdapter) : ((strategies = this.getDialogStrategies((EObject)this._object, feature)).isEmpty() ? new EditableComboPropertyEditor(composite, Arrays.asList(items), this._widgetAdapter) : new ComboDialogPropertyEditor(composite, strategies, this._widgetAdapter, Arrays.asList(items))));
                }
            } else if (eType instanceof EDataType) {
                EDataType eDataType = (EDataType)eType;
                FeatureValidator validator = new FeatureValidator(eDataType);
                if (eDataType.isSerializable()) {
                    if (this._itemPropertyDescriptor.isMany(this._object)) {
                        IObservableValue modelValue = EMFObservables.observeValue((EObject)((EObject)this._object), (EStructuralFeature)feature);
                        MultiLineDialogCreationStrategy dcs = new MultiLineDialogCreationStrategy(modelValue, validator);
                        ArrayList<DialogCreationStrategy> strategies = new ArrayList<DialogCreationStrategy>(1);
                        strategies.add(dcs);
                        result = new TextDialogPropertyEditor(composite, strategies, this._widgetAdapter, true);
                    } else {
                        List<DialogCreationStrategy> strategies;
                        List<String> unionItems;
                        List<DialogCreationStrategy> strategies2;
                        result = eDataType.getInstanceClass() == Boolean.class || eDataType.getInstanceClass() == Boolean.TYPE ? new CheckboxPropertyEditor(composite, this._widgetAdapter) : (this.isUnionBoolean(eDataType) ? ((strategies2 = this.getDialogStrategies((EObject)this._object, feature)).isEmpty() ? new CheckboxPropertyEditor(composite, this._widgetAdapter) : new BooleanDialogPropertyEditor(composite, strategies2, this._widgetAdapter)) : ((unionItems = this.getUnionEnums(eDataType)).size() > 0 ? ((strategies = this.getDialogStrategies((EObject)this._object, feature)).isEmpty() ? new EditableComboPropertyEditor(composite, unionItems, this._widgetAdapter) : new ComboDialogPropertyEditor(composite, strategies, this._widgetAdapter, unionItems)) : this.createEDataTypePropertyEditor((EObject)this._object, feature, validator, composite, this._widgetAdapter)));
                    }
                }
            }
        }
        return result;
    }

    private List<String> getUnionEnums(EDataType eDataType) {
        ArrayList<Enumerator> enumerators = new ArrayList<Enumerator>();
        for (EDataType memberDataType : ExtendedMetaData.INSTANCE.getMemberTypes(eDataType)) {
            if (!(memberDataType instanceof EEnum)) continue;
            for (EEnumLiteral literal : ((EEnum)memberDataType).getELiterals()) {
                enumerators.add(literal.getInstance());
            }
            String[] items = ExtendedComboBoxCellEditor.createItems(enumerators, (ILabelProvider)this.getEditLabelProvider(), (boolean)this._itemPropertyDescriptor.isSortChoices(this._object));
            return Arrays.asList(items);
        }
        return Collections.emptyList();
    }

    private boolean isUnionBoolean(EDataType eDataType) {
        for (EDataType memberDataType : ExtendedMetaData.INSTANCE.getMemberTypes(eDataType)) {
            if (memberDataType.getInstanceClass() != Boolean.TYPE && memberDataType.getInstanceClass() != Boolean.class) continue;
            return true;
        }
        return false;
    }

    protected PropertyEditor createEDataTypePropertyEditor(EObject object, EStructuralFeature feature, IValidator validator, Composite composite, WidgetAdapter widgetAdapter) {
        if (this._itemPropertyDescriptor.isMultiLine((Object)object)) {
            IObservableValue modelValue = EMFObservables.observeValue((EObject)object, (EStructuralFeature)feature);
            MultiLineDialogCreationStrategy dcs = new MultiLineDialogCreationStrategy(modelValue, validator);
            ArrayList<DialogCreationStrategy> strategies = new ArrayList<DialogCreationStrategy>(1);
            strategies.add(dcs);
            return new TextDialogPropertyEditor(composite, strategies, widgetAdapter, true);
        }
        List<DialogCreationStrategy> strategies = this.getDialogStrategies(object, feature);
        if (!strategies.isEmpty()) {
            return new TextDialogPropertyEditor(composite, strategies, widgetAdapter, false);
        }
        return new TextPropertyEditor(composite, widgetAdapter);
    }

    private List<DialogCreationStrategy> getDialogStrategies(EObject object, EStructuralFeature feature) {
        ArrayList<DialogCreationStrategy> strategies = new ArrayList<DialogCreationStrategy>(1);
        FieldType field = this.getField(object, feature);
        DialogOverrideOption staticOption = this.getDialogOverrideOptionFromStaticBindInfo(field);
        if (staticOption == null || staticOption == DialogOverrideOption.DEFAULT) {
            Class clazz;
            String dcsFactory = TleiAccess.INSTANCE.getDCSFactory(this.getBaseDocument(), feature);
            if (dcsFactory != null && (clazz = PluginUtil.loadClass((String)"oracle.eclipse.tools.xml.edit.ui", (String)dcsFactory)) != null) {
                try {
                    Constructor ctor = clazz.getConstructor(new Class[0]);
                    IDialogCreationStrategyFactory factory = (IDialogCreationStrategyFactory)ctor.newInstance(new Object[0]);
                    DialogCreationStrategy strategy = factory.create(this, object, feature, this._adapterFactory);
                    if (strategy != null) {
                        strategies.add(strategy);
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.xml.edit.ui", (Throwable)e);
                }
            }
        } else if (staticOption != DialogOverrideOption.SUPPRESS && staticOption == DialogOverrideOption.OVERRIDE) {
            String customDialogId = field.getStaticBindInfo().getCustomDialogId();
            IDialogCreationStrategyFactory factory = DialogCreationStrategyReader.getFactory(customDialogId);
            if (factory == null) {
                LoggingService.logWarning((String)"oracle.eclipse.tools.xml.edit.ui", (String)Messages.bind((String)Messages.UnableToOverrideBindDialog, (Object)customDialogId));
            } else {
                DialogCreationStrategy dcs = factory.create(this, object, feature, this._adapterFactory);
                strategies.add(dcs);
            }
        }
        AttributeTypeAdapter attrTypeAdapter = this.getAttributeTypeAdapter();
        boolean isElValueBinding = false;
        boolean isMethodValueBinding = false;
        boolean isJSPExpressionBinding = false;
        if (attrTypeAdapter != null) {
            isElValueBinding = attrTypeAdapter.getSupportedExpressions(AttributeTypeAdapter.ExpressionType.EL_VALUE_BINDING) != null;
            isMethodValueBinding = attrTypeAdapter.getSupportedExpressions(AttributeTypeAdapter.ExpressionType.EL_METHOD_BINDING) != null;
            boolean bl = isJSPExpressionBinding = attrTypeAdapter.getSupportedExpressions(AttributeTypeAdapter.ExpressionType.JSP_EXPRESSION) != null;
        }
        if (isElValueBinding || isMethodValueBinding || isJSPExpressionBinding) {
            DialogOverrideOption option = this.getDialogOverrideOptionFromBindInfo(field);
            if (option == null || option == DialogOverrideOption.DEFAULT) {
                if (isElValueBinding || isJSPExpressionBinding) {
                    AbstractBindDialogCreationStrategyFactory factory = BindDcsfFactory.INSTANCE.getBindDcsf(TleiAccess.INSTANCE.getSubtype(this.getBaseDocument(), feature));
                    DialogCreationStrategy dcs = factory.create(this, object, feature, this._adapterFactory);
                    strategies.add(dcs);
                } else {
                    MethodBindEditDialogCreationStrategyFactory factory = new MethodBindEditDialogCreationStrategyFactory();
                    DialogCreationStrategy dcs = factory.create(this, object, feature, this._adapterFactory);
                    strategies.add(dcs);
                }
            } else if ((option == null || option != DialogOverrideOption.SUPPRESS) && option != null && option == DialogOverrideOption.OVERRIDE) {
                String customDialogId = field.getBindInfo().getCustomDialogId();
                IDialogCreationStrategyFactory factory = DialogCreationStrategyReader.getFactory(customDialogId);
                if (factory == null) {
                    LoggingService.logWarning((String)"oracle.eclipse.tools.xml.edit.ui", (String)Messages.bind((String)Messages.UnableToOverrideBindDialog, (Object)customDialogId));
                } else {
                    DialogCreationStrategy dcs = factory.create(this, object, feature, this._adapterFactory);
                    strategies.add(dcs);
                }
            }
        }
        return strategies;
    }

    private DialogOverrideOption getDialogOverrideOptionFromBindInfo(FieldType field) {
        if (field == null) {
            return null;
        }
        BindInfoType bindInfo = field.getBindInfo();
        if (bindInfo == null) {
            return null;
        }
        return bindInfo.getDialogOverrideOption();
    }

    private DialogOverrideOption getDialogOverrideOptionFromStaticBindInfo(FieldType field) {
        if (field == null) {
            return null;
        }
        StaticBindInfoType staticBindInfo = field.getStaticBindInfo();
        if (staticBindInfo == null) {
            return null;
        }
        return staticBindInfo.getDialogOverrideOption();
    }

    @Override
    public MethodBodyTemplateType getMethodBodyTemplate() {
        if (!this._methodBodyTemplateInitialized) {
            this._methodBodyTemplateInitialized = true;
            EObject eObject = (EObject)this._object;
            Object rawFeature = this.getFeature(this._object);
            if (!(rawFeature instanceof EStructuralFeature)) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.xml.edit.ui", (String)Messages.NotAnEStructuralFeature);
                return null;
            }
            EStructuralFeature feature = (EStructuralFeature)rawFeature;
            FieldType field = this.getField(eObject, feature);
            this._methodBodyTemplate = field == null ? null : field.getMethodBodyTemplate();
        }
        return this._methodBodyTemplate;
    }

    @Override
    public WidgetAdapter getWidgetAdapter() {
        return this._widgetAdapter;
    }

    @Override
    public AttributeTypeAdapter getAttributeTypeAdapter() {
        if (this._attrTypeAdapter == null) {
            EObject eObject = (EObject)this._object;
            Object rawFeature = this.getFeature(this._object);
            if (!(rawFeature instanceof EAttribute)) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.xml.edit.ui", (String)Messages.NotAnEAttribute);
                return null;
            }
            EAttribute feature = (EAttribute)rawFeature;
            IFile baseFile = this.internalGetBaseFile(eObject);
            if (baseFile == null) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.xml.edit.ui", (String)Messages.BaseFileIsNull);
                return null;
            }
            IDocument document = this.internalGetBaseDocument(baseFile);
            if (document == null) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.xml.edit.ui", (String)Messages.DocumentIsNull);
                return null;
            }
            IXMLMetadataContext adapter = (IXMLMetadataContext)document.getAdapter(IXMLMetadataContext.class);
            if (adapter == null) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.xml.edit.ui", (String)Messages.AdapterIsNull);
                return null;
            }
            EClass eClass = eObject.eClass();
            String uri = ExtendedEcoreUtil.INSTANCE.getNamespaceUri(eClass);
            String elementName = ExtendedEcoreUtil.INSTANCE.getNodeName(eClass);
            String attrName = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)feature);
            this._attrTypeAdapter = new AttributeTypeAdapter(adapter, document, uri, elementName, attrName);
        }
        return this._attrTypeAdapter;
    }

    protected FieldType getField(EObject eObject, EStructuralFeature feature) {
        IItemPropertySource itemPropertySource = (IItemPropertySource)this._adapterFactory.adapt((Notifier)eObject, IItemPropertySource.class);
        if (itemPropertySource instanceof IItemGroupSource) {
            FormsGroupSource propertySource = new FormsGroupSource(eObject, (IItemGroupSource)itemPropertySource, this._widgetAdapter);
            return propertySource.getField(this._tagEditContext, feature);
        }
        return null;
    }

    @Override
    public IFile getBaseFile() {
        if (!(this._object instanceof EObject)) {
            LoggingService.logDebug((String)"oracle.eclipse.tools.xml.edit.ui", (String)Messages.BaseFileNotAnEObject);
            return null;
        }
        return this.internalGetBaseFile((EObject)this._object);
    }

    protected IFile internalGetBaseFile(EObject eObject) {
        IAdaptable existingAdapter;
        Resource res = eObject.eResource();
        if (res != null && (existingAdapter = (IAdaptable)EcoreUtil.getExistingAdapter((Notifier)res, IAdaptable.class)) != null) {
            return (IFile)existingAdapter.getAdapter(IFile.class);
        }
        return null;
    }

    @Override
    public IDocument getBaseDocument() {
        if (!(this._object instanceof EObject)) {
            LoggingService.logError((String)"oracle.eclipse.tools.xml.edit.ui", (String)Messages.BaseDocNotAnEObject);
            return null;
        }
        IFile baseFile = this.internalGetBaseFile((EObject)this._object);
        if (baseFile == null) {
            LoggingService.logError((String)"oracle.eclipse.tools.xml.edit.ui", (String)Messages.BaseDocBaseFileIsNull);
            return null;
        }
        return this.internalGetBaseDocument(baseFile);
    }

    protected IDocument internalGetBaseDocument(IFile baseFile) {
        return (IDocument)baseFile.getAdapter(IDocument.class);
    }

    public String getCategory() {
        return this._emfPropertyDescriptor.getCategory();
    }

    public String getDisplayName() {
        return this._emfPropertyDescriptor.getDisplayName();
    }

    public String getDescription() {
        return this._emfPropertyDescriptor.getDescription();
    }

    public String[] getFilterFlags() {
        return this._emfPropertyDescriptor.getFilterFlags();
    }

    public Object getHelpContextIds() {
        return this._emfPropertyDescriptor.getHelpContextIds();
    }

    public Object getId() {
        return this._emfPropertyDescriptor.getId();
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return this._emfPropertyDescriptor.isCompatibleWith(anotherProperty);
    }

    public ILabelProvider getLabelProvider() {
        return this._emfPropertyDescriptor.getLabelProvider();
    }

    protected ILabelProvider getEditLabelProvider() {
        return this.getLabelProvider();
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return this._emfPropertyDescriptor.createPropertyEditor(parent);
    }

    @Override
    public Object getFeature(Object object) {
        return this._itemPropertyDescriptor.getFeature(object);
    }

    @Override
    public IItemPropertyDescriptor getItemPropertyDescriptor() {
        return this._itemPropertyDescriptor;
    }

    public void dispose() {
        if (this._adapterFactory != null) {
            this._adapterFactory = null;
        }
    }
}

