/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.documentservices.AttributeTypeAdapter;
import oracle.eclipse.tools.application.common.services.resource.BindUtil;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.xml.edit.ui.propeditor.BindEditDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.provider.AbstractBindDialogCreationStrategyFactory;
import oracle.eclipse.tools.xml.edit.ui.provider.IFormsPropertyDescriptor;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.common.util.TypeUtil;

public class BindEditDialogCreationStrategyFactory
extends AbstractBindDialogCreationStrategyFactory {
    private static final List<String> ACCEPTED_TYPES = new ArrayList<String>();

    static {
        ACCEPTED_TYPES.add("java.lang.String");
        ACCEPTED_TYPES.add("boolean");
        ACCEPTED_TYPES.add("java.lang.Boolean");
        ACCEPTED_TYPES.add("byte");
        ACCEPTED_TYPES.add("java.lang.Byte");
        ACCEPTED_TYPES.add("char");
        ACCEPTED_TYPES.add("java.lang.Character");
        ACCEPTED_TYPES.add("double");
        ACCEPTED_TYPES.add("java.lang.Double");
        ACCEPTED_TYPES.add("float");
        ACCEPTED_TYPES.add("java.lang.Float");
        ACCEPTED_TYPES.add("int");
        ACCEPTED_TYPES.add("java.lang.Integer");
        ACCEPTED_TYPES.add("long");
        ACCEPTED_TYPES.add("java.lang.Long");
        ACCEPTED_TYPES.add("short");
        ACCEPTED_TYPES.add("java.lang.Short");
        ACCEPTED_TYPES.add("java.lang.Number");
        ACCEPTED_TYPES.add("java.math.BigDecimal");
        ACCEPTED_TYPES.add("java.math.BigInteger");
    }

    @Override
    public DialogCreationStrategy create(IFormsPropertyDescriptor descriptor, EObject object, EStructuralFeature propertyFeature, AdapterFactory adapterFactory) {
        IObservableValue modelValue = EMFObservables.observeValue((EObject)object, (EStructuralFeature)propertyFeature);
        IValidator validator = this.getFeatureValidator(propertyFeature);
        int flags = this.computeSupportedExpressionFlags(descriptor);
        List<String> signatures = this.getSignatures(descriptor);
        BindEditDialogCreationStrategy dcs = new BindEditDialogCreationStrategy(object, propertyFeature, modelValue, validator, descriptor.getBaseDocument(), this.flagIsSet(flags, 1), this.flagIsSet(flags, 2), signatures, this.flagIsSet(flags, 4), new BindDialogTabAdvisor(object, propertyFeature, descriptor.getAttributeTypeAdapter(), flags, signatures));
        return dcs;
    }

    protected List<String> getSignatures(IFormsPropertyDescriptor descriptor) {
        AttributeTypeAdapter attrTypeAdapter = descriptor.getAttributeTypeAdapter();
        List<String> signatures = Collections.emptyList();
        if (attrTypeAdapter == null) {
            return signatures;
        }
        List expressions = attrTypeAdapter.getSupportedExpressions();
        if (expressions != null) {
            signatures = new ArrayList<String>();
            for (AttributeTypeAdapter.SupportedExpression expression : expressions) {
                List binarySignatures = expression.getValidSignatures();
                for (String binarySignature : binarySignatures) {
                    String sig = TypeUtil.getFullyQualifiedName((String)binarySignature);
                    if (signatures.contains(sig)) continue;
                    signatures.add(sig);
                }
            }
        }
        return signatures;
    }

    @Override
    protected boolean flagIsSet(int flags, int flag) {
        return (flags & flag) > 0;
    }

    @Override
    protected int computeSupportedExpressionFlags(IFormsPropertyDescriptor descriptor) {
        int flags = 0;
        AttributeTypeAdapter attrTypeAdapter = descriptor.getAttributeTypeAdapter();
        AttributeTypeAdapter.SupportedExpression expr = attrTypeAdapter.getSupportedExpressions(AttributeTypeAdapter.ExpressionType.EL_VALUE_BINDING);
        if (expr != null) {
            switch (expr.getResolutionTime()) {
                case PAGE_COMPILE: {
                    flags = 1;
                    break;
                }
                case PAGE_RUN: {
                    flags = 2;
                    break;
                }
                case PAGE_RUN_OR_COMPILE: {
                    flags = 3;
                    break;
                }
                case NOT_AVAILABLE: {
                    flags = 0;
                }
            }
        }
        if ((expr = attrTypeAdapter.getSupportedExpressions(AttributeTypeAdapter.ExpressionType.JSP_EXPRESSION)) != null) {
            flags |= 4;
        }
        return flags;
    }

    public class BindDialogTabAdvisor {
        final EObject _eObject;
        final EStructuralFeature _eFeature;
        boolean _isElValueBinding;
        boolean _isMethodValueBinding;
        boolean _isJSPExpressionBinding;
        final Set<ResolutionTime> _resTimes = new HashSet<ResolutionTime>();
        final List<String> _signatures;

        public BindDialogTabAdvisor(EObject eObject, EStructuralFeature eFeature, AttributeTypeAdapter attrTypeAdapter, int flags, List<String> signatures) {
            this._eObject = eObject;
            this._eFeature = eFeature;
            this._signatures = signatures;
            if (attrTypeAdapter != null) {
                this._isElValueBinding = attrTypeAdapter.getSupportedExpressions(AttributeTypeAdapter.ExpressionType.EL_VALUE_BINDING) != null;
                this._isMethodValueBinding = attrTypeAdapter.getSupportedExpressions(AttributeTypeAdapter.ExpressionType.EL_METHOD_BINDING) != null;
                boolean bl = this._isJSPExpressionBinding = attrTypeAdapter.getSupportedExpressions(AttributeTypeAdapter.ExpressionType.JSP_EXPRESSION) != null;
            }
            if (BindEditDialogCreationStrategyFactory.this.flagIsSet(flags, 1)) {
                this._resTimes.addAll(ResolutionTime.COMPILETIME_VISIBLE_TYPES);
            }
            if (BindEditDialogCreationStrategyFactory.this.flagIsSet(flags, 2)) {
                this._resTimes.addAll(ResolutionTime.RUNTIME_VISIBLE_TYPES);
            }
        }

        public BindUtil.BindDialogTab getTabsToShow() {
            BindUtil.BindDialogTab tabsToShow = BindUtil.INSTANCE.getTabsToShow(this._eObject, this._eFeature, this._resTimes);
            if (this._isJSPExpressionBinding && !this._isElValueBinding && !this._isMethodValueBinding && tabsToShow == BindUtil.BindDialogTab.ALL) {
                return BindUtil.BindDialogTab.VARIABLES;
            }
            if (this._isElValueBinding && tabsToShow == BindUtil.BindDialogTab.ALL) {
                boolean foundAcceptedTypeInSigs = false;
                for (String acceptedType : ACCEPTED_TYPES) {
                    if (!this._signatures.contains(acceptedType)) continue;
                    foundAcceptedTypeInSigs = true;
                    break;
                }
                if (!foundAcceptedTypeInSigs) {
                    return BindUtil.BindDialogTab.VARIABLES;
                }
            }
            return tabsToShow;
        }
    }
}

