/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorListCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.DefaultDeferredListBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.DefaultListBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.IdPathUtil;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.IdStringToTreePathsConverter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.NodeLabelProvider;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.ReadOnlyMessageObservable;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.SelectedItemsLabelProvider;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.SelectedItemsList;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.ShuttleDialog;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.TreePathsToIdStringConverter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IdChooserDialog
extends ShuttleDialog<TreePath> {
    private final IdChooserDialogCreationAdvisor _advisor;
    private final IDOMElement _domElement;
    private TreePath _path;

    public IdChooserDialog(Shell parentShell, IDOMElement element, Document document, IdChooserDialogCreationAdvisor advisor) {
        super(parentShell);
        this._advisor = advisor;
        this._domElement = element;
        this.setTitle(Messages.IdChooserDialog_title);
        this.setMessage(Messages.IdChooserDialog_msg);
        this.setBlockOnOpen(true);
        this.setAllowMoveAllItems(false);
        this.setOrderSelectedItems(false);
        this.setAvailableItemsLabelProvider((ILabelProvider)new NodeLabelProvider());
        this.setAvailableItemsContentProvider((IStructuredContentProvider)new JFaceNodeContentProvider());
        this.setAvailableItemsInput(document);
        this.setAvailableItemsLabelText(Messages.IdChooserDialog_available);
        this.setAvailableItemsDetailsLabelText(Messages.IDChooserDialog_containerNote);
        this.setSelectedItemsLabelProvider(new SelectedItemsLabelProvider());
        this.setSelectedItemsContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        this.setSelectedItemsLabelText(Messages.IdChooserDialog_selected);
    }

    @Override
    protected void doSelectAvailableItem(TreeViewer viewer) {
        Element rootElement;
        Object input = viewer.getInput();
        Document root = null;
        if (input instanceof Document && (rootElement = (root = (Document)input).getDocumentElement()) instanceof IDOMElement) {
            TreePath path = IdPathUtil.findPath((IDOMElement)rootElement, this._domElement);
            viewer.expandToLevel((Object)path, path.getSegmentCount());
            viewer.setSelection((ISelection)new TreeSelection(path));
            this._path = path;
        }
    }

    @Override
    protected boolean enableShuffleRightButton(SelectionChangedEvent event) {
        ITreeSelection treeSelection;
        TreePath[] paths;
        ISelection selection = event.getSelection();
        if (selection instanceof ITreeSelection && (paths = (treeSelection = (ITreeSelection)selection).getPaths()).length > 0) {
            TreePath selectedPath = paths[0];
            return this.canAdd(selectedPath);
        }
        return false;
    }

    @Override
    protected boolean allowAddSelected(TreePath path) {
        return this.canAdd(path);
    }

    private boolean canAdd(TreePath selectedPath) {
        if (this.getSelectedItems().contains(selectedPath)) {
            return false;
        }
        return IdPathUtil.calculateRelativePath(this._path, selectedPath) != null;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.doBindData();
        return control;
    }

    private void doBindData() {
        this._advisor.bindData((IObservableValue)new AbstractObservableValue(){

            public Object getValueType() {
                return null;
            }

            protected Object doGetValue() {
                return null;
            }

            protected void doSetValue(Object value) {
            }
        }, new AbstractDialogEditorCreationAdvisor.IStatusUpdater(){

            @Override
            public void updateStatus(IStatus status) {
            }
        });
        IObservableList list = (IObservableList)this._advisor.getIntermediateModel().getStateModel();
        Object[] treePaths = new TreePath[list.size()];
        list.toArray(treePaths);
        List<Object> selectedPaths = Arrays.asList(treePaths);
        this.setSelectedItemsInput(selectedPaths);
    }

    @Override
    protected Control createDialogArea(Composite container) {
        Control createdDialogArea = super.createDialogArea(container);
        return this._advisor.createEditingArea((Composite)createdDialogArea);
    }

    @Override
    protected TableViewer createSelectedItemsComposite(Composite parent) {
        TableViewer viewer = super.createSelectedItemsComposite(parent);
        this._advisor.setInitState(AbstractDialogEditorCreationAdvisor.InitState.UI_INITIALIZED);
        SelectedItemsList observableList = new SelectedItemsList();
        this.addShuttleListener(observableList);
        this._advisor.getSelectionModel().setStateModel(observableList);
        return viewer;
    }

    public boolean close() {
        this._advisor.computeResult();
        this._advisor.dispose();
        return super.close();
    }

    public static class IdChooserDialogCreationAdvisor
    extends AbstractDialogEditorListCreationAdvisor<IObservableList, UpdateListStrategy> {
        public IdChooserDialogCreationAdvisor(DataBindingContext context, IObservableValue userModel, IDOMElement root, IDOMElement element) {
            super(context, "", (AbstractDialogEditorCreationAdvisor.MessageSourceObservableValue)new ReadOnlyMessageObservable(""), (AbstractBindingMediator)new UserListDataMediator(IdChooserDialogCreationAdvisor.createUserListModel(userModel, context), root), (AbstractBindingMediator)new IntermediateListDataMediator(root, element), (AbstractBindingMediator)new SelectionListDataMediator());
        }

        @Override
        protected Control doCreateEditingArea(Composite parent) {
            return parent;
        }

        private static final IObservableList createUserListModel(IObservableValue userModel, DataBindingContext context) {
            WritableList userListModel = new WritableList(IdChooserDialogCreationAdvisor.getStringListFromUserModel(userModel), String.class);
            ComputedValueUserModel userValueModel = new ComputedValueUserModel((IObservableList)userListModel);
            context.bindValue(userModel, (IObservableValue)userValueModel, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
            return userListModel;
        }

        private static final List<String> getStringListFromUserModel(IObservableValue userModel) {
            String value = (String)userModel.getValue();
            String[] idPaths = value == null ? new String[]{} : value.split("\\s");
            ArrayList<String> idPathList = new ArrayList<String>(idPaths.length);
            String[] stringArray = idPaths;
            int n = idPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String idPath = stringArray[n2];
                String idPathTrimmed = idPath.trim();
                if (!"".equals(idPathTrimmed)) {
                    idPathList.add(idPathTrimmed);
                }
                ++n2;
            }
            return idPathList;
        }

        private static final class ComputedValueUserModel
        extends ComputedValue {
            private final IObservableList _list;

            public ComputedValueUserModel(IObservableList list) {
                super(String.class);
                this._list = list;
            }

            protected Object calculate() {
                StringBuilder builder = new StringBuilder();
                for (String value : this._list) {
                    if (value == null) continue;
                    builder.append(value);
                    builder.append(' ');
                }
                if (builder.length() > 0) {
                    builder.deleteCharAt(builder.length() - 1);
                }
                return builder.toString();
            }
        }

        private static final class IntermediateListDataMediator
        extends DefaultListBindingMediator<IObservableList, UpdateListStrategy> {
            private final IDOMElement _root;
            private final IDOMElement _element;

            protected IntermediateListDataMediator(IDOMElement root, IDOMElement element) {
                super(new TreePathWritableList(), new UpdateListStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), new UpdateListStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
                this._root = root;
                this._element = element;
            }

            @Override
            protected IConverter getTargetUpdateConverter() {
                return new TreePathsToIdStringConverter(this._root, this._element);
            }

            private static final class TreePathWritableList
            extends WritableList {
                public TreePathWritableList() {
                    super(new ArrayList(), TreePath.class);
                }

                public boolean add(Object element) {
                    if (element != null) {
                        return super.add(element);
                    }
                    return false;
                }

                public void add(int index, Object element) {
                    if (element != null) {
                        super.add(index, element);
                    }
                }
            }
        }

        private static final class SelectionListDataMediator
        extends DefaultDeferredListBindingMediator<IObservableList, UpdateListStrategy> {
            public SelectionListDataMediator() {
                super(new UpdateListStrategy(UpdateListStrategy.POLICY_NEVER), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE));
            }
        }

        private static final class UserListDataMediator
        extends DefaultListBindingMediator<IObservableList, UpdateListStrategy> {
            private final IDOMElement _root;

            protected UserListDataMediator(IObservableList userModel, IDOMElement root) {
                super(userModel, new UpdateListStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), new UpdateListStrategy(UpdateValueStrategy.POLICY_NEVER));
                this._root = root;
            }

            @Override
            protected IConverter getModelUpdateConverter() {
                return new IdStringToTreePathsConverter(this._root);
            }
        }
    }
}

