/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor.dialog;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorValueCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractValueBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.DefaultDeferredValueBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.ReadOnlyMessageObservable;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class FileChooserDialog
extends ElementTreeSelectionDialog {
    private final CommonResourceFilter _filter;
    private final FileChooserDialogCreationAdvisor _advisor;
    private Label _messageArea;
    private static final String HELPID = "oracle.eclipse.tools.xml.edit.ui.ChooseFileDialog";

    public FileChooserDialog(Shell parent, FileChooserDialogCreationAdvisor advisor) {
        super(parent, WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (ITreeContentProvider)new ProjectFileDialogContentProvider());
        this._advisor = advisor;
        this._filter = new CommonResourceFilter(this._advisor.getContentType());
        this.addFilter(this._filter);
        this.setComparator((ViewerComparator)new ResourceComparator(2));
        this.setTitle(this._advisor.getTitle());
        this.setInput(this._advisor.getIProject());
        this.setAllowMultiple(this._advisor.getMultipleSelection());
        this.setValidator(new ISelectionStatusValidator(){
            private final IStatus OK_STATUS = new Status(0, "org.eclipse.ui", 0, "", null);
            private final IValidator _validator;
            {
                this._validator = FileChooserDialog.this._advisor.getSelectionValidator();
            }

            public IStatus validate(Object[] selection) {
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    IStatus status = this._validator.validate(value);
                    if (!status.isOK()) {
                        return status;
                    }
                    ++n2;
                }
                return this.OK_STATUS;
            }
        });
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELPID);
    }

    protected Label createMessageArea(Composite composite) {
        this._messageArea = super.createMessageArea(composite);
        return this._messageArea;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.doBindData();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Control createdDialogArea = super.createDialogArea(parent);
        return this._advisor.createEditingArea((Composite)createdDialogArea);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        TreeViewer treeViewer = super.doCreateTreeViewer(parent, style);
        if (!this._filter.areSuffixesBlank()) {
            Button showAllFiles = new Button(parent, 32);
            showAllFiles.setText(Messages.FileChooserDialog_ShowAllFiles);
            showAllFiles.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof Button) {
                        Button button = (Button)e.widget;
                        FileChooserDialog.this._filter.setActive(!button.getSelection());
                        FileChooserDialog.this.getTreeViewer().refresh();
                    }
                }
            });
        }
        this._advisor.setInitState(AbstractDialogEditorCreationAdvisor.InitState.UI_INITIALIZED);
        IViewerObservableValue selectionModel = ViewersObservables.observeSingleSelection((Viewer)treeViewer);
        this._advisor.getSelectionModel().setStateModel(selectionModel);
        return treeViewer;
    }

    protected void doBindData() {
        this._advisor.bindData((IObservableValue)new AbstractObservableValue(){

            protected void doSetValue(Object value) {
                FileChooserDialog.this.setMessage((String)value);
                FileChooserDialog.this._messageArea.setText((String)value);
                FileChooserDialog.this._messageArea.getParent().layout(true);
            }

            protected Object doGetValue() {
                return FileChooserDialog.this.getMessage();
            }

            public Object getValueType() {
                return String.class;
            }
        }, new AbstractDialogEditorCreationAdvisor.IStatusUpdater(){

            @Override
            public void updateStatus(IStatus status) {
            }
        });
        this.setInitialSelection(((IObservableValue)this._advisor.getIntermediateModel().getStateModel()).getValue());
    }

    public boolean close() {
        this._advisor.dispose();
        return super.close();
    }

    protected void computeResult() {
        super.computeResult();
        this._advisor.computeResult();
    }

    protected static class CommonResourceFilter
    extends ViewerFilter {
        private boolean _active = true;
        private String[] _filterSuffixes = null;

        public CommonResourceFilter() {
        }

        public CommonResourceFilter(IContentType contentType) {
            if (contentType == null) {
                this.setSuffixes(null);
            } else {
                String[] fileExts = contentType.getFileSpecs(8);
                this.setSuffixes(fileExts);
            }
        }

        public String[] getSuffixes() {
            return this._filterSuffixes;
        }

        public void setSuffixes(String[] suffixes) {
            this._filterSuffixes = suffixes;
        }

        public void setActive(boolean active) {
            this._active = active;
        }

        public boolean isActive() {
            return this._active;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                if (!this.isUnderWebContentFolder((IResource)file)) {
                    return false;
                }
                if (!this.isActive()) {
                    return true;
                }
                if (this.areSuffixesBlank()) {
                    return true;
                }
                if (file.getFileExtension() == null) return false;
                if (!Arrays.asList(this._filterSuffixes).contains(file.getFileExtension().toLowerCase())) return false;
                return true;
            }
            if (!(element instanceof IContainer)) return false;
            if (!((IContainer)element).isAccessible()) {
                return false;
            }
            if (element instanceof IProject) {
                return true;
            }
            if (!(element instanceof IFolder)) return false;
            IContainer container = (IContainer)element;
            try {
                IResource[] members = container.members();
                int i = 0;
                while (true) {
                    if (i >= members.length) {
                        return false;
                    }
                    if (this.select(viewer, members[i].getParent(), members[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.xml.edit.ui", (CoreException)e);
                return false;
            }
        }

        public boolean areSuffixesBlank() {
            boolean isSuffixBlank = false;
            if (this._filterSuffixes == null) {
                isSuffixBlank = true;
            } else {
                int count = 0;
                String[] stringArray = this._filterSuffixes;
                int n = this._filterSuffixes.length;
                int n2 = 0;
                while (n2 < n) {
                    String suffix = stringArray[n2];
                    if (suffix != null && !"".equals(suffix)) {
                        ++count;
                        break;
                    }
                    ++n2;
                }
                if (count == 0) {
                    isSuffixBlank = true;
                }
            }
            return isSuffixBlank;
        }

        private boolean isUnderWebContentFolder(IResource resource) {
            IPath webContentPath;
            IContainer underlyingFolder;
            IVirtualFolder rootFolder;
            IVirtualComponent component;
            IProject iProject = resource.getProject();
            if (iProject != null && (component = ComponentCore.createComponent((IProject)iProject)) != null && (rootFolder = component.getRootFolder()) != null && (underlyingFolder = rootFolder.getUnderlyingFolder()) != null && (webContentPath = underlyingFolder.getFullPath()) != null) {
                return webContentPath.isPrefixOf(resource.getFullPath());
            }
            return true;
        }
    }

    public static class FileChooserDialogCreationAdvisor
    extends AbstractDialogEditorValueCreationAdvisor<IObservableValue, UpdateValueStrategy> {
        private final boolean _multipleSelection;
        private final IValidator _selectionValidator;
        private final IContentType _contentType;
        private final IProject _iProject;

        public static FileChooserDialogCreationAdvisor getAdvisor(DataBindingContext context, String title, String treeLabel, boolean multipleSelection, String validationMsg, boolean allowCurrentFileSelection, IFile currentFile, String currentFileValidationMsg, IContentType contentType, IProject iProject, AbstractBindingMediator<IObservableValue, UpdateValueStrategy> userModel, AbstractBindingMediator<IObservableValue, UpdateValueStrategy> intermediateModel) {
            SelectionValidator selectionValidator = new SelectionValidator(validationMsg, allowCurrentFileSelection, currentFile, currentFileValidationMsg);
            return new FileChooserDialogCreationAdvisor(context, title, treeLabel, multipleSelection, selectionValidator, contentType, iProject, userModel, intermediateModel);
        }

        private FileChooserDialogCreationAdvisor(DataBindingContext context, String title, String treeLabel, boolean multipleSelection, IValidator selectionValidator, IContentType contentType, IProject iProject, AbstractBindingMediator<IObservableValue, UpdateValueStrategy> userModel, AbstractBindingMediator<IObservableValue, UpdateValueStrategy> intermediateModel) {
            super(context, title, (AbstractDialogEditorCreationAdvisor.MessageSourceObservableValue)new ReadOnlyMessageObservable(treeLabel), (AbstractBindingMediator)userModel, (AbstractBindingMediator)intermediateModel, (AbstractBindingMediator)new SelectionDataMediator(selectionValidator));
            this._multipleSelection = multipleSelection;
            this._selectionValidator = selectionValidator;
            this._contentType = contentType;
            this._iProject = iProject;
        }

        public boolean getMultipleSelection() {
            return this._multipleSelection;
        }

        public IValidator getSelectionValidator() {
            return this._selectionValidator;
        }

        public IContentType getContentType() {
            return this._contentType;
        }

        public IProject getIProject() {
            return this._iProject;
        }

        @Override
        protected Control doCreateEditingArea(Composite parent) {
            return parent;
        }

        private static final class SelectionDataMediator
        extends DefaultDeferredValueBindingMediator<IObservableValue, UpdateValueStrategy> {
            private final IValidator _selectionValidator;

            public SelectionDataMediator(IValidator selectionValidator) {
                super(new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
                this._selectionValidator = selectionValidator;
            }

            @Override
            protected List<AbstractValueBindingMediator.ValidatorDescriptor> getTargetUpdateValidators() {
                return Collections.singletonList(new AbstractValueBindingMediator.ValidatorDescriptor(this._selectionValidator, AbstractValueBindingMediator.ValidatorDescriptor.EValidatorRuntime.AfterGetValidator));
            }
        }

        private static final class SelectionValidator
        implements IValidator {
            private final String _validationMsg;
            private final boolean _allowCurrentFileSelection;
            private final IFile _currentFile;
            private final String _currentFileValidationMsg;

            public SelectionValidator(String validationMsg, boolean allowCurrentFileSelection, IFile currentFile, String currentFileValidationMsg) {
                this._validationMsg = validationMsg;
                this._allowCurrentFileSelection = allowCurrentFileSelection;
                this._currentFile = currentFile;
                this._currentFileValidationMsg = currentFileValidationMsg;
            }

            public IStatus validate(Object value) {
                if (!(value instanceof IFile)) {
                    return ValidationStatus.error((String)this._validationMsg);
                }
                if (!this._allowCurrentFileSelection && this._currentFile.equals(value)) {
                    return ValidationStatus.error((String)this._currentFileValidationMsg);
                }
                return Status.OK_STATUS;
            }
        }
    }

    protected static class ProjectFileDialogContentProvider
    implements ITreeContentProvider {
        protected ProjectFileDialogContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object element) {
            IContainer container;
            if (element instanceof Object[]) {
                return (Object[])element;
            }
            if (element instanceof IContainer && (container = (IContainer)element).isAccessible()) {
                try {
                    return container.members();
                }
                catch (CoreException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.xml.edit.ui", (CoreException)e);
                }
            }
            return new Object[0];
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

