/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor.dialog;

import java.util.List;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractBindingMediator;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;

public abstract class AbstractValueBindingMediator<T extends IObservableValue, S extends UpdateValueStrategy>
extends AbstractBindingMediator<T, S> {
    public AbstractValueBindingMediator(T stateModel) {
        super(stateModel);
    }

    protected AbstractValueBindingMediator() {
    }

    @Override
    public final S getAsModelUpdateStrategy() {
        UpdateValueStrategy strategy = (UpdateValueStrategy)this.getModelUpdateStrategy();
        Assert.isNotNull((Object)strategy);
        IConverter converter = this.getModelUpdateConverter();
        List<ValidatorDescriptor> validators = this.getModelUpdateValidators();
        Assert.isNotNull(validators);
        this.setValidatorAndConverters(strategy, converter, validators);
        return (S)strategy;
    }

    protected abstract List<ValidatorDescriptor> getModelUpdateValidators();

    @Override
    public final S getAsTargetUpdateStrategy() {
        UpdateValueStrategy strategy = (UpdateValueStrategy)this.getTargetUpdateStrategy();
        Assert.isNotNull((Object)strategy);
        IConverter converter = this.getTargetUpdateConverter();
        List<ValidatorDescriptor> validators = this.getTargetUpdateValidators();
        Assert.isNotNull(validators);
        this.setValidatorAndConverters(strategy, converter, validators);
        return (S)strategy;
    }

    protected abstract List<ValidatorDescriptor> getTargetUpdateValidators();

    private void setValidatorAndConverters(S strategy, IConverter converter, List<ValidatorDescriptor> validators) {
        if (converter != null) {
            strategy.setConverter(converter);
        }
        for (ValidatorDescriptor validator : validators) {
            validator.add((UpdateValueStrategy)strategy);
        }
    }

    public static final class ValidatorDescriptor {
        private final IValidator _validator;
        private final EValidatorRuntime _validatorRuntime;

        public ValidatorDescriptor(IValidator validator, EValidatorRuntime validatorRuntime) {
            this._validator = validator;
            this._validatorRuntime = validatorRuntime;
        }

        public void add(UpdateValueStrategy strategy) {
            switch (this._validatorRuntime) {
                case AfterGetValidator: {
                    strategy.setAfterGetValidator(this._validator);
                    break;
                }
                case AfterConvertValidator: {
                    strategy.setAfterConvertValidator(this._validator);
                    break;
                }
                case BeforeSetValidator: {
                    strategy.setBeforeSetValidator(this._validator);
                }
            }
        }

        public static enum EValidatorRuntime {
            AfterGetValidator,
            AfterConvertValidator,
            BeforeSetValidator;

        }
    }
}

