/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor.dialog;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractBindingMediator;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractDialogEditorCreationAdvisor<T extends IObservable, S> {
    private final String _title;
    private final MessageSourceObservableValue _messageObservable;
    private final AbstractBindingMediator<T, S> _userModel;
    private final AbstractBindingMediator<T, S> _intermediateModel;
    private final AbstractBindingMediator<T, S> _selectionModel;
    private final DataBindingContext _context;
    private Binding _initBinding;
    private Binding _updateModelBinding;
    private InitState _initState;
    private List<Binding> _unsetBindings = Collections.emptyList();

    protected AbstractDialogEditorCreationAdvisor(DataBindingContext context, String title, MessageSourceObservableValue messageObservableValue, AbstractBindingMediator<T, S> userModel, AbstractBindingMediator<T, S> intermediateModel, AbstractBindingMediator<T, S> selectionModel) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)messageObservableValue.getValue(), (String)"The value of the message observable must not be null");
        this._title = title;
        this._messageObservable = messageObservableValue;
        this._userModel = userModel;
        this._intermediateModel = intermediateModel;
        this._selectionModel = selectionModel;
        this._initState = InitState.CONSTRUCTED;
        this._context = context;
    }

    public final void addUnsetBindings(List<Binding> unsetBindings) {
        if (unsetBindings != null) {
            this._unsetBindings = unsetBindings;
        }
    }

    public final List<Binding> getUnsetBindings() {
        return Collections.unmodifiableList(this._unsetBindings);
    }

    public DataBindingContext getContext() {
        return this._context;
    }

    public final String getTitle() {
        return this._title;
    }

    public final Binding getInitBinding() {
        return this._initBinding;
    }

    protected void setInitBinding(Binding initBinding) {
        this._initBinding = initBinding;
    }

    public final Binding getUpdateModelBinding() {
        return this._updateModelBinding;
    }

    protected void setUpdateModelBinding(Binding updateModelBinding) {
        this._updateModelBinding = updateModelBinding;
    }

    public final Control createEditingArea(Composite parent) {
        Control returnValue = this.doCreateEditingArea(parent);
        this._initState = InitState.UI_INITIALIZED;
        return returnValue;
    }

    protected final void setInitState(InitState newState) {
        if (this._initState == InitState.CONSTRUCTED || this._initState == InitState.UI_INITIALIZED) {
            Assert.isTrue((newState == InitState.UI_INITIALIZED ? 1 : 0) != 0);
            this._initState = newState;
            return;
        }
        throw new IllegalStateException();
    }

    public final void setInitialized() {
        this.setInitState(InitState.UI_INITIALIZED);
    }

    protected abstract Control doCreateEditingArea(Composite var1);

    protected final void triggerUnsetBindings() {
        List<Binding> bindings = this.getUnsetBindings();
        for (Binding binding : bindings) {
            binding.updateTargetToModel();
        }
    }

    public void bindData(IObservableValue messageDestinationObservableValue, IStatusUpdater statusUpdater) {
        this.bindUserToIntermediateModel();
        this.bindIntermediateToSelectionModel();
        this._context.bindValue(this.getCommitStatusModel(statusUpdater), (IObservableValue)new AggregateValidationStatus(this._context, 2), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        this._context.bindValue((IObservableValue)this._messageObservable, messageDestinationObservableValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER)).updateTargetToModel();
    }

    protected abstract void bindIntermediateToSelectionModel();

    protected void reinitializeIntermediateToSelectionModelBinding() {
        this._initBinding.updateModelToTarget();
    }

    protected abstract void bindUserToIntermediateModel();

    public final MessageSourceObservableValue getMessageObservable() {
        return this._messageObservable;
    }

    public final AbstractBindingMediator<T, S> getUserModel() {
        return this._userModel;
    }

    public final AbstractBindingMediator<T, S> getIntermediateModel() {
        return this._intermediateModel;
    }

    public final AbstractBindingMediator<T, S> getSelectionModel() {
        if (!this._initState.isUIInitialized()) {
            throw new IllegalStateException("It is illegal to call getSelectionModel before createEditingArea");
        }
        return this._selectionModel;
    }

    public final IObservableValue getCommitStatusModel(final IStatusUpdater statusUpdater) {
        return new WritableValue(Status.OK_STATUS, IStatus.class){

            public void doSetValue(Object value) {
                super.doSetValue(value);
                statusUpdater.updateStatus((IStatus)value);
            }
        };
    }

    public void dispose() {
        this._context.dispose();
    }

    public void computeResult() {
        this.getUpdateModelBinding().updateTargetToModel();
        this.triggerUnsetBindings();
    }

    public static interface IStatusUpdater {
        public void updateStatus(IStatus var1);
    }

    protected static enum InitState {
        CONSTRUCTED,
        UI_INITIALIZED;


        private boolean isUIInitialized() {
            return this == UI_INITIALIZED;
        }
    }

    public static class MessageSourceObservableValue
    extends WritableValue {
        public MessageSourceObservableValue() {
            super(null, String.class);
        }

        public MessageSourceObservableValue(String value) {
            super((Object)value, String.class);
        }
    }
}

