/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.ComponentCore;

public class ResourceToUriConverter
extends Converter {
    private static final String PATH_SEPARATOR = "/";
    private final IFile _baseFile;

    public ResourceToUriConverter(IFile baseFile) {
        super(IResource.class, String.class);
        this._baseFile = baseFile;
    }

    public Object convert(Object fromObject) {
        if (!(fromObject instanceof IFile)) {
            return null;
        }
        IFile resource = (IFile)fromObject;
        return this.getAbsoluteUri(resource);
    }

    protected String getAbsoluteUri(IFile resource) {
        IPath resourcePath = resource.getFullPath();
        IPath webContentPath = ComponentCore.createComponent((IProject)this._baseFile.getProject()).getRootFolder().getUnderlyingFolder().getFullPath();
        StringBuffer strWebrootPath = new StringBuffer();
        if (webContentPath != null && webContentPath.isPrefixOf(resourcePath)) {
            int start = resourcePath.matchingFirstSegments(webContentPath);
            String[] segments = resourcePath.segments();
            int i = start;
            int n = resourcePath.segmentCount();
            while (i < n) {
                strWebrootPath.append(PATH_SEPARATOR);
                strWebrootPath.append(segments[i]);
                ++i;
            }
        }
        return strWebrootPath.length() == 0 ? null : strWebrootPath.toString();
    }
}

