/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.AbstractDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditorDialog;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.databinding.EMFUpdateListStrategy;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MultipleChoiceDialogCreationStrategy
extends AbstractDialogCreationStrategy {
    protected List<?> choices;
    protected ILabelProvider labelProvider;
    protected IObservableList modelList;
    protected IObservableList targetList;
    protected IValidator validator;

    public MultipleChoiceDialogCreationStrategy(List<?> choices, ILabelProvider labelProvider, IObservableList modelList, IValidator validator) {
        this.choices = choices;
        this.labelProvider = labelProvider;
        this.modelList = modelList;
        this.validator = validator;
    }

    @Override
    public ToolItem createToolItem(ToolBar parent, WidgetAdapter widgetAdapter) {
        return this.createToolItem(parent, widgetAdapter, LABEL_PROVIDER);
    }

    @Override
    public Image getToolItemImage() {
        return CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE);
    }

    @Override
    public void openDialog(Control parent, IObservableValue modelObservable) {
        MultipleChoiceEditDialog dialog = new MultipleChoiceEditDialog(parent.getShell(), Messages.MultipleChoiceEditDialog, Messages.AddRemoveOrReorderValues, this.modelList, this.labelProvider, this.choices, this.validator);
        dialog.open();
    }

    public IObservableList getTargetList() {
        return this.targetList;
    }

    private class MultipleChoiceEditDialog
    extends PropertyEditorDialog {
        private List<?> _choices;
        private ILabelProvider _labelProvider;
        private TableViewer chosenTableViewer;

        public MultipleChoiceEditDialog(IShellProvider parentShell, String title, String instructions, IObservableList modelList, ILabelProvider labelProvider, List<?> choices, IValidator validator) {
            super(parentShell, title, instructions, (IObservable)modelList, validator);
            this._labelProvider = labelProvider;
            this._choices = choices;
        }

        public MultipleChoiceEditDialog(Shell parentShell, String title, String instructions, IObservableList modelList, ILabelProvider labelProvider, List<?> choices, IValidator validator) {
            super(parentShell, title, instructions, (IObservable)modelList, validator);
            this._labelProvider = labelProvider;
            this._choices = choices;
        }

        @Override
        public Control createEditingArea(Composite parent) {
            Composite editArea = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            editArea.setLayout((Layout)layout);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            this.editingArea.setLayoutData((Object)data);
            Composite choicesArea = new Composite(editArea, 0);
            data = new GridData(4, 4, true, true);
            choicesArea.setLayoutData((Object)data);
            GridLayout layout2 = new GridLayout();
            layout2.marginHeight = 0;
            layout2.marginWidth = 0;
            layout2.numColumns = 1;
            choicesArea.setLayout((Layout)layout2);
            Label choicesLabel = new Label(choicesArea, 0);
            choicesLabel.setText(Messages.Choices);
            GridData data2 = new GridData();
            data2.verticalAlignment = 4;
            data2.horizontalAlignment = 4;
            choicesLabel.setLayoutData((Object)data2);
            Table choicesTable = new Table(choicesArea, 2050);
            GridData data3 = new GridData(4, 4, true, true);
            data3.widthHint = Display.getCurrent().getBounds().width / 15;
            data3.heightHint = Display.getCurrent().getBounds().height / 6;
            choicesTable.setLayoutData((Object)data3);
            final TableViewer choicesTableViewer = new TableViewer(choicesTable);
            choicesTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)new AdapterFactoryImpl()));
            choicesTableViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
            choicesTableViewer.setInput((Object)new ItemProvider(this._choices));
            Composite buttonArea = new Composite(editArea, 0);
            GridData data4 = new GridData();
            data4.verticalAlignment = 4;
            data4.horizontalAlignment = 4;
            buttonArea.setLayoutData((Object)data4);
            GridLayout layout3 = new GridLayout();
            buttonArea.setLayout((Layout)layout3);
            new Label(buttonArea, 0);
            final Button addButton = new Button(buttonArea, 8);
            addButton.setText(Messages.Add);
            GridData data5 = new GridData();
            data5.verticalAlignment = 4;
            data5.horizontalAlignment = 4;
            addButton.setLayoutData((Object)data5);
            final Button removeButton = new Button(buttonArea, 8);
            removeButton.setText(Messages.Remove);
            GridData data6 = new GridData();
            data6.verticalAlignment = 4;
            data6.horizontalAlignment = 4;
            removeButton.setLayoutData((Object)data6);
            Label spacerLabel = new Label(buttonArea, 0);
            GridData data7 = new GridData();
            data7.verticalSpan = 2;
            spacerLabel.setLayoutData((Object)data7);
            Button upButton = new Button(buttonArea, 8);
            upButton.setText(Messages.Up);
            GridData data8 = new GridData();
            data8.verticalAlignment = 4;
            data8.horizontalAlignment = 4;
            upButton.setLayoutData((Object)data8);
            Button downButton = new Button(buttonArea, 8);
            downButton.setText(Messages.Down);
            GridData data9 = new GridData();
            data9.verticalAlignment = 4;
            data9.horizontalAlignment = 4;
            downButton.setLayoutData((Object)data9);
            Composite chosenArea = new Composite(editArea, 0);
            GridData data10 = new GridData(4, 4, true, true);
            chosenArea.setLayoutData((Object)data10);
            GridLayout layout4 = new GridLayout();
            layout4.marginHeight = 0;
            layout4.marginWidth = 0;
            layout4.numColumns = 1;
            chosenArea.setLayout((Layout)layout4);
            Label chosenLabel = new Label(chosenArea, 0);
            chosenLabel.setText(Messages.Chosen);
            GridData data11 = new GridData();
            data11.verticalAlignment = 4;
            data11.horizontalAlignment = 4;
            chosenLabel.setLayoutData((Object)data11);
            Table chosenTable = new Table(chosenArea, 2050);
            GridData data12 = new GridData(4, 4, true, true);
            data12.widthHint = Display.getCurrent().getBounds().width / 15;
            data12.heightHint = Display.getCurrent().getBounds().height / 6;
            chosenTable.setLayoutData((Object)data12);
            this.chosenTableViewer = new TableViewer(chosenTable);
            this.chosenTableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
            this.chosenTableViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)choicesTableViewer.getSelection();
                    for (Object value : selection.toList()) {
                        if (((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.contains(value)) continue;
                        ((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.add(value);
                    }
                    MultipleChoiceEditDialog.this.chosenTableViewer.setSelection((ISelection)selection);
                }
            });
            choicesTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (addButton.isEnabled()) {
                        addButton.notifyListeners(13, null);
                    }
                }
            });
            upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)MultipleChoiceEditDialog.this.chosenTableViewer.getSelection();
                    for (Object value : selection.toList()) {
                        int oldIndex = ((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.indexOf(value);
                        int newIndex = oldIndex - 1;
                        if (newIndex < 0) {
                            newIndex = 0;
                        }
                        ((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.move(oldIndex, newIndex);
                    }
                }
            });
            removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)MultipleChoiceEditDialog.this.chosenTableViewer.getSelection();
                    for (Object value : selection.toList()) {
                        ((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.remove(value);
                    }
                    if (!((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.isEmpty()) {
                        MultipleChoiceEditDialog.this.chosenTableViewer.setSelection((ISelection)new StructuredSelection(((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.get(0)));
                    }
                    choicesTableViewer.setSelection((ISelection)selection);
                }
            });
            this.chosenTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (removeButton.isEnabled()) {
                        removeButton.notifyListeners(13, null);
                    }
                }
            });
            upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)MultipleChoiceEditDialog.this.chosenTableViewer.getSelection();
                    for (Object value : selection.toList()) {
                        int oldIndex = ((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.indexOf(value);
                        int newIndex = oldIndex - 1;
                        if (newIndex < 0) {
                            newIndex = 0;
                        }
                        ((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.move(oldIndex, newIndex);
                    }
                }
            });
            downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)MultipleChoiceEditDialog.this.chosenTableViewer.getSelection();
                    int maxIndex = ((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.size() - 1;
                    for (Object value : selection.toList()) {
                        int oldIndex = ((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.indexOf(value);
                        int newIndex = oldIndex + 1;
                        if (newIndex > maxIndex) {
                            newIndex = maxIndex;
                        }
                        ((MultipleChoiceEditDialog)MultipleChoiceEditDialog.this).MultipleChoiceDialogCreationStrategy.this.targetList.move(oldIndex, newIndex);
                    }
                }
            });
            return editArea;
        }

        @Override
        public void bindData() {
            MultipleChoiceDialogCreationStrategy.this.targetList = new WritableList();
            this.chosenTableViewer.setInput((Object)MultipleChoiceDialogCreationStrategy.this.targetList);
            this.updateModelBinding = this.context.bindList(MultipleChoiceDialogCreationStrategy.this.targetList, (IObservableList)this.getModelObservable(), (UpdateListStrategy)new EMFUpdateListStrategy(EMFUpdateListStrategy.POLICY_ON_REQUEST), null);
        }

        @Override
        protected void bindOkButton(Button button) {
        }
    }
}

