/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import java.util.List;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.AbstractBindDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import oracle.eclipse.tools.xml.model.metadata.ossmd.util.EMFMDAdapter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ChooseTypeDialogCreationStrategy
extends AbstractBindDialogCreationStrategy {
    private static final String RUNTIME_VALUE_TYPE = "attribute-value-runtime-type";
    private static final String JAVACLASS_TYPE = "org.eclipse.jst.jsf.core.attributevalues.JavaClassType";
    private static final String REQUIRED_INTERFACES = "valid-interfaces";
    private static final String STANDARD_TITLE = Messages.ChooseTypeDialogCreationStrategy_title;
    private static final String STANDARD_MSG = Messages.ChooseTypeDialogCreationStrategy_standardMsg;
    private static final String TOOLTIP = Messages.ChooseTypeDialogCreationStrategy_tooltip;
    private EObjectObservableValue _userModel;
    private final IDocument _doc;
    private List<String> _requiredInterfaces;
    private IValidValues _validValues;

    public ChooseTypeDialogCreationStrategy(IDocument doc, EObjectObservableValue userModel) {
        this._doc = doc;
        this._userModel = userModel;
    }

    @Override
    public ToolItem createToolItem(ToolBar parent, WidgetAdapter widgetAdapter) {
        return this.createToolItem(parent, widgetAdapter, LABEL_PROVIDER);
    }

    @Override
    public Image getToolItemImage() {
        return CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE);
    }

    @Override
    public void openDialog(Control parent, IObservableValue modelObservable) {
        if (!this.isValid()) {
            return;
        }
        if (modelObservable != null) {
            if (this._userModel != null && this._userModel != modelObservable) {
                this._userModel.dispose();
            }
            this._userModel = (EObjectObservableValue)modelObservable;
        }
        this.computeRequirements();
        SelectionDialog dialog = (SelectionDialog)this.getDialog(parent, (IObservableValue)this._userModel);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            IType type = (IType)dialog.getResult()[0];
            this._userModel.setValue((Object)type.getFullyQualifiedName());
        }
    }

    @Override
    public String doGetToolTipText() {
        return TOOLTIP;
    }

    @Override
    public IDocument getBaseDocument() {
        return this._doc;
    }

    @Override
    protected Dialog getDialog(Control parent, IObservableValue modelObservable) {
        try {
            IJavaSearchScope scope = this.getSearchScope();
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)parent.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)scope, (int)this.getSearchStyle(), (boolean)false, (String)this.getStartFilterValue(), (TypeSelectionExtension)this.getTypeSelectionExtension());
            dialog.setTitle(STANDARD_TITLE);
            dialog.setMessage(this.getMessage());
            return dialog;
        }
        catch (JavaModelException e) {
            Activator.log("Unable to create Choose Type Dialog", (Exception)((Object)e));
            return null;
        }
    }

    private String getMessage() {
        String interfaces = this.getInterfaceNames();
        if (interfaces != null) {
            return NLS.bind((String)Messages.ChooseTypeDialogCreationStrategy_msgWithValidation, (Object)interfaces);
        }
        return STANDARD_MSG;
    }

    private String getInterfaceNames() {
        if (this._requiredInterfaces != null) {
            StringBuffer interfaces = new StringBuffer();
            int i = 0;
            while (i < this._requiredInterfaces.size()) {
                interfaces.append(this._requiredInterfaces.get(i));
                if (i < this._requiredInterfaces.size() - 1) {
                    interfaces.append(", ");
                }
                ++i;
            }
            return interfaces.toString();
        }
        return null;
    }

    private TypeSelectionExtension getTypeSelectionExtension() {
        TypeSelectionExtension ext = new TypeSelectionExtension(){

            public ISelectionStatusValidator getSelectionValidator() {
                return this.getValidator(ChooseTypeDialogCreationStrategy.this._requiredInterfaces);
            }

            private ISelectionStatusValidator getValidator(List<String> requiredInterfaces) {
                return new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        IType type = (IType)selection[0];
                        if (type == null) {
                            return Status.CANCEL_STATUS;
                        }
                        if (ChooseTypeDialogCreationStrategy.this._validValues != null && !ChooseTypeDialogCreationStrategy.this._validValues.isValidValue(type.getFullyQualifiedName())) {
                            return new Status(4, "oracle.eclipse.tools.xml.edit.ui", String.valueOf(Messages.ChooseTypeDialogCreationStrategy_validationMsg) + ChooseTypeDialogCreationStrategy.this.getInterfaceNames());
                        }
                        return Status.OK_STATUS;
                    }
                };
            }
        };
        return ext;
    }

    private String getStartFilterValue() {
        String dt = (String)this._userModel.getValue();
        if (dt == null) {
            dt = "";
        }
        return dt;
    }

    private int getSearchStyle() {
        if (this._requiredInterfaces != null && this._requiredInterfaces.size() > 0) {
            return 2;
        }
        return 512;
    }

    private IJavaSearchScope getSearchScope() {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getJavaProject()});
    }

    private IJavaElement getJavaProject() {
        return JavaCore.create((IProject)this._doc.getFile().getProject());
    }

    private void computeRequirements() {
        Entity attrEntity;
        EMFMDAdapter adapter = new EMFMDAdapter();
        EClass eClass = ((EObject)this._userModel.getObserved()).eClass();
        EStructuralFeature feature = (EStructuralFeature)this._userModel.getValueType();
        Entity tagEntity = adapter.getTagEntity(this._doc.getFile(), eClass);
        if (tagEntity != null && (attrEntity = adapter.getTagEntity(this._doc.getFile(), eClass, feature)) != null) {
            IMetaDataDomainContext mdContext = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this._doc.getFile());
            IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(mdContext);
            Trait runtimevalueType = query.getQueryHelper().getTrait(attrEntity, RUNTIME_VALUE_TYPE);
            if (runtimevalueType != null && TraitValueHelper.getValueAsString((Trait)runtimevalueType).equals(JAVACLASS_TYPE)) {
                Trait requiredInterfacesTrait;
                List features = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidValues.class, this.getStructuredDocContext(), this.getUri(attrEntity), tagEntity.getId(), attrEntity.getId());
                if (features.size() > 0) {
                    this._validValues = (IValidValues)features.get(0);
                }
                if ((requiredInterfacesTrait = query.getQueryHelper().getTrait(attrEntity, REQUIRED_INTERFACES)) != null) {
                    this._requiredInterfaces = TraitValueHelper.getValueAsListOfStrings((Trait)requiredInterfacesTrait);
                }
            }
        }
    }

    private String getUri(Entity entity) {
        return entity.getModel().getId();
    }

    private IStructuredDocumentContext getStructuredDocContext() {
        org.eclipse.jface.text.IDocument jfaceDoc = (org.eclipse.jface.text.IDocument)this._doc.getAdapter(org.eclipse.jface.text.IDocument.class);
        return IStructuredDocumentContextFactory.INSTANCE.getContext(jfaceDoc, 0);
    }
}

