/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client.rest;

import com.google.gerrit.common.data.ApprovalType;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ApprovalUtil {
    public static final ApprovalType VRIF;
    public static final ApprovalType CRVW;
    public static final ApprovalType IPCL;
    private static final Map<String, ApprovalType> BY_NAME;
    private static final Map<String, ApprovalType> BY_ID;

    static {
        ApprovalCategory vrifCategory = new ApprovalCategory(new ApprovalCategory.Id("VRIF"), "Verified");
        vrifCategory.setAbbreviatedName("V");
        vrifCategory.setPosition((short)0);
        ArrayList<ApprovalCategoryValue> vrifValues = new ArrayList<ApprovalCategoryValue>(3);
        vrifValues.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(vrifCategory.getId(), -1), "Fails"));
        vrifValues.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(vrifCategory.getId(), 0), "No score"));
        vrifValues.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(vrifCategory.getId(), 1), "Verified"));
        VRIF = new ApprovalType(vrifCategory, vrifValues);
        ApprovalCategory crvwCategory = new ApprovalCategory(new ApprovalCategory.Id("CRVW"), "Code Review");
        crvwCategory.setAbbreviatedName("R");
        crvwCategory.setPosition((short)1);
        ArrayList<ApprovalCategoryValue> crvwValues = new ArrayList<ApprovalCategoryValue>(5);
        crvwValues.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(crvwCategory.getId(), -2), "Do not submit"));
        crvwValues.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(crvwCategory.getId(), -1), "I would prefer that you didn't submit this"));
        crvwValues.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(crvwCategory.getId(), 0), "No score"));
        crvwValues.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(crvwCategory.getId(), 1), "Looks good to me, but someone else must approve"));
        crvwValues.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(crvwCategory.getId(), 2), "Looks good to me, approved"));
        CRVW = new ApprovalType(crvwCategory, crvwValues);
        ApprovalCategory ipclCategory = new ApprovalCategory(new ApprovalCategory.Id("IPCL"), "IP Clean");
        ipclCategory.setAbbreviatedName("I");
        ipclCategory.setPosition((short)2);
        ArrayList<ApprovalCategoryValue> ipclValues = new ArrayList<ApprovalCategoryValue>(3);
        ipclValues.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(ipclCategory.getId(), -1), "Unclean IP, do not check in"));
        ipclValues.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(ipclCategory.getId(), 0), "No score"));
        ipclValues.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(ipclCategory.getId(), 1), "IP review completed"));
        IPCL = new ApprovalType(ipclCategory, ipclValues);
        BY_NAME = new HashMap<String, ApprovalType>(3);
        BY_NAME.put(VRIF.getCategory().getName(), VRIF);
        BY_NAME.put(CRVW.getCategory().getName(), CRVW);
        BY_NAME.put(IPCL.getCategory().getName(), IPCL);
        BY_ID = new HashMap<String, ApprovalType>(3);
        BY_ID.put(VRIF.getCategory().getId().get(), VRIF);
        BY_ID.put(CRVW.getCategory().getId().get(), CRVW);
        BY_ID.put(IPCL.getCategory().getId().get(), IPCL);
    }

    private static ApprovalCategory findCategoryByName(String name) {
        if (BY_NAME.containsKey(name)) {
            return BY_NAME.get(name).getCategory();
        }
        return null;
    }

    static ApprovalCategory findCategoryByNameWithDash(String name) {
        return ApprovalUtil.findCategoryByName(name.replace('-', ' '));
    }

    static ApprovalCategory.Id findCategoryIdByName(String name) {
        ApprovalCategory cat = ApprovalUtil.findCategoryByName(name);
        if (cat != null) {
            return cat.getId();
        }
        return null;
    }

    static ApprovalCategory.Id findCategoryIdByNameWithDash(String name) {
        return ApprovalUtil.findCategoryIdByName(name.replace('-', ' '));
    }

    static String findCategoryNameById(String id) {
        if (BY_ID.containsKey(id)) {
            return BY_ID.get(id).getCategory().getName();
        }
        return null;
    }

    public static String toNameWithDash(String name) {
        return name.replace(' ', '-');
    }

    static short parseShort(String s) {
        if ((s = s.trim()).startsWith("+")) {
            s = s.substring(1);
        }
        return Short.parseShort(s);
    }

    private ApprovalUtil() {
    }
}

