/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import java.util.Map;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.ui.dialogs.AbstractKeyValueDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapOfStringsInputDialog
extends AbstractKeyValueDialog {
    private Map<String, String> map;

    public AbstractMapOfStringsInputDialog(Shell shell, String dialogTitle, String dialogMessage, Map<String, String> map) {
        super(shell, dialogTitle, dialogMessage);
        this.map = map;
    }

    @Override
    protected String getInitialMessage() {
        return "Please, supply the name and value for the variable";
    }

    @Override
    protected String getValueLabelText() {
        return "Value: ";
    }

    @Override
    protected String getKeyLabelText() {
        return "Name: ";
    }

    protected abstract boolean isExistingKeyEdit();

    @Override
    protected Listener createChangesValidator() {
        return new Listener(){

            public void handleEvent(Event event) {
                String errorMessage = null;
                String key = AbstractMapOfStringsInputDialog.this.keyField.getText().trim();
                if (key.equals("")) {
                    errorMessage = "The variable name must be specified";
                }
                String value = AbstractMapOfStringsInputDialog.this.valueField.getText().trim();
                if (errorMessage == null && value.equals("")) {
                    errorMessage = "The value must be specified";
                }
                if (errorMessage == null && !AbstractMapOfStringsInputDialog.this.isExistingKeyEdit() && AbstractMapOfStringsInputDialog.this.map.containsKey(key)) {
                    errorMessage = "The key: " + key + " is already specified.";
                }
                AbstractMapOfStringsInputDialog.this.setErrorMessage(errorMessage);
            }
        };
    }
}

