/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.decorator;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.log.Log;
import org.python.pydev.navigator.decorator.IProblemChangedListener;
import org.python.pydev.navigator.decorator.ProblemMarkerManager;
import org.python.pydev.navigator.decorator.ProblemsLabelChangedEvent;
import org.python.pydev.plugin.PydevPlugin;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private IProblemChangedListener fProblemChangedListener;
    private ListenerList fListeners;

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object obj) {
        Log.log((String)"Did not expect this module to be called -- implementing org.eclipse.jface.viewers.ILightweightLabelDecorator.");
        return image;
    }

    protected int getErrorState(Object obj) {
        try {
            IResource resource;
            if (obj instanceof IResource) {
                return this.getErrorTicksFromMarkers((IResource)obj, 2);
            }
            if (obj instanceof IAdaptable && (resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class)) != null) {
                return this.getErrorTicksFromMarkers(resource, 2);
            }
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(IResource res, int depth) throws CoreException {
        if (!res.isAccessible()) {
            return 0;
        }
        return res.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, depth);
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            ProblemMarkerManager.getSingleton().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
                    if (ProblemsLabelDecorator.this.fListeners != null && !ProblemsLabelDecorator.this.fListeners.isEmpty()) {
                        ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)ProblemsLabelDecorator.this, changedResources, isMarkerChange);
                        Object[] listeners = ProblemsLabelDecorator.this.fListeners.getListeners();
                        int i = 0;
                        while (i < listeners.length) {
                            ((ILabelProviderListener)listeners[i]).labelProviderChanged((LabelProviderChangedEvent)event);
                            ++i;
                        }
                    }
                }
            };
            ProblemMarkerManager.getSingleton().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
            if (this.fProblemChangedListener != null && this.fListeners.isEmpty()) {
                ProblemMarkerManager.getSingleton().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        int errorState = this.getErrorState(element);
        if (errorState == 2) {
            decoration.addOverlay(PydevPlugin.getImageCache().getDescriptor("icons/error_decoration.gif"), 2);
        } else if (errorState == 1) {
            decoration.addOverlay(PydevPlugin.getImageCache().getDescriptor("icons/warning_decoration.gif"), 2);
        }
    }
}

