/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.model;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.python.pydev.core.PropertiesHelper;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.model.Location;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.shared_core.io.FileUtils;

public class ItemPointer {
    public final Object file;
    public final Location start;
    public final Location end;
    public final Definition definition;
    public final String zipFilePath;

    public ItemPointer(Object file) {
        this(file, new Location(), new Location());
    }

    public ItemPointer(Object file, SimpleNode n) {
        int line = n.beginLine;
        int col = n.beginColumn;
        this.file = file;
        this.start = new Location(line - 1, col - 1);
        this.end = new Location(line - 1, col - 1);
        this.definition = null;
        this.zipFilePath = null;
    }

    public ItemPointer(Object file, Location start, Location end) {
        this(file, start, end, null, null);
    }

    public ItemPointer(Object file, Location start, Location end, Definition definition, String zipFilePath) {
        this.file = file;
        this.start = start;
        this.end = end;
        this.definition = definition;
        this.zipFilePath = zipFilePath;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ItemPointer [");
        buffer.append(this.file);
        buffer.append(" - ");
        buffer.append(this.start);
        buffer.append(" - ");
        buffer.append(this.end);
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemPointer)) {
            return false;
        }
        ItemPointer i = (ItemPointer)obj;
        if (!i.file.equals(this.file)) {
            return false;
        }
        if (!i.start.equals(this.start)) {
            return false;
        }
        if (!i.end.equals(this.end)) {
            return false;
        }
        if (i.zipFilePath != null && this.zipFilePath == null) {
            return false;
        }
        return this.zipFilePath == null || this.zipFilePath.equals(i.zipFilePath);
    }

    public int hashCode() {
        int colLineBasedHash = (this.end.column + this.start.line + 7) * 3;
        if (this.file != null) {
            return this.file.hashCode() + colLineBasedHash;
        }
        return colLineBasedHash;
    }

    public String asPortableString() {
        IPath path;
        if (this.file instanceof IFile) {
            IFile f = (IFile)this.file;
            path = f.getRawLocation();
        } else if (this.file instanceof IPath) {
            path = (IPath)this.file;
        } else if (this.file instanceof File) {
            String absPath = FileUtils.getFileAbsolutePath((File)((File)this.file));
            path = Path.fromOSString((String)absPath);
        } else if (this.file instanceof String) {
            path = Path.fromOSString((String)((String)this.file));
        } else if (this.file == null) {
            path = null;
        } else {
            throw new RuntimeException("Don't know how to handle: " + this.file.getClass());
        }
        if (path == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.put("FILE_PATH", path.toPortableString());
        if (this.start != null) {
            properties.put("START_LINE", String.valueOf(this.start.line));
            properties.put("START_COL", String.valueOf(this.start.column));
        }
        if (this.end != null) {
            properties.put("END_LINE", String.valueOf(this.end.line));
            properties.put("END_COL", String.valueOf(this.end.column));
        }
        if (this.zipFilePath != null) {
            properties.put("ZIP", this.zipFilePath);
        }
        return PropertiesHelper.createStringFromProperties((Properties)properties);
    }

    public static ItemPointer fromPortableString(String asPortableString) {
        Properties properties = PropertiesHelper.createPropertiesFromString((String)asPortableString);
        String filePath = (String)properties.get("FILE_PATH");
        if (filePath == null) {
            return null;
        }
        String startLine = (String)properties.get("START_LINE");
        String startCol = (String)properties.get("START_COL");
        Location start = startLine != null && startCol != null ? new Location(Integer.parseInt(startLine), Integer.parseInt(startCol)) : new Location();
        String endLine = (String)properties.get("END_LINE");
        String endCol = (String)properties.get("END_COL");
        Location end = endLine != null && endCol != null ? new Location(Integer.parseInt(endLine), Integer.parseInt(endCol)) : new Location();
        String zip = (String)properties.get("ZIP");
        return new ItemPointer(Path.fromPortableString((String)filePath), start, end, null, zip);
    }
}

