/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;
import org.python.pydev.editor.codecompletion.shell.IronpythonShell;
import org.python.pydev.editor.codecompletion.shell.JythonShell;
import org.python.pydev.editor.codecompletion.shell.ProcessCreationInfo;
import org.python.pydev.editor.codecompletion.shell.PythonShell;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.net.LocalHost;
import org.python.pydev.shared_core.net.SocketUtil;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShell {
    public static final int BUFFER_SIZE = 1024;
    public static final int OTHERS_SHELL = 2;
    public static final int COMPLETION_SHELL = 1;
    protected static final int DEFAULT_SLEEP_BETWEEN_ATTEMPTS = 1000;
    protected static final int DEBUG_SHELL = -1;
    private final String TYPE_UNKNOWN_STR = "-1";
    private boolean inStart = false;
    private boolean isConnected = false;
    private boolean isInRead = false;
    private boolean isInWrite = false;
    private boolean isInRestart = false;
    private IInterpreterInfo shellInterpreter;
    private int shellMillis;
    private boolean isInOperation = false;
    private static final String ENCODING_UTF_8 = "UTF-8";
    protected static Map<String, Map<Integer, AbstractShell>> shells = new HashMap<String, Map<Integer, AbstractShell>>();
    private static boolean finishedForGood = false;
    protected Process process;
    protected Socket socketToWrite;
    protected Socket socketToRead;
    protected File serverFile;
    protected ServerSocket serverSocket;

    private static void dbg(String string, int priority) {
        if (priority <= -1) {
            System.out.println(string);
        }
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.toLogFile((String)string, AbstractShell.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stopServerShell(IInterpreterInfo interpreter, int id) {
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            Map<Integer, AbstractShell> typeToShell = AbstractShell.getTypeToShellFromId(interpreter);
            AbstractShell pythonShell = typeToShell.get(new Integer(id));
            if (pythonShell != null) {
                try {
                    pythonShell.endIt();
                }
                catch (Exception exception) {}
            }
            typeToShell.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdownAllShells() {
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                Log.toLogFile((String)"Shutting down all shells (for good)...", AbstractShell.class);
            }
            Iterator<Map<Integer, AbstractShell>> iter = shells.values().iterator();
            while (iter.hasNext()) {
                finishedForGood = true;
                Map<Integer, AbstractShell> rel = iter.next();
                if (rel == null) continue;
                for (AbstractShell element : rel.values()) {
                    if (element == null) continue;
                    try {
                        element.shutdown();
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
            shells.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String restartAllShells() {
        String ret = "";
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            try {
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    Log.toLogFile((String)"Restarting all shells and clearing caches...", AbstractShell.class);
                }
                for (Map<Integer, AbstractShell> val : shells.values()) {
                    IInterpreterManager[] interpreterManagers;
                    for (AbstractShell val2 : val.values()) {
                        if (val2 == null) continue;
                        val2.endIt();
                    }
                    IInterpreterManager[] iInterpreterManagerArray = interpreterManagers = PydevPlugin.getAllInterpreterManagers();
                    int n = interpreterManagers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IInterpreterManager iInterpreterManager = iInterpreterManagerArray[n2];
                        if (iInterpreterManager != null) {
                            try {
                                iInterpreterManager.clearCaches();
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                                ret = String.valueOf(ret) + e.getMessage() + "\n";
                            }
                        }
                        ++n2;
                    }
                    ModulesManager.clearCache();
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                ret = String.valueOf(ret) + e.getMessage() + "\n";
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Map<Integer, AbstractShell> getTypeToShellFromId(IInterpreterInfo interpreter) {
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            Map<Integer, AbstractShell> typeToShell = shells.get(interpreter.getExecutableOrJar());
            if (typeToShell == null) {
                typeToShell = new HashMap<Integer, AbstractShell>();
                shells.put(interpreter.getExecutableOrJar(), typeToShell);
            }
            return typeToShell;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void putServerShell(IPythonNature nature, int id, AbstractShell shell) {
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            try {
                Map<Integer, AbstractShell> typeToShell = AbstractShell.getTypeToShellFromId(nature.getProjectInterpreter());
                typeToShell.put(new Integer(id), shell);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static synchronized AbstractShell getServerShell(IPythonNature nature, int id) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        return AbstractShell.getServerShell(nature.getProjectInterpreter(), nature.getInterpreterType(), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized AbstractShell getServerShell(IInterpreterInfo interpreter, int relatedTo, int id) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException {
        AbstractShell pythonShell = null;
        Map<String, Map<Integer, AbstractShell>> map = shells;
        synchronized (map) {
            Map<Integer, AbstractShell> typeToShell;
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                Log.toLogFile((String)"Synchronizing on shells...", AbstractShell.class);
            }
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                String flavor;
                switch (relatedTo) {
                    case 1: {
                        flavor = "Jython";
                        break;
                    }
                    case 2: {
                        flavor = "IronPython";
                        break;
                    }
                    default: {
                        flavor = "Python";
                    }
                }
                Log.toLogFile((String)("Getting shell related to:" + flavor + " id:" + id + " interpreter: " + interpreter.getExecutableOrJar()), AbstractShell.class);
            }
            if ((pythonShell = (typeToShell = AbstractShell.getTypeToShellFromId(interpreter)).get(new Integer(id))) == null) {
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    Log.toLogFile((String)"pythonShell == null", AbstractShell.class);
                }
                if (relatedTo == 0) {
                    pythonShell = new PythonShell();
                } else if (relatedTo == 1) {
                    pythonShell = new JythonShell();
                } else if (relatedTo == 2) {
                    pythonShell = new IronpythonShell();
                } else {
                    throw new RuntimeException("unknown related id");
                }
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    Log.toLogFile((String)"pythonShell.startIt()", AbstractShell.class);
                    Log.addLogLevel();
                }
                pythonShell.startIt(interpreter, 1000);
                if (DebugSettings.DEBUG_CODE_COMPLETION) {
                    Log.remLogLevel();
                    Log.toLogFile((String)"Finished pythonShell.startIt()", AbstractShell.class);
                }
                typeToShell.put(new Integer(id), pythonShell);
            }
        }
        return pythonShell;
    }

    protected AbstractShell(File f) throws IOException, CoreException {
        if (finishedForGood) {
            throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to create a new shell.");
        }
        this.serverFile = f;
        if (!this.serverFile.exists()) {
            throw new RuntimeException("Can't find python server file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sleepALittle(int t) {
        try {
            AbstractShell abstractShell = this;
            synchronized (abstractShell) {
                this.wait(t);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void startIt(IPythonNature nature) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        AbstractShell abstractShell = this;
        synchronized (abstractShell) {
            this.startIt(nature.getProjectInterpreter(), 1000);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void startIt(IInterpreterInfo interpreter, int milisSleep) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException {
        block23: {
            this.shellMillis = milisSleep;
            this.shellInterpreter = interpreter;
            if (this.inStart || this.isConnected) {
                return;
            }
            this.inStart = true;
            try {
                if (AbstractShell.finishedForGood) {
                    throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to restart it.");
                }
                try {
                    this.serverSocket = new ServerSocket(0);
                    pRead = this.serverSocket.getLocalPort();
                    SocketUtil.checkValidPort((int)pRead);
                    pWrite = SocketUtil.findUnusedLocalPorts((int)1)[0];
                    if (this.process != null) {
                        this.endIt();
                    }
                    processInfo = this.createServerProcess(interpreter, pWrite, pRead);
                    AbstractShell.dbg("executed: " + processInfo.getProcessLog(), 1);
                    this.sleepALittle(200);
                    if (this.process == null) {
                        msg = "Error creating python process - got null process.\n" + processInfo.getProcessLog();
                        AbstractShell.dbg(msg, 1);
                        Log.log((String)msg);
                        throw new CoreException((IStatus)PydevPlugin.makeStatus(4, msg, new Exception(msg)));
                    }
                    try {
                        exitVal = this.process.exitValue();
                        msg = "Error creating python process - exited before creating sockets - exitValue = (" + exitVal + ").\n" + processInfo.getProcessLog();
                        AbstractShell.dbg(msg, 1);
                        Log.log((String)msg);
                        throw new CoreException((IStatus)PydevPlugin.makeStatus(4, msg, new Exception(msg)));
                    }
                    catch (IllegalThreadStateException v0) {
                        AbstractShell.dbg("afterCreateProcess ", 1);
                        connected = false;
                        attempts = 0;
                        AbstractShell.dbg("connecting... ", 1);
                        this.sleepALittle(milisSleep);
                        this.socketToWrite = null;
                        maxAttempts = PyCodeCompletionPreferencesPage.getNumberOfConnectionAttempts();
                        AbstractShell.dbg("attempts: " + attempts, 1);
                        AbstractShell.dbg("maxAttempts: " + maxAttempts, 1);
                        AbstractShell.dbg("finishedForGood: " + AbstractShell.finishedForGood, 1);
                        ** while (!connected && attempts < maxAttempts && !AbstractShell.finishedForGood)
                    }
lbl-1000:
                    // 1 sources

                    {
                        block22: {
                            AbstractShell.dbg("connecting attept..." + ++attempts, 1);
                            try {
                                if (this.socketToWrite == null || !this.socketToWrite.isConnected()) {
                                    this.socketToWrite = new Socket(LocalHost.getLocalHost(), pWrite);
                                }
                                if (this.socketToWrite != null || this.socketToWrite.isConnected()) {
                                    try {
                                        AbstractShell.dbg("serverSocket.accept()! ", 1);
                                        this.socketToRead = this.serverSocket.accept();
                                        AbstractShell.dbg("socketToRead.setSoTimeout(5000) ", 1);
                                        this.socketToRead.setSoTimeout(5000);
                                        connected = true;
                                        AbstractShell.dbg("connected! ", 1);
                                    }
                                    catch (SocketTimeoutException v1) {}
                                }
                            }
                            catch (IOException e1) {
                                if (this.socketToWrite != null && this.socketToWrite.isConnected()) {
                                    msg = "Attempt: " + attempts + " of " + maxAttempts + " failed, trying again...(socketToWrite already binded)";
                                    AbstractShell.dbg(msg, 1);
                                    Log.log((int)4, (String)msg, (Throwable)e1);
                                }
                                if (this.socketToWrite == null || this.socketToWrite.isConnected()) break block22;
                                msg = "Attempt: " + attempts + " of " + maxAttempts + " failed, trying again...(socketToWrite still not binded)";
                                AbstractShell.dbg(msg, 1);
                                Log.log((int)4, (String)msg, (Throwable)e1);
                            }
                        }
                        if (connected) continue;
                        this.sleepALittle(milisSleep);
                        continue;
                    }
lbl74:
                    // 1 sources

                    if (connected || AbstractShell.finishedForGood) break block23;
                    AbstractShell.dbg("NOT connected ", 1);
                    try {
                        exitVal = this.process.exitValue();
                        isAlive = " - the process in NOT ALIVE anymore (output=" + exitVal + ") - ";
                    }
                    catch (IllegalThreadStateException v2) {
                        isAlive = " - the process in still alive (killing it now)- ";
                        this.process.destroy();
                    }
                    msg = "Error connecting to python process.\n" + isAlive + "\n" + processInfo.getProcessLog();
                    exception = new RuntimeException(msg);
                    AbstractShell.dbg(msg, 1);
                    Log.log((Throwable)exception);
                    throw exception;
                }
                catch (IOException e) {
                    if (this.process != null) {
                        this.process.destroy();
                        this.process = null;
                    }
                    throw e;
                }
            }
            finally {
                this.inStart = false;
            }
        }
        this.isConnected = true;
    }

    protected abstract ProcessCreationInfo createServerProcess(IInterpreterInfo var1, int var2, int var3) throws IOException, JDTNotAvailableException, MisconfigurationException;

    protected synchronized void communicateWork(String desc, IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.setTaskName(desc);
            monitor.worked(1);
        }
    }

    public synchronized void clearSocket() throws IOException {
        long maxTime = System.currentTimeMillis() + 50000L;
        while (System.currentTimeMillis() < maxTime) {
            byte[] b = new byte[1024];
            if (this.socketToRead != null) {
                this.socketToRead.getInputStream().read(b);
                String s = new String(b);
                s = s.replaceAll("\u0000", "");
                if (s.length() != 0) continue;
                return;
            }
            return;
        }
    }

    public synchronized String read(IProgressMonitor monitor) throws IOException {
        if (finishedForGood) {
            throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to read from it.");
        }
        if (this.inStart) {
            throw new RuntimeException("The shell is still not completely started, so, it is an invalid state to try to read from it..");
        }
        if (!this.isConnected) {
            throw new RuntimeException("The shell is still not connected, so, it is an invalid state to try to read from it..");
        }
        if (this.isInRead) {
            throw new RuntimeException("The shell is already in read mode, so, it is an invalid state to try to read from it..");
        }
        if (this.isInWrite) {
            throw new RuntimeException("The shell is already in write mode, so, it is an invalid state to try to read from it..");
        }
        this.isInRead = true;
        try {
            block18: {
                StringBuffer str = new StringBuffer();
                int j = 0;
                while (j < 200) {
                    byte[] b = new byte[1024];
                    this.socketToRead.getInputStream().read(b);
                    String s = new String(b);
                    if (s.indexOf("@@PROCESSING_END@@") != -1) {
                        s = s.replaceAll("@@PROCESSING_END@@", "");
                        j = 0;
                        this.communicateWork("Processing...", monitor);
                    }
                    if (s.indexOf("@@PROCESSING:") != -1) {
                        s = s.replaceAll("@@PROCESSING:", "");
                        s = s.replaceAll("END@@", "");
                        j = 0;
                        if (!(s = URLDecoder.decode(s, ENCODING_UTF_8)).trim().equals("")) {
                            this.communicateWork("Processing: " + s, monitor);
                        } else {
                            this.communicateWork("Processing...", monitor);
                        }
                        s = "";
                    }
                    s = s.replaceAll("\u0000", "");
                    str.append(s);
                    if (str.indexOf("END@@") != -1) break;
                    j = s.length() == 0 ? ++j : 0;
                    this.sleepALittle(10);
                }
                String ret = str.toString().replaceFirst("@@COMPLETIONS", "");
                try {
                    if (ret.indexOf("END@@") == -1) break block18;
                    String string = ret = ret.substring(0, ret.indexOf("END@@"));
                    return string;
                }
                catch (RuntimeException e) {
                    if (ret.length() > 500) {
                        ret = String.valueOf(ret.substring(0, 499)) + "...(continued)...";
                    }
                    Log.log((int)4, (String)("ERROR WITH STRING:" + ret), (Throwable)e);
                    return "";
                }
            }
            throw new RuntimeException("Couldn't find END@@ on received string.");
        }
        finally {
            this.isInRead = false;
        }
    }

    protected synchronized String read() throws IOException {
        String r = this.read(null);
        return r;
    }

    public synchronized void write(String str) throws IOException {
        if (finishedForGood) {
            throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to write to it.");
        }
        if (this.inStart) {
            throw new RuntimeException("The shell is still not completely started, so, it is an invalid state to try to write to it.");
        }
        if (!this.isConnected) {
            throw new RuntimeException("The shell is still not connected, so, it is an invalid state to try to write to it.");
        }
        if (this.isInRead) {
            throw new RuntimeException("The shell is already in read mode, so, it is an invalid state to try to write to it.");
        }
        if (this.isInWrite) {
            throw new RuntimeException("The shell is already in write mode, so, it is an invalid state to try to write to it.");
        }
        this.isInWrite = true;
        try {
            OutputStream outputStream = this.socketToWrite.getOutputStream();
            outputStream.write(str.getBytes());
            outputStream.flush();
        }
        finally {
            this.isInWrite = false;
        }
    }

    private synchronized void closeConn() throws IOException {
        try {
            if (this.socketToWrite != null) {
                this.socketToWrite.close();
            }
        }
        catch (Exception exception) {}
        this.socketToWrite = null;
        try {
            if (this.socketToRead != null) {
                this.socketToRead.close();
            }
        }
        catch (Exception exception) {}
        this.socketToRead = null;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception exception) {}
        this.serverSocket = null;
    }

    public synchronized void shutdown() {
        this.socketToRead = null;
        this.socketToWrite = null;
        this.serverSocket = null;
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    public synchronized void endIt() {
        try {
            this.closeConn();
        }
        catch (Exception exception) {}
        this.isConnected = false;
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    public synchronized Tuple<String, List<String[]>> getImportCompletions(String str, List<String> pythonpath) throws CoreException {
        while (this.isInOperation) {
            this.sleepALittle(25);
        }
        this.isInOperation = true;
        try {
            this.internalChangePythonPath(pythonpath);
            try {
                str = URLEncoder.encode(str, ENCODING_UTF_8);
                Tuple<String, List<String[]>> tuple = this.getTheCompletions("@@IMPORTS:" + str + "\nEND@@");
                return tuple;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.isInOperation = false;
        }
    }

    public synchronized void changePythonPath(List<String> pythonpath) throws CoreException {
        while (this.isInOperation) {
            this.sleepALittle(25);
        }
        this.isInOperation = true;
        try {
            this.internalChangePythonPath(pythonpath);
        }
        finally {
            this.isInOperation = false;
        }
    }

    private void internalChangePythonPath(List<String> pythonpath) {
        if (finishedForGood) {
            throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to change its dir.");
        }
        StringBuffer buffer = new StringBuffer();
        for (String path : pythonpath) {
            buffer.append(path);
            buffer.append("|");
        }
        try {
            this.getTheCompletions("@@CHANGE_PYTHONPATH:" + URLEncoder.encode(buffer.toString(), ENCODING_UTF_8) + "\nEND@@");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected synchronized Tuple<String, List<String[]>> getTheCompletions(String str) throws CoreException {
        try {
            this.write(str);
            return this.getCompletions();
        }
        catch (NullPointerException nullPointerException) {
            this.restartShell();
            return this.getInvalidCompletion();
        }
        catch (Exception e) {
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                Log.log((int)4, (String)"ERROR getting completions.", (Throwable)e);
            }
            this.restartShell();
            return this.getInvalidCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restartShell() throws CoreException {
        if (!this.isInRestart) {
            this.isInRestart = true;
            try {
                if (finishedForGood) {
                    throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to restart a new shell.");
                }
                try {
                    this.endIt();
                }
                catch (Exception exception) {}
                try {
                    AbstractShell abstractShell = this;
                    synchronized (abstractShell) {
                        this.startIt(this.shellInterpreter, this.shellMillis);
                    }
                }
                catch (Exception e) {
                    Log.log((int)4, (String)"ERROR restarting shell.", (Throwable)e);
                }
            }
            finally {
                this.isInRestart = false;
            }
        }
    }

    protected synchronized Tuple<String, List<String[]>> getInvalidCompletion() {
        ArrayList l = new ArrayList();
        return new Tuple(null, l);
    }

    protected synchronized Tuple<String, List<String[]>> getCompletions() throws IOException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String read = this.read();
        String string = read.replaceAll("\\(", "").replaceAll("\\)", "");
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        String file = "";
        if (tokenizer.hasMoreTokens()) {
            file = URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8);
            while (tokenizer.hasMoreTokens()) {
                String token = URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8);
                if (!tokenizer.hasMoreTokens()) {
                    return new Tuple((Object)file, list);
                }
                String description = URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8);
                String args = "";
                if (tokenizer.hasMoreTokens()) {
                    args = URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8);
                }
                String type = "-1";
                if (tokenizer.hasMoreTokens()) {
                    type = URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8);
                }
                if (!token.equals("ERROR:")) {
                    list.add(new String[]{token, description, args, type});
                    continue;
                }
                if (!DebugSettings.DEBUG_CODE_COMPLETION) continue;
                Log.addLogLevel();
                try {
                    Log.toLogFile((String)"Code completion shell error:", AbstractShell.class);
                    Log.toLogFile((String)token, AbstractShell.class);
                    Log.toLogFile((String)description, AbstractShell.class);
                    Log.toLogFile((String)args, AbstractShell.class);
                    Log.toLogFile((String)type, AbstractShell.class);
                }
                finally {
                    Log.remLogLevel();
                }
            }
        }
        return new Tuple((Object)file, list);
    }

    public synchronized Tuple<String[], int[]> getLineCol(String moduleName, String token, List<String> pythonpath) {
        while (this.isInOperation) {
            this.sleepALittle(25);
        }
        this.isInOperation = true;
        try {
            List def;
            Tuple<String, List<String[]>> theCompletions;
            block10: {
                String str = String.valueOf(moduleName) + "." + token;
                this.internalChangePythonPath(pythonpath);
                try {
                    str = URLEncoder.encode(str, ENCODING_UTF_8);
                    theCompletions = this.getTheCompletions("@@SEARCH" + str + "\nEND@@");
                    def = (List)theCompletions.o2;
                    if (def.size() != 0) break block10;
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String[] comps = (String[])def.get(0);
            if (comps.length == 0) {
                return null;
            }
            int line = Integer.parseInt(comps[0]);
            int col = Integer.parseInt(comps[1]);
            String foundAs = comps[2];
            Tuple tuple = new Tuple((Object)new String[]{(String)theCompletions.o1, foundAs}, (Object)new int[]{line, col});
            return tuple;
        }
        finally {
            this.isInOperation = false;
        }
    }
}

